/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class WandTemplate
extends BaseMagicProperties
implements com.elmakers.mine.bukkit.api.wand.WandTemplate {
    private final String key;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private Set<String> tags;
    @Nonnull
    private Set<String> categories = ImmutableSet.of();
    private String creator;
    private String creatorId;
    private String migrateTemplate;
    private String migrateIcon;
    private String icon;
    private boolean restorable;
    private Map<String, String> migrateIcons;
    private ConfigurationSection attributes;
    private String attributeSlot;

    public WandTemplate(MageController controller, String key, ConfigurationSection node) {
        super(controller);
        List<String> tagList;
        this.load(node);
        this.key = key;
        this.effects.clear();
        this.creator = node.getString("creator");
        this.creatorId = node.getString("creator_id");
        this.migrateTemplate = node.getString("migrate_to");
        this.migrateIcon = node.getString("migrate_icon");
        this.restorable = node.getBoolean("restorable", true);
        this.icon = node.getString("icon");
        this.attributes = node.getConfigurationSection("attributes");
        this.attributeSlot = node.getString("attribute_slot");
        this.clearProperty("creator");
        this.clearProperty("creator_id");
        this.clearProperty("migrate_to");
        this.clearProperty("migrate_icon");
        this.clearProperty("restorable");
        this.clearProperty("hidden");
        this.clearProperty("enabled");
        this.clearProperty("inherit");
        ConfigurationSection migrateConfig = node.getConfigurationSection("migrate_icons");
        if (migrateConfig != null) {
            this.migrateIcons = new HashMap<String, String>();
            Set keys = migrateConfig.getKeys(false);
            for (String migrateKey : keys) {
                this.migrateIcons.put(migrateKey, migrateConfig.getString(migrateKey));
            }
            this.clearProperty("migrate_icons");
        }
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(controller.getPlugin(), effectsNode, effectKey));
            }
            this.clearProperty("effects");
        }
        if ((tagList = ConfigurationUtils.getStringList(node, "tags")) != null) {
            this.tags = new HashSet<String>(tagList);
            this.clearProperty("tags");
        } else {
            this.tags = null;
        }
        List<String> categoriesList = ConfigurationUtils.getStringList(node, "categories");
        if (categoriesList != null) {
            this.clearProperty("categories");
            this.categories = ImmutableSet.copyOf(categoriesList);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>(effectList);
    }

    @Override
    public boolean playEffects(Wand wand, String key) {
        return this.playEffects(wand.getMage(), wand, key, 1.0f);
    }

    @Override
    public boolean playEffects(Wand wand, String effectName, float scale) {
        return this.playEffects(wand.getMage(), wand, this.key, scale);
    }

    @Override
    @Deprecated
    public boolean playEffects(Mage mage, String key) {
        return this.playEffects(mage, mage.getActiveWand(), key, 1.0f);
    }

    @Override
    @Deprecated
    public boolean playEffects(Mage mage, String effectName, float scale) {
        return this.playEffects(mage, mage.getActiveWand(), effectName, scale);
    }

    private boolean playEffects(Mage mage, Wand wand, String effectName, float scale) {
        Preconditions.checkNotNull((Object)mage, (Object)"mage");
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effects = this.getEffects(effectName);
        if (effects.isEmpty()) {
            return false;
        }
        Entity sourceEntity = mage.getEntity();
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effects) {
            player.setScale(scale);
            player.setColor(wand == null ? mage.getEffectColor() : wand.getEffectColor());
            String overrideParticle = wand == null ? mage.getEffectParticleName() : wand.getEffectParticleName();
            player.setParticleOverride(overrideParticle);
            Location source = null;
            if (player.shouldUseWandLocation()) {
                source = wand == null ? mage.getCastLocation() : wand.getLocation();
            } else if (player.shouldUseEyeLocation()) {
                source = mage.getEyeLocation();
            }
            if (source == null) {
                source = mage.getLocation();
            }
            player.start(source, sourceEntity, null, null, null);
        }
        return true;
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.WandTemplate getMigrateTemplate() {
        return this.migrateTemplate == null ? null : this.controller.getWandTemplate(this.migrateTemplate);
    }

    @Override
    public String migrateIcon(String currentIcon) {
        String newIcon;
        if (this.icon != null && this.migrateIcon != null && this.migrateIcon.equals(currentIcon)) {
            return this.icon;
        }
        if (this.migrateIcons != null && (newIcon = this.migrateIcons.get(currentIcon)) != null) {
            return newIcon;
        }
        return currentIcon;
    }

    @Override
    @Deprecated
    public boolean isSoul() {
        return false;
    }

    @Override
    public boolean isRestorable() {
        return this.restorable;
    }

    @Override
    public ConfigurationSection getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttributeSlot() {
        return this.attributeSlot;
    }
}

