/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

@Deprecated
public class UndoSpell
extends TargetingSpell {
    private String undoListName;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target target = this.getTarget();
        int timeout = parameters.getInt("target_timeout", 0);
        boolean targetSelf = parameters.getBoolean("target_up_self", false);
        boolean targetDown = parameters.getBoolean("target_down_block", false);
        Entity targetEntity = target.getEntity();
        SpellResult result = SpellResult.CAST;
        if (targetSelf && this.isLookingUp()) {
            targetEntity = this.mage.getEntity();
            this.getCurrentCast().setTargetName(this.mage.getName());
            result = SpellResult.ALTERNATE_UP;
        }
        if (targetEntity != null && this.controller.isMage(targetEntity)) {
            Mage targetMage = this.controller.getMage(targetEntity);
            Batch batch = targetMage.cancelPending();
            if (batch != null) {
                this.undoListName = batch instanceof SpellBatch ? ((SpellBatch)batch).getSpell().getName() : null;
                return SpellResult.ALTERNATE;
            }
            UndoQueue queue = targetMage.getUndoQueue();
            UndoList undoList = queue.undoRecent(timeout);
            if (undoList != null) {
                this.undoListName = undoList.getName();
            }
            return undoList != null ? result : SpellResult.NO_TARGET;
        }
        if (!parameters.getBoolean("target_blocks", true)) {
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        if (targetDown && this.isLookingDown()) {
            targetBlock = this.getLocation().getBlock();
        }
        if (targetBlock != null) {
            boolean targetAll = this.mage.isSuperPowered();
            if (targetAll) {
                UndoList undid = this.controller.undoRecent(targetBlock, timeout);
                if (undid != null) {
                    Mage targetMage = undid.getOwner();
                    this.undoListName = undid.getName();
                    this.getCurrentCast().setTargetName(targetMage.getName());
                    return result;
                }
            } else {
                this.getCurrentCast().setTargetName(this.mage.getName());
                UndoList undoList = this.mage.undo(targetBlock);
                if (undoList != null) {
                    this.undoListName = undoList.getName();
                    return result;
                }
            }
        }
        return SpellResult.NO_TARGET;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$spell", this.undoListName == null ? "Unknown" : this.undoListName);
    }
}

