/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.maps.MapController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CameraSpell
extends TargetingSpell {
    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String url;
        ItemStack newMapItem = null;
        Integer priority = ConfigurationUtils.getInteger(parameters, "priority", null);
        if (parameters.contains("id")) {
            newMapItem = new ItemStack(Material.MAP, 1, (short)parameters.getInt("id", 0));
            String mapName = parameters.getString("name", "Image");
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(mapName);
            newMapItem.setItemMeta(meta);
        }
        MapController maps = this.controller.getMaps();
        if (newMapItem == null && (url = parameters.getString("url")) != null) {
            int x = parameters.getInt("x", 0);
            int y = parameters.getInt("y", 0);
            int width = parameters.getInt("width", 0);
            int height = parameters.getInt("height", 0);
            String mapName = parameters.getString("name", "Photo");
            newMapItem = maps.getURLItem(this.getWorld().getName(), url, mapName, x, y, width, height, priority);
        }
        if (newMapItem == null) {
            Target target = this.getTarget();
            String playerName = parameters.getString("name");
            String metaName = null;
            if (playerName == null) {
                if (target != null) {
                    if (target.hasEntity()) {
                        Entity targetEntity = target.getEntity();
                        if (targetEntity instanceof Player) {
                            playerName = ((Player)targetEntity).getName();
                        } else {
                            playerName = this.getMobSkin(targetEntity.getType());
                            if (playerName != null) {
                                metaName = targetEntity.getType().getName();
                            }
                        }
                    } else {
                        Block targetBlock = target.getBlock();
                        if (targetBlock == null) {
                            return SpellResult.NO_TARGET;
                        }
                        playerName = this.getBlockSkin(targetBlock.getType());
                        if (playerName != null) {
                            metaName = target.getBlock().getType().name();
                        }
                    }
                }
                if (playerName == null) {
                    Player player = this.mage.getPlayer();
                    if (player == null) {
                        return SpellResult.NO_TARGET;
                    }
                    playerName = player.getName();
                }
            }
            if (parameters.contains("reload")) {
                maps.forceReloadPlayerPortrait(this.getWorld().getName(), playerName);
            }
            metaName = metaName == null ? playerName : metaName;
            newMapItem = maps.getPlayerPortrait(this.getWorld().getName(), playerName, priority, "Photo of " + metaName);
        }
        if (newMapItem == null) {
            return SpellResult.FAIL;
        }
        this.getWorld().dropItemNaturally(this.getLocation(), newMapItem);
        return SpellResult.CAST;
    }
}

