/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class ConfigurationLoadTask
implements Runnable {
    private final MagicController controller;
    private final CommandSender sender;
    protected ConfigurationSection configuration;
    protected ConfigurationSection messages;
    protected ConfigurationSection materials;
    protected ConfigurationSection wands;
    protected ConfigurationSection paths;
    protected ConfigurationSection crafting;
    protected ConfigurationSection mobs;
    protected ConfigurationSection items;
    protected ConfigurationSection classes;
    protected Map<String, ConfigurationSection> spells;
    protected boolean success;

    public ConfigurationLoadTask(MagicController controller, CommandSender sender) {
        this.controller = controller;
        this.sender = sender;
    }

    public void runNow() {
        this.run(true);
    }

    @Override
    public void run() {
        this.run(false);
    }

    public void run(boolean synchronous) {
        this.success = true;
        Logger logger = this.controller.getLogger();
        try {
            this.configuration = this.controller.loadMainConfiguration();
            this.configuration = this.controller.loadExamples(this.configuration);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading config.yml", ex);
            this.success = false;
        }
        try {
            this.messages = this.controller.loadMessageConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading messages.yml", ex);
            this.success = false;
        }
        try {
            this.materials = this.controller.loadMaterialsConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading material.yml", ex);
            this.success = false;
        }
        try {
            this.spells = this.controller.loadAndMapSpells();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading spells.yml", ex);
            this.success = false;
        }
        try {
            this.paths = this.controller.loadPathConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading paths.yml", ex);
            this.success = false;
        }
        try {
            this.wands = this.controller.loadWandConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading wands.yml", ex);
            this.success = false;
        }
        try {
            this.crafting = this.controller.loadCraftingConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading crafting.yml", ex);
            this.success = false;
        }
        try {
            this.classes = this.controller.loadClassConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading classes.yml", ex);
            this.success = false;
        }
        try {
            this.mobs = this.controller.loadMobsConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading mobs.yml", ex);
            this.success = false;
        }
        try {
            this.items = this.controller.loadItemsConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading items.yml", ex);
            this.success = false;
        }
        if (synchronous) {
            this.controller.finalizeLoad(this, this.sender);
        } else {
            MagicPlugin plugin = this.controller.getPlugin();
            final ConfigurationLoadTask result = this;
            plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    ConfigurationLoadTask.this.controller.finalizeLoad(result, ConfigurationLoadTask.this.sender);
                }
            });
        }
    }
}

