/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration;

import com.elmakers.mine.bukkit.api.attributes.AttributeProvider;
import com.elmakers.mine.bukkit.magic.ManaController;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.manager.AttributeManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkillAPIManager
implements ManaController,
AttributeProvider {
    private final Plugin skillAPIPlugin;
    private final Plugin owningPlugin;
    private Set<String> attributes = new HashSet<String>();
    private AttributeManager attributeManager;

    public SkillAPIManager(Plugin owningPlugin, Plugin skillAPIPlugin) {
        this.owningPlugin = owningPlugin;
        this.skillAPIPlugin = skillAPIPlugin;
    }

    public boolean initialize() {
        if (this.skillAPIPlugin == null) {
            return false;
        }
        if (!(this.skillAPIPlugin instanceof SkillAPI)) {
            return false;
        }
        this.attributeManager = SkillAPI.getAttributeManager();
        if (this.attributeManager == null) {
            this.attributes = null;
            this.owningPlugin.getLogger().warning("SkillAPI but but attributes are disabled");
        } else {
            this.attributes = this.attributeManager.getKeys();
            this.owningPlugin.getLogger().info("SkillAPI Attributes: " + this.attributes);
        }
        return true;
    }

    @Override
    public Set<String> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Double getAttributeValue(String attribute, Player player) {
        if (this.attributes == null || !this.attributes.contains(attribute)) {
            return null;
        }
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return playerData.getAttribute(attribute);
    }

    @Override
    public int getMaxMana(Player player) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return (int)playerData.getMaxMana();
    }

    @Override
    public int getManaRegen(Player player) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        Collection classes = playerData.getClasses();
        double amount = 0.0;
        for (PlayerClass c : classes) {
            if (!c.getData().hasManaRegen()) continue;
            amount += c.getData().getManaRegen();
        }
        return (int)amount;
    }

    @Override
    public float getMana(Player player) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        return (float)playerData.getMana();
    }

    @Override
    public void removeMana(Player player, float amount) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        playerData.setMana(Math.max(0.0, playerData.getMana() - (double)amount));
    }

    @Override
    public void setMana(Player player, float amount) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        playerData.setMana((double)amount);
    }
}

