/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.item.Cost;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SelectorAction
extends BaseSpellAction
implements GUIAction,
CostReducer {
    protected double costScale = 1.0;
    protected boolean autoClose = true;
    protected boolean showConfirmation = true;
    protected SelectorConfiguration defaultConfiguration;
    protected MaterialAndData confirmFillMaterial;
    protected CastContext context;
    private Map<Integer, SelectorOption> showingItems;
    private int numSlots;
    private int has = 0;
    private String title;
    private String confirmTitle;
    private boolean isActive = false;
    private SpellResult finalResult = null;

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("slot");
        }
        this.isActive = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    protected String getDefaultMessage(CastContext context, String key) {
        return context.getController().getMessages().get("shops." + key);
    }

    protected String getDefaultMessage(CastContext context, String key, String defaultValue) {
        return context.getController().getMessages().get("shops." + key, defaultValue);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        Mage mage = this.context.getMage();
        if (item == null || !InventoryUtils.hasMeta(item, "slot")) {
            if (!this.autoClose) {
                mage.deactivateGUI();
            }
            return;
        }
        int slotIndex = Integer.parseInt(InventoryUtils.getMetaString(item, "slot"));
        MageController controller = this.context.getController();
        SelectorOption option = this.showingItems.get(slotIndex);
        if (option == null) {
            return;
        }
        Cost required = option.getRequiredCost(this, this.context);
        if (required != null) {
            String baseMessage = this.context.getMessage("insufficient", this.getDefaultMessage(this.context, "insufficient"));
            String costDescription = required.getFullDescription(controller.getMessages(), mage);
            costDescription = baseMessage.replace("$cost", costDescription);
            this.context.showMessage(costDescription);
        } else {
            String itemName = option.getName();
            if (InventoryUtils.hasMeta(item, "confirm")) {
                String inventoryTitle = this.context.getMessage("confirm_title", this.getDefaultMessage(this.context, "confirm_title", this.confirmTitle)).replace("$item", itemName);
                Inventory confirmInventory = CompatibilityUtils.createInventory(null, 9, inventoryTitle);
                InventoryUtils.removeMeta(item, "confirm");
                for (int i = 0; i < 9; ++i) {
                    if (i != 4) {
                        ItemStack filler = this.confirmFillMaterial.getItemStack(1);
                        ItemMeta meta = filler.getItemMeta();
                        if (meta != null) {
                            meta.setDisplayName(ChatColor.DARK_GRAY + (i < 4 ? "-->" : "<--"));
                            filler.setItemMeta(meta);
                        }
                        confirmInventory.setItem(i, filler);
                        continue;
                    }
                    confirmInventory.setItem(i, item);
                }
                mage.deactivateGUI();
                this.isActive = true;
                mage.activateGUI(this, confirmInventory);
                return;
            }
            this.finalResult = option.give(this, this.context);
            if (this.finalResult.isSuccess()) {
                this.context.showMessage(option.getSelectedMessage(this));
            }
        }
        if (this.autoClose || this.finalResult != SpellResult.CAST) {
            mage.deactivateGUI();
        } else {
            mage.continueGUI(this, this.getInventory(this.context));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.context = context;
        this.defaultConfiguration = new SelectorConfiguration(parameters);
        this.showConfirmation = parameters.getBoolean("confirm", true);
        this.confirmFillMaterial = ConfigurationUtils.getMaterialAndData(parameters, "confirm_filler", new MaterialAndData(Material.AIR));
        this.autoClose = parameters.getBoolean("auto_close", true);
        this.costScale = parameters.getDouble("scale", 1.0);
        this.title = parameters.getString("title");
        this.confirmTitle = parameters.getString("confirm_title");
        if (!this.autoClose) {
            this.showConfirmation = false;
        }
        this.finalResult = null;
        this.isActive = false;
        this.numSlots = 0;
        this.showingItems = new HashMap<Integer, SelectorOption>();
        this.has = 0;
        Collection<ConfigurationSection> optionConfigs = ConfigurationUtils.getNodeList(parameters, "options");
        if (optionConfigs != null) {
            ArrayList<SelectorOption> options = new ArrayList<SelectorOption>();
            for (ConfigurationSection configurationSection : optionConfigs) {
                SelectorOption newOption = new SelectorOption(this.defaultConfiguration, configurationSection, this);
                if (newOption.hasLimit() && newOption.has(context)) {
                    ++this.has;
                }
                options.add(newOption);
            }
            for (SelectorOption selectorOption : options) {
                if (!selectorOption.checkContext(context, true).isSuccess()) continue;
                Integer targetSlot = selectorOption.getSlot();
                int slot = targetSlot == null ? this.numSlots : targetSlot;
                this.showingItems.put(slot, selectorOption);
                this.numSlots = Math.max(slot + 1, this.numSlots);
            }
        }
    }

    public SpellResult showItems(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.isActive = true;
        this.finalResult = SpellResult.NO_ACTION;
        Inventory displayInventory = this.getInventory(context);
        mage.activateGUI(this, displayInventory);
        return SpellResult.PENDING;
    }

    protected String getInventoryTitle(CastContext context) {
        return context.getMessage("title", this.getDefaultMessage(context, "title", this.title));
    }

    protected String getBalanceDescription(CastContext context) {
        Mage mage = context.getMage();
        double balance = VaultController.getInstance().getBalance(mage.getPlayer());
        return VaultController.getInstance().format(balance);
    }

    protected Inventory getInventory(CastContext context) {
        String inventoryTitle = this.getInventoryTitle(context);
        String balanceDescription = this.getBalanceDescription(context);
        inventoryTitle = inventoryTitle.replace("$balance", balanceDescription);
        int invSize = (int)Math.ceil((float)this.numSlots / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (Map.Entry<Integer, SelectorOption> entry : this.showingItems.entrySet()) {
            ItemStack icon = entry.getValue().getIcon();
            InventoryUtils.setMeta(icon, "slot", Integer.toString(entry.getKey()));
            if (this.showConfirmation) {
                InventoryUtils.setMeta(icon, "confirm", "true");
            }
            displayInventory.setItem(entry.getKey().intValue(), icon);
        }
        return displayInventory;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("confirm");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("auto_upgrade");
        parameters.add("require_wand");
        parameters.add("permission");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        MageController controller = spell.getController();
        if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(controller.getWandPathKeys());
        } else if (parameterKey.equals("require_wand") || parameterKey.equals("confirm") || parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        this.isActive = false;
        this.finalResult = null;
    }

    public SpellResult checkContext(CastContext context) {
        return this.defaultConfiguration.checkContext(context, false);
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.isActive) {
            return SpellResult.PENDING;
        }
        if (this.finalResult != null) {
            return this.finalResult;
        }
        SpellResult contextResult = this.checkContext(context);
        if (!contextResult.isSuccess()) {
            return contextResult;
        }
        if (this.showingItems.isEmpty()) {
            context.showMessage("no_items", this.getDefaultMessage(context, "no_items"));
            return SpellResult.NO_ACTION;
        }
        return this.showItems(context);
    }

    protected ItemStack parseItem(String itemKey) {
        if (itemKey == null || itemKey.isEmpty() || itemKey.equalsIgnoreCase("none")) {
            return null;
        }
        return this.context.getController().createItem(itemKey);
    }

    @Override
    public float getCostReduction() {
        return 0.0f;
    }

    @Override
    public float getConsumeReduction() {
        return 0.0f;
    }

    @Override
    public float getCostScale() {
        return (float)this.costScale;
    }

    protected class SelectorOption
    extends SelectorConfiguration {
        protected Integer slot;
        protected String name;
        protected List<String> lore;

        public SelectorOption(SelectorConfiguration defaults, ConfigurationSection configuration, CostReducer reducer) {
            String description;
            SpellTemplate spell;
            MageClassTemplate mageClass;
            this.slot = null;
            this.name = null;
            this.lore = null;
            this.selectedMessage = defaults.selectedMessage;
            this.items = defaults.items;
            this.permissionNode = defaults.permissionNode;
            this.costs = defaults.costs;
            this.requiredPath = defaults.requiredPath;
            this.requiredTemplate = defaults.requiredTemplate;
            this.requiresCompletedPath = defaults.requiresCompletedPath;
            this.exactPath = defaults.exactPath;
            this.castSpell = defaults.castSpell;
            this.requireWand = defaults.requireWand;
            this.applyToWand = defaults.applyToWand;
            this.unlockClass = defaults.unlockClass;
            this.currency = defaults.currency;
            this.sp = defaults.sp;
            this.experience = defaults.experience;
            this.limit = defaults.limit;
            this.lore = configuration.contains("lore") ? configuration.getStringList("lore") : null;
            this.parse(configuration);
            if (this.icon == null && defaults.icon != null) {
                this.icon = InventoryUtils.getCopy(defaults.icon);
            }
            if (this.icon == null) {
                this.icon = InventoryUtils.getURLSkull("http://textures.minecraft.net/texture/1adaf6e6e387bc18567671bb82e948488bbacff97763ee5985442814989f5d");
            }
            if (configuration.contains("slot")) {
                this.slot = configuration.getInt("slot");
            }
            MageController controller = SelectorAction.this.context.getController();
            this.name = configuration.getString("name", "");
            if (this.name.isEmpty() && this.unlockClass != null && !this.unlockClass.isEmpty()) {
                mageClass = controller.getMageClassTemplate(this.unlockClass);
                this.name = SelectorAction.this.context.getMessage("unlock_class", SelectorAction.this.getDefaultMessage(SelectorAction.this.context, "unlock_class"));
                if (mageClass != null) {
                    this.name = this.name.replace("$class", mageClass.getName());
                } else {
                    controller.getLogger().warning("Unknown class in selector config: " + this.unlockClass);
                }
            }
            if (this.name.isEmpty() && this.items != null) {
                this.name = controller.describeItem((ItemStack)this.items.get(0));
            }
            if (this.name.isEmpty() && this.castSpell != null && !this.castSpell.isEmpty()) {
                spell = controller.getSpellTemplate(this.castSpell);
                this.name = SelectorAction.this.context.getMessage("cast_spell", SelectorAction.this.getDefaultMessage(SelectorAction.this.context, "cast_spell"));
                if (spell != null) {
                    this.name = this.name.replace("$spell", spell.getName());
                } else {
                    controller.getLogger().warning("Unknown spell in selector config: " + this.castSpell);
                }
            }
            if (this.lore == null) {
                Object description2;
                if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                    mageClass = controller.getMageClassTemplate(this.unlockClass);
                    description2 = mageClass.getDescription();
                    if (description2 != null && !((String)description2).isEmpty()) {
                        this.lore = new ArrayList<String>();
                        this.lore.add((String)description2);
                    }
                } else if (this.castSpell != null && !this.castSpell.isEmpty() && (description2 = (spell = controller.getSpellTemplate(this.castSpell)).getDescription()) != null && !((String)description2).isEmpty()) {
                    this.lore = new ArrayList<String>();
                    this.lore.add((String)description2);
                }
            }
            if (this.costs != null) {
                String costString = SelectorAction.this.context.getMessage("cost_lore", SelectorAction.this.getDefaultMessage(SelectorAction.this.context, "cost_lore"));
                if (this.lore == null) {
                    this.lore = new ArrayList<String>();
                }
                for (Cost cost : this.costs) {
                    this.lore.add(costString.replace("$cost", cost.getFullDescription(SelectorAction.this.context.getController().getMessages(), reducer)));
                }
            }
            if ((description = configuration.getString("description")) != null && !description.isEmpty()) {
                if (this.lore == null) {
                    this.lore = new ArrayList<String>();
                }
                this.lore.add(0, description);
            }
            ItemMeta meta = this.icon.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.name));
            if (this.lore != null) {
                for (int i = 0; i < this.lore.size(); ++i) {
                    this.lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)this.lore.get(i)));
                }
                meta.setLore(this.lore);
            }
            this.icon.setItemMeta(meta);
            this.icon = InventoryUtils.makeReal(this.icon);
            InventoryUtils.makeUnbreakable(this.icon);
            InventoryUtils.hideFlags(this.icon, (byte)63);
        }

        protected Cost takeCosts(CostReducer reducer, CastContext context) {
            Cost required = this.getRequiredCost(reducer, context);
            if (required != null) {
                return required;
            }
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    cost.deduct(context.getMage(), context.getWand(), reducer);
                }
            }
            return null;
        }

        public Cost getRequiredCost(CostReducer reducer, CastContext context) {
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (cost.has(context.getMage(), context.getWand(), reducer)) continue;
                    return cost;
                }
            }
            return null;
        }

        public SpellResult give(CostReducer reducer, CastContext context) {
            Cost required;
            Mage mage = context.getMage();
            Wand wand = context.getWand();
            if (this.unlockClass != null && !this.unlockClass.isEmpty()) {
                if (mage.hasClassUnlocked(this.unlockClass)) {
                    String hasClassMessage = context.getMessage("has_class", SelectorAction.this.getDefaultMessage(context, "has_class")).replace("$class", this.name);
                    context.showMessage(hasClassMessage);
                    return SpellResult.NO_TARGET;
                }
                mage.unlockClass(this.unlockClass);
            }
            if (this.requireWand) {
                if (wand == null) {
                    context.showMessage("no_wand", SelectorAction.this.getDefaultMessage(context, "no_wand"));
                    return SpellResult.NO_TARGET;
                }
                if (this.applyToWand && this.items != null) {
                    boolean anyApplied = false;
                    for (ItemStack item : this.items) {
                        anyApplied = wand.addItem(item) || anyApplied;
                    }
                    if (!anyApplied) {
                        String inapplicable = context.getMessage("not_applicable", SelectorAction.this.getDefaultMessage(context, "not_applicable")).replace("$item", this.name);
                        context.showMessage(inapplicable);
                        return SpellResult.NO_TARGET;
                    }
                }
            }
            MageController controller = context.getController();
            if (this.castSpell != null && !this.castSpell.isEmpty()) {
                Object spell = null;
                spell = mage.getSpell(this.castSpell);
                if (spell == null || !spell.cast()) {
                    context.showMessage("cast_fail", SelectorAction.this.getDefaultMessage(context, "cast_fail"));
                    return SpellResult.NO_TARGET;
                }
            }
            if (this.sp != 0) {
                if (mage.isAtMaxSkillPoints()) {
                    return SpellResult.NO_TARGET;
                }
                mage.addSkillPoints(this.sp);
            }
            if (this.items != null && !this.applyToWand) {
                for (ItemStack item : this.items) {
                    ItemStack copy = InventoryUtils.getCopy(item);
                    mage.giveItem(copy);
                }
            }
            if (this.experience != 0) {
                mage.giveExperience(this.experience);
            }
            if (this.currency != 0) {
                VaultController.getInstance().depositPlayer(mage.getPlayer(), this.currency);
            }
            if ((required = this.takeCosts(reducer, context)) != null) {
                String baseMessage = context.getMessage("insufficient", SelectorAction.this.getDefaultMessage(context, "insufficient"));
                String costDescription = required.getFullDescription(controller.getMessages(), mage);
                costDescription = baseMessage.replace("$cost", costDescription);
                context.showMessage(costDescription);
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
            return SpellResult.CAST;
        }

        public Integer getSlot() {
            return this.slot;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public String getSelectedMessage(CostReducer reducer) {
            String costString = "";
            if (this.costs != null) {
                for (Cost cost : this.costs) {
                    if (!costString.isEmpty()) {
                        costString = costString + ", ";
                    }
                    costString = costString + cost.getFullDescription(SelectorAction.this.context.getController().getMessages(), reducer);
                }
            }
            if (costString.isEmpty()) {
                costString = SelectorAction.this.context.getMessage("shops.nothing");
            }
            return this.selectedMessage.replace("$name", this.name).replace("$cost", costString);
        }
    }

    protected class SelectorConfiguration {
        @Nonnull
        protected ItemStack icon;
        @Nullable
        protected List<ItemStack> items;
        @Nullable
        protected List<Cost> costs = null;
        @Nullable
        protected String permissionNode = null;
        @Nullable
        protected String requiredPath = null;
        @Nullable
        protected String requiredTemplate = null;
        @Nullable
        protected String requiresCompletedPath = null;
        @Nullable
        protected String exactPath = null;
        @Nullable
        protected String castSpell = null;
        @Nullable
        protected String unlockClass = null;
        @Nullable
        protected String selectedMessage = null;
        protected boolean requireWand = false;
        protected boolean applyToWand = false;
        protected int experience;
        protected int sp;
        protected int currency = 0;
        protected int limit = 0;

        public SelectorConfiguration(ConfigurationSection configuration) {
            this.parse(configuration);
        }

        protected SelectorConfiguration() {
        }

        protected void parse(ConfigurationSection configuration) {
            SpellTemplate spellTemplate;
            List itemList;
            this.permissionNode = configuration.getString("permission", this.permissionNode);
            this.requiredPath = configuration.getString("path", this.exactPath);
            this.exactPath = configuration.getString("path_exact", this.exactPath);
            this.requiresCompletedPath = configuration.getString("path_end", this.requiresCompletedPath);
            this.requiredTemplate = configuration.getString("require_template", this.requiredTemplate);
            this.requireWand = configuration.getBoolean("require_wand", this.requireWand);
            this.applyToWand = configuration.getBoolean("apply_to_wand", this.requireWand);
            this.castSpell = configuration.getString("cast_spell", this.castSpell);
            this.unlockClass = configuration.getString("unlock_class", this.unlockClass);
            this.currency = configuration.getInt("currency", this.currency);
            this.experience = configuration.getInt("experience", this.experience);
            this.sp = configuration.getInt("sp", this.sp);
            this.limit = configuration.getInt("limit", this.limit);
            this.selectedMessage = configuration.getString("selected_message", this.selectedMessage);
            if (this.selectedMessage == null) {
                this.selectedMessage = SelectorAction.this.context.getMessage("deducted", SelectorAction.this.getDefaultMessage(SelectorAction.this.context, "deducted"));
            }
            if (configuration.contains("item")) {
                this.items = new ArrayList<ItemStack>();
                ItemStack item = SelectorAction.this.parseItem(configuration.getString("item"));
                this.items.add(item);
            }
            if (configuration.contains("items") && (itemList = configuration.getStringList("items")).size() > 0) {
                this.items = new ArrayList<ItemStack>();
                for (String itemKey : itemList) {
                    this.items.add(SelectorAction.this.parseItem(itemKey));
                }
            }
            this.icon = SelectorAction.this.parseItem(configuration.getString("icon"));
            if (this.icon == null && this.items != null) {
                this.icon = InventoryUtils.getCopy(this.items.get(0));
            }
            if (this.icon == null && this.castSpell != null && !this.castSpell.isEmpty() && (spellTemplate = SelectorAction.this.context.getController().getSpellTemplate(this.castSpell)) != null && spellTemplate.getIcon() != null) {
                this.icon = spellTemplate.getIcon().getItemStack(1);
            }
            this.costs = this.parseCosts(configuration.getConfigurationSection("costs"));
            int currencyCost = configuration.getInt("cost");
            if (currencyCost > 0) {
                if (this.costs == null) {
                    this.costs = new ArrayList<Cost>();
                }
                this.costs.add(new Cost(SelectorAction.this.context.getController(), "currency", currencyCost));
            }
            if (this.requiresCompletedPath != null) {
                this.requiredPath = this.requiresCompletedPath;
                this.exactPath = this.requiresCompletedPath;
            }
            if (this.requiredPath != null || this.exactPath != null || this.requiredTemplate != null) {
                this.requireWand = true;
            }
        }

        protected List<Cost> parseCosts(ConfigurationSection node) {
            if (node == null) {
                return null;
            }
            ArrayList<Cost> costs = new ArrayList<Cost>();
            Set costKeys = node.getKeys(false);
            for (String key : costKeys) {
                costs.add(new Cost(SelectorAction.this.context.getController(), key, node.getInt(key, 1)));
            }
            return costs;
        }

        public boolean hasLimit() {
            return this.limit > 0;
        }

        public boolean has(CastContext context) {
            Mage mage = context.getMage();
            return this.unlockClass != null && !this.unlockClass.isEmpty() && mage.hasClassUnlocked(this.unlockClass);
        }

        public SpellResult checkContext(CastContext context, boolean quiet) {
            String template;
            Mage mage = context.getMage();
            MageController controller = mage.getController();
            Player player = mage.getPlayer();
            if (player == null) {
                return SpellResult.PLAYER_REQUIRED;
            }
            if (this.permissionNode != null && !player.hasPermission(this.permissionNode)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            Wand wand = mage.getActiveWand();
            if (wand == null && this.requireWand) {
                if (!quiet) {
                    context.showMessage("no_wand", SelectorAction.this.getDefaultMessage(context, "no_wand"));
                }
                return SpellResult.FAIL;
            }
            if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
                if (!quiet) {
                    context.showMessage(context.getMessage("no_template", SelectorAction.this.getDefaultMessage(context, "no_template")).replace("$wand", wand.getName()));
                }
                return SpellResult.FAIL;
            }
            CasterProperties checkProperties = null;
            MageClass activeClass = mage.getActiveClass();
            ProgressionPath path = null;
            if (wand != null) {
                path = wand.getPath();
                checkProperties = wand;
            } else if (activeClass != null) {
                path = activeClass.getPath();
                checkProperties = activeClass;
            }
            if (this.unlockClass != null && !this.unlockClass.isEmpty() && mage.hasClassUnlocked(this.unlockClass)) {
                String hasClassMessage = context.getMessage("has_class", SelectorAction.this.getDefaultMessage(context, "has_class")).replace("$class", this.unlockClass);
                if (!quiet) {
                    context.showMessage(hasClassMessage);
                }
                return SpellResult.NO_TARGET;
            }
            if (this.requiredPath != null || this.exactPath != null) {
                if (path == null) {
                    if (!quiet) {
                        context.showMessage(context.getMessage("no_path", SelectorAction.this.getDefaultMessage(context, "no_path")));
                    }
                    return SpellResult.FAIL;
                }
                if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                    WandUpgradePath requiresPath = controller.getPath(this.requiredPath);
                    if (!quiet) {
                        if (requiresPath != null) {
                            context.showMessage(context.getMessage("no_required_path", SelectorAction.this.getDefaultMessage(context, "no_required_path")).replace("$path", requiresPath.getName()));
                        } else {
                            context.getLogger().warning("Invalid path specified in Shop action: " + this.requiredPath);
                        }
                    }
                    return SpellResult.FAIL;
                }
                if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                    WandUpgradePath requiresPath = controller.getPath(this.exactPath);
                    if (!quiet) {
                        if (requiresPath != null) {
                            context.showMessage(context.getMessage("no_path_exact", SelectorAction.this.getDefaultMessage(context, "no_path_exact")).replace("$path", requiresPath.getName()));
                        } else {
                            context.getLogger().warning("Invalid path specified in Shop action: " + this.exactPath);
                        }
                    }
                    return SpellResult.FAIL;
                }
                if (this.requiresCompletedPath != null && path.canProgress(checkProperties)) {
                    if (!quiet) {
                        context.showMessage(context.getMessage("no_path_end", SelectorAction.this.getDefaultMessage(context, "no_path_end")).replace("$path", path.getName()));
                    }
                    return SpellResult.FAIL;
                }
            }
            if (this.limit > 0 && SelectorAction.this.has >= this.limit) {
                if (!quiet) {
                    String limitMessage = context.getMessage("at_limit", SelectorAction.this.getDefaultMessage(context, "at_limit")).replace("$limit", Integer.toString(this.limit));
                    context.showMessage(limitMessage);
                }
                return SpellResult.NO_TARGET;
            }
            return SpellResult.CAST;
        }
    }
}

