/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.ModifyBlockAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.InventoryHolder;

public class BreakBlockAction
extends ModifyBlockAction {
    private int durabilityAmount;
    private double maxDistanceSquared;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.durabilityAmount = parameters.getInt("break_durability", 1);
        double maxDistance = parameters.getDouble("durability_max_distance");
        this.maxDistanceSquared = maxDistance * maxDistance;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        if (block.getType() == Material.AIR || !context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        context.registerForUndo(block);
        double scaledAmount = this.durabilityAmount;
        if (this.maxDistanceSquared > 0.0) {
            double distanceSquared = context.getTargetCenterLocation().distanceSquared(block.getLocation());
            if (distanceSquared > this.maxDistanceSquared) {
                return SpellResult.NO_TARGET;
            }
            if (distanceSquared > 0.0) {
                scaledAmount *= 1.0 - distanceSquared / this.maxDistanceSquared;
            }
        }
        double breakAmount = 1.0;
        double durability = CompatibilityUtils.getDurability(block.getType());
        if (durability > 0.0) {
            double breakPercentage = scaledAmount / durability;
            breakAmount = context.registerBreaking(block, breakPercentage);
        }
        if (breakAmount > 1.0) {
            if (context.hasBreakPermission(block)) {
                MaterialBrush brush;
                CompatibilityUtils.clearBreaking(block);
                BlockState blockState = block.getState();
                if (blockState != null && (blockState instanceof InventoryHolder || blockState.getType() == Material.FLOWER_POT)) {
                    NMSUtils.clearItems(blockState.getLocation());
                }
                if ((brush = context.getBrush()) == null) {
                    brush = new com.elmakers.mine.bukkit.block.MaterialBrush(context.getMage(), Material.AIR, 0);
                    context.setBrush(brush);
                } else {
                    brush.setMaterial(Material.AIR);
                }
                super.perform(context);
                context.unregisterBreaking(block);
                context.playEffects("break");
            }
        } else {
            CompatibilityUtils.setBreaking(block, breakAmount);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("durability");
        parameters.add("durability_max_distance");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("durability") || parameterKey.equals("durability_max_distance")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean usesBrush() {
        return false;
    }
}

