/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.configuration.ConfigurationSection;

public class WandProperties
extends CasterProperties {
    protected BaseMagicProperties wandTemplate;
    protected MageClass mageClass;

    public WandProperties(MageController controller) {
        super(MagicPropertyType.WAND, controller);
    }

    public void setWandTemplate(BaseMagicProperties properties) {
        this.wandTemplate = properties;
    }

    public void setMageClass(MageClass mageClass) {
        this.mageClass = mageClass;
    }

    @Override
    public void clear() {
        super.clear();
        this.wandTemplate = null;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasOwnProperty(key) || this.wandTemplate != null && this.wandTemplate.hasProperty(key) || this.mageClass != null && this.mageClass.hasProperty(key);
    }

    @Override
    public Object getProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null && this.wandTemplate != null) {
            value = this.wandTemplate.getProperty(key);
        }
        if (value == null && this.mageClass != null) {
            value = this.mageClass.getProperty(key);
        }
        return value;
    }

    public ConfigurationSection getEffectiveConfiguration() {
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.getConfiguration());
        if (this.wandTemplate != null) {
            ConfigurationSection parentConfiguration = this.wandTemplate.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        }
        if (this.mageClass != null) {
            ConfigurationSection classConfiguration = this.mageClass.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, classConfiguration);
        }
        return effectiveConfiguration;
    }
}

