/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.CastingCost;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class WandLevel {
    private final WandUpgradePath path;
    private LinkedList<WeightedPair<Integer>> spellCountProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> materialCountProbability = new LinkedList();
    private LinkedList<WeightedPair<String>> spellProbability = new LinkedList();
    private LinkedList<WeightedPair<String>> materialProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> useProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> addUseProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> propertyCountProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> costReductionProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> powerProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionPhysicalProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionProjectilesProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionFallingProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionFireProbability = new LinkedList();
    private LinkedList<WeightedPair<Float>> damageReductionExplosionsProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> manaRegenerationProbability = new LinkedList();
    private LinkedList<WeightedPair<Integer>> manaMaxProbability = new LinkedList();

    protected WandLevel(WandUpgradePath path, MageController controller, ConfigurationSection template, int levelIndex, int nextLevelIndex, float distance) {
        this.path = path;
        LinkedList<WeightedPair<String>> spells = new LinkedList<WeightedPair<String>>();
        RandomUtils.populateStringProbabilityMap(spells, template, "spells", levelIndex, nextLevelIndex, distance);
        for (WeightedPair weightedPair : spells) {
            if (controller.getSpellTemplate((String)weightedPair.getValue()) == null) continue;
            this.spellProbability.add(weightedPair);
        }
        RandomUtils.populateIntegerProbabilityMap(this.spellCountProbability, template, "spell_count", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateStringProbabilityMap(this.materialProbability, template, "materials", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.materialCountProbability, template.getConfigurationSection("material_count"), levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.useProbability, template, "uses", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.addUseProbability, template, "add_uses", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.propertyCountProbability, template, "property_count", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.costReductionProbability, template, "cost_reduction", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProbability, template, "protection", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionPhysicalProbability, template, "protection_physical", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFallingProbability, template, "protection_falling", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionProjectilesProbability, template, "protection_projectiles", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionFireProbability, template, "protection_fire", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.damageReductionExplosionsProbability, template, "protection_explosions", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.manaRegenerationProbability, template, "mana_regeneration", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateIntegerProbabilityMap(this.manaMaxProbability, template, "mana_max", levelIndex, nextLevelIndex, distance);
        RandomUtils.populateFloatProbabilityMap(this.powerProbability, template, "power", levelIndex, nextLevelIndex, distance);
    }

    public void add(WandLevel other) {
        this.spellProbability = RandomUtils.merge(this.spellProbability, other.spellProbability);
        this.materialProbability = RandomUtils.merge(this.materialProbability, other.materialProbability);
        this.materialCountProbability = this.materialCountProbability.isEmpty() ? other.materialCountProbability : this.materialCountProbability;
        this.spellCountProbability = this.spellCountProbability.isEmpty() ? other.spellCountProbability : this.spellCountProbability;
        this.useProbability = this.useProbability.isEmpty() ? other.useProbability : this.useProbability;
        this.addUseProbability = this.addUseProbability.isEmpty() ? other.addUseProbability : this.addUseProbability;
        this.propertyCountProbability = this.propertyCountProbability.isEmpty() ? other.propertyCountProbability : this.propertyCountProbability;
        this.costReductionProbability = this.costReductionProbability.isEmpty() ? other.costReductionProbability : this.costReductionProbability;
        this.powerProbability = this.powerProbability.isEmpty() ? other.powerProbability : this.powerProbability;
        this.damageReductionProbability = this.damageReductionProbability.isEmpty() ? other.damageReductionProbability : this.damageReductionProbability;
        this.damageReductionPhysicalProbability = this.damageReductionPhysicalProbability.isEmpty() ? other.damageReductionPhysicalProbability : this.damageReductionPhysicalProbability;
        this.damageReductionProjectilesProbability = this.damageReductionProjectilesProbability.isEmpty() ? other.damageReductionProjectilesProbability : this.damageReductionProjectilesProbability;
        this.damageReductionFallingProbability = this.damageReductionFallingProbability.isEmpty() ? other.damageReductionFallingProbability : this.damageReductionFallingProbability;
        this.damageReductionFireProbability = this.damageReductionFireProbability.isEmpty() ? other.damageReductionFireProbability : this.damageReductionFireProbability;
        this.damageReductionExplosionsProbability = this.damageReductionExplosionsProbability.isEmpty() ? other.damageReductionExplosionsProbability : this.damageReductionExplosionsProbability;
        this.manaRegenerationProbability = this.manaRegenerationProbability.isEmpty() ? other.manaRegenerationProbability : this.manaRegenerationProbability;
        this.manaMaxProbability = this.manaMaxProbability.isEmpty() ? other.manaMaxProbability : this.manaMaxProbability;
    }

    public int getSpellCount() {
        int count = 0;
        for (WeightedPair weightedPair : this.spellCountProbability) {
            if ((Integer)weightedPair.getValue() <= count) continue;
            count = (Integer)weightedPair.getValue();
        }
        return count;
    }

    public int getMaterialCount() {
        int count = 0;
        for (WeightedPair weightedPair : this.materialCountProbability) {
            if ((Integer)weightedPair.getValue() <= count) continue;
            count = (Integer)weightedPair.getValue();
        }
        return count;
    }

    public LinkedList<WeightedPair<String>> getRemainingSpells(Wand wand) {
        LinkedList<WeightedPair<String>> remainingSpells = new LinkedList<WeightedPair<String>>();
        for (WeightedPair weightedPair : this.spellProbability) {
            if (!(weightedPair.getRawThreshold().floatValue() >= 1.0f) || wand.hasSpell((String)weightedPair.getValue())) continue;
            remainingSpells.add(weightedPair);
        }
        return remainingSpells;
    }

    public LinkedList<WeightedPair<String>> getRemainingMaterials(Wand wand) {
        LinkedList<WeightedPair<String>> remainingMaterials = new LinkedList<WeightedPair<String>>();
        for (WeightedPair weightedPair : this.materialProbability) {
            String materialKey = (String)weightedPair.getValue();
            if (wand.hasBrush(materialKey = materialKey.replace("|", ":")) || !MaterialBrush.isValidMaterial(materialKey, false)) continue;
            remainingMaterials.add(weightedPair);
        }
        return remainingMaterials;
    }

    public boolean randomizeWand(com.elmakers.mine.bukkit.api.magic.Mage mage, Wand wand, boolean additive, boolean hasUpgrade, boolean addSpells) {
        Mage activeMage = wand.getActiveMage();
        if (mage == null) {
            mage = activeMage;
        }
        wand.setActiveMage(mage);
        boolean addedSpells = false;
        LinkedList remainingSpells = this.getRemainingSpells(wand);
        if (addSpells && remainingSpells.size() > 0) {
            Integer spellCount = (Integer)RandomUtils.weightedRandom(this.spellCountProbability);
            for (int i = 0; spellCount != null && i < spellCount; ++i) {
                String spellKey = (String)RandomUtils.weightedRandom(remainingSpells);
                if (!wand.addSpell(spellKey)) continue;
                addedSpells = true;
            }
        }
        boolean needsMaterials = false;
        int maxManaCost = 0;
        Collection spells = wand.getSpells();
        for (String spellName : spells) {
            SpellTemplate spell = wand.getController().getSpellTemplate(spellName);
            if (spell == null) continue;
            boolean bl = needsMaterials = needsMaterials || spell.usesBrush();
            Collection<CastingCost> costs = spell.getCosts();
            if (costs == null) continue;
            for (CastingCost cost : costs) {
                maxManaCost = Math.max(maxManaCost, cost.getMana());
            }
        }
        boolean addedMaterials = false;
        LinkedList remainingMaterials = this.getRemainingMaterials(wand);
        if (needsMaterials && remainingMaterials.size() > 0) {
            int currentMaterialCount = wand.getBrushes().size();
            Integer materialCount = (Integer)RandomUtils.weightedRandom(this.materialCountProbability);
            if (materialCount == null) {
                materialCount = 0;
            }
            if (currentMaterialCount == 0) {
                materialCount = Math.max(1, materialCount);
            }
            int retries = 100;
            for (int i = 0; i < materialCount; ++i) {
                String materialKey = (String)RandomUtils.weightedRandom(remainingMaterials);
                if (!wand.addBrush(materialKey = materialKey.replace("|", ":"))) {
                    if (retries-- <= 0) continue;
                    --i;
                    continue;
                }
                addedMaterials = true;
            }
        }
        if (hasUpgrade && addSpells && (!addedMaterials || !needsMaterials) && !addedSpells && (this.getSpellCount() > 0 && this.spellProbability.size() > 0 || this.getMaterialCount() > 0 && this.materialProbability.size() > 0)) {
            if (mage != null && mage.getDebugLevel() > 0) {
                mage.sendDebugMessage("Has upgrade: " + hasUpgrade);
                mage.sendDebugMessage("Added spells: " + addedSpells + " (" + addSpells + ")");
                mage.sendDebugMessage("Spells per enchant: " + this.getSpellCount());
                mage.sendDebugMessage("Spells in list: " + this.spellProbability.size());
                mage.sendDebugMessage("Added brushes: " + addedMaterials + ", needed: " + needsMaterials);
            }
            wand.setActiveMage(activeMage);
            return false;
        }
        boolean addedProperties = false;
        Integer propertyCount = this.propertyCountProbability.size() == 0 ? Integer.valueOf(0) : (Integer)RandomUtils.weightedRandom(this.propertyCountProbability);
        MemoryConfiguration wandProperties = new MemoryConfiguration();
        double costReduction = wand.getCostReduction();
        ArrayList<Integer> propertiesAvailable = new ArrayList<Integer>();
        double power = wand.getPower();
        double damageReduction = wand.damageReduction;
        double damageReductionPhysical = wand.damageReductionPhysical;
        double damageReductionProjectiles = wand.damageReductionProjectiles;
        double damageReductionFalling = wand.damageReductionFalling;
        double damageReductionFire = wand.damageReductionFire;
        double damageReductionExplosions = wand.damageReductionExplosions;
        if (this.costReductionProbability.size() > 0 && costReduction < (double)this.path.getMaxCostReduction()) {
            propertiesAvailable.add(0);
        }
        if (this.powerProbability.size() > 0 && power < (double)this.path.getMaxPower()) {
            propertiesAvailable.add(1);
        }
        if (this.damageReductionProbability.size() > 0 && damageReduction < (double)this.path.getMaxDamageReduction()) {
            propertiesAvailable.add(2);
        }
        if (this.damageReductionPhysicalProbability.size() > 0 && damageReductionPhysical < (double)this.path.getMaxDamageReductionPhysical()) {
            propertiesAvailable.add(3);
        }
        if (this.damageReductionProjectilesProbability.size() > 0 && damageReductionProjectiles < (double)this.path.getMaxDamageReductionProjectiles()) {
            propertiesAvailable.add(4);
        }
        if (this.damageReductionFallingProbability.size() > 0 && damageReductionFalling < (double)this.path.getMaxDamageReductionFalling()) {
            propertiesAvailable.add(5);
        }
        if (this.damageReductionFireProbability.size() > 0 && damageReductionFire < (double)this.path.getMaxDamageReductionFire()) {
            propertiesAvailable.add(6);
        }
        if (this.damageReductionExplosionsProbability.size() > 0 && damageReductionExplosions < (double)this.path.getMaxDamageReductionExplosions()) {
            propertiesAvailable.add(7);
        }
        if (propertiesAvailable.size() > 0 && !addedMaterials && !addedSpells && propertyCount == 0) {
            propertyCount = 1;
        }
        while (propertyCount != null) {
            Integer n = propertyCount;
            Integer n2 = propertyCount = Integer.valueOf(propertyCount - 1);
            if (n <= 0 || propertiesAvailable.size() <= 0) break;
            int randomPropertyIndex = (int)(Math.random() * (double)propertiesAvailable.size());
            int randomProperty = (Integer)propertiesAvailable.get(randomPropertyIndex);
            switch (randomProperty) {
                case 0: {
                    if (this.costReductionProbability.size() <= 0 || !(costReduction < (double)this.path.getMaxCostReduction())) break;
                    addedProperties = true;
                    costReduction = Math.min((double)this.path.getMaxCostReduction(), costReduction + (double)((Float)RandomUtils.weightedRandom(this.costReductionProbability)).floatValue());
                    wandProperties.set("cost_reduction", (Object)costReduction);
                    break;
                }
                case 1: {
                    if (this.powerProbability.size() <= 0 || !(power < (double)this.path.getMaxPower())) break;
                    addedProperties = true;
                    power = Math.min((double)this.path.getMaxPower(), power + (double)((Float)RandomUtils.weightedRandom(this.powerProbability)).floatValue());
                    wandProperties.set("power", (Object)power);
                    break;
                }
                case 2: {
                    if (this.damageReductionProbability.size() <= 0 || !(damageReduction < (double)this.path.getMaxDamageReduction())) break;
                    addedProperties = true;
                    damageReduction = Math.min((double)this.path.getMaxDamageReduction(), damageReduction + (double)((Float)RandomUtils.weightedRandom(this.damageReductionProbability)).floatValue());
                    wandProperties.set("protection", (Object)damageReduction);
                    break;
                }
                case 3: {
                    if (this.damageReductionPhysicalProbability.size() <= 0 || !(damageReductionPhysical < (double)this.path.getMaxDamageReductionPhysical())) break;
                    addedProperties = true;
                    damageReductionPhysical = Math.min((double)this.path.getMaxDamageReductionPhysical(), damageReductionPhysical + (double)((Float)RandomUtils.weightedRandom(this.damageReductionPhysicalProbability)).floatValue());
                    wandProperties.set("protection_physical", (Object)damageReductionPhysical);
                    break;
                }
                case 4: {
                    if (this.damageReductionProjectilesProbability.size() <= 0 || !(damageReductionProjectiles < (double)this.path.getMaxDamageReductionProjectiles())) break;
                    addedProperties = true;
                    damageReductionProjectiles = Math.min((double)this.path.getMaxDamageReductionProjectiles(), damageReductionProjectiles + (double)((Float)RandomUtils.weightedRandom(this.damageReductionProjectilesProbability)).floatValue());
                    wandProperties.set("protection_projectiles", (Object)damageReductionProjectiles);
                    break;
                }
                case 5: {
                    if (this.damageReductionFallingProbability.size() <= 0 || !(damageReductionFalling < (double)this.path.getMaxDamageReductionFalling())) break;
                    addedProperties = true;
                    damageReductionFalling = Math.min((double)this.path.getMaxDamageReductionFalling(), damageReductionFalling + (double)((Float)RandomUtils.weightedRandom(this.damageReductionFallingProbability)).floatValue());
                    wandProperties.set("protection_falling", (Object)damageReductionFalling);
                    break;
                }
                case 6: {
                    if (this.damageReductionFireProbability.size() <= 0 || !(damageReductionFire < (double)this.path.getMaxDamageReductionFire())) break;
                    addedProperties = true;
                    damageReductionFire = Math.min((double)this.path.getMaxDamageReductionFire(), damageReductionFire + (double)((Float)RandomUtils.weightedRandom(this.damageReductionFireProbability)).floatValue());
                    wandProperties.set("protection_fire", (Object)damageReductionFire);
                    break;
                }
                case 7: {
                    if (this.damageReductionExplosionsProbability.size() <= 0 || !(damageReductionExplosions < (double)this.path.getMaxDamageReductionExplosions())) break;
                    addedProperties = true;
                    damageReductionExplosions = Math.min((double)this.path.getMaxDamageReductionExplosions(), damageReductionExplosions + (double)((Float)RandomUtils.weightedRandom(this.damageReductionExplosionsProbability)).floatValue());
                    wandProperties.set("protection_explosions", (Object)damageReductionExplosions);
                }
            }
        }
        if (costReduction >= 1.0) {
            wandProperties.set("mana_regeneration", (Object)0);
            wandProperties.set("mana_max", (Object)0);
            wandProperties.set("mana", (Object)0);
        } else {
            int manaRegeneration = wand.getManaRegeneration();
            if (this.manaRegenerationProbability.size() > 0 && manaRegeneration < this.path.getMaxManaRegeneration()) {
                addedProperties = true;
                manaRegeneration = Math.min(this.path.getMaxManaRegeneration(), manaRegeneration + (Integer)RandomUtils.weightedRandom(this.manaRegenerationProbability));
                wandProperties.set("mana_regeneration", (Object)manaRegeneration);
            }
            int manaMax = wand.getManaMax();
            if (this.manaMaxProbability.size() > 0 && manaMax < this.path.getMaxMaxMana()) {
                manaMax = Math.min(this.path.getMaxMaxMana(), manaMax + (Integer)RandomUtils.weightedRandom(this.manaMaxProbability));
                if (this.path.getMatchSpellMana()) {
                    manaMax = Math.max(maxManaCost, manaMax);
                }
                wandProperties.set("mana_max", (Object)manaMax);
                addedProperties = true;
            }
            wandProperties.set("mana", (Object)manaMax);
        }
        if (additive) {
            int wandUses = wand.getRemainingUses();
            if (wandUses > 0 && wandUses < this.path.getMaxUses() && this.addUseProbability.size() > 0) {
                wandProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), wandUses + (Integer)RandomUtils.weightedRandom(this.addUseProbability)));
                addedProperties = true;
            }
        } else if (this.useProbability.size() > 0) {
            wandProperties.set("uses", (Object)Math.min(this.path.getMaxUses(), (Integer)RandomUtils.weightedRandom(this.useProbability)));
        }
        wand.upgrade((ConfigurationSection)wandProperties);
        wand.setActiveMage(activeMage);
        return addedMaterials || addedSpells || addedProperties;
    }

    public int getSpellProbabilityCount() {
        return this.spellProbability.size();
    }

    public int getMaterialProbabilityCount() {
        return this.materialProbability.size();
    }
}

