/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.slikey.effectlib.util.MathUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class SourceLocation {
    private boolean useWandLocation = true;
    private boolean useCastLocation = true;
    private boolean useEyeLocation = false;
    private boolean useTargetLocation = true;

    public SourceLocation(ConfigurationSection configuration) {
        this.useWandLocation = configuration.getBoolean("use_wand_location", true);
        if (!this.useWandLocation) {
            this.useEyeLocation = true;
            this.useCastLocation = false;
        }
        this.useCastLocation = configuration.getBoolean("use_cast_location", this.useCastLocation);
        this.useEyeLocation = configuration.getBoolean("use_eye_location", this.useEyeLocation);
        this.useTargetLocation = configuration.getBoolean("use_target_location", true);
        String locationTypeString = configuration.getString("source_location", "");
        if (!locationTypeString.isEmpty()) {
            try {
                LocationType locationType = LocationType.valueOf(locationTypeString.toUpperCase());
                this.useEyeLocation = false;
                this.useCastLocation = false;
                this.useWandLocation = false;
                switch (locationType) {
                    case CAST: {
                        this.useCastLocation = true;
                        break;
                    }
                    case WAND: {
                        this.useWandLocation = true;
                        break;
                    }
                    case EYES: {
                        this.useEyeLocation = true;
                        break;
                    }
                }
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid location type specified in source_location parameter: " + locationTypeString);
            }
        }
        if (configuration.getBoolean("reorient", false)) {
            this.useTargetLocation = false;
        }
    }

    public Location getLocation(CastContext context) {
        Vector direction;
        Mage mage = context.getMage();
        boolean useWand = mage != null && this.useWandLocation;
        boolean useCast = mage != null && this.useCastLocation;
        Location location = null;
        if (this.useEyeLocation) {
            location = context.getEyeLocation();
        }
        if (location == null && useCast) {
            location = context.getCastLocation();
        }
        if (location == null && useWand) {
            location = context.getWandLocation();
        }
        if (location == null) {
            location = context.getLocation();
        }
        Location targetLocation = context.getTargetLocation();
        if (this.useTargetLocation && targetLocation != null && MathUtils.isFinite((direction = targetLocation.toVector().subtract(location.toVector()).normalize()).getX()) && MathUtils.isFinite(direction.getY()) && MathUtils.isFinite(direction.getZ())) {
            location.setDirection(direction);
        }
        return location;
    }

    public boolean shouldUseWandLocation() {
        return this.useWandLocation;
    }

    public boolean shouldUseCastLocation() {
        return this.useCastLocation;
    }

    public boolean shouldUseEyeLocation() {
        return this.useEyeLocation;
    }

    private static enum LocationType {
        CAST,
        EYES,
        FEET,
        WAND;

    }
}

