/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageProperties;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MageClass
extends CasterProperties
implements com.elmakers.mine.bukkit.api.magic.MageClass {
    protected final MageClassTemplate template;
    protected final MageProperties mage;
    private MageClass parent;

    public MageClass(@Nonnull Mage mage, @Nonnull MageClassTemplate template) {
        super(template.hasParent() ? MagicPropertyType.SUBCLASS : MagicPropertyType.CLASS, mage.getController());
        this.template = template;
        this.mage = mage.getProperties();
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasOwnProperty(key) || this.template.hasProperty(key) || this.mage.hasProperty(key) || this.parent != null && this.parent.hasProperty(key);
    }

    @Override
    public Object getProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null) {
            value = this.template.getProperty(key);
        }
        if (value == null && this.parent != null) {
            value = this.parent.getProperty(key);
        }
        if (value == null && this.parent == null) {
            value = this.mage.getProperty(key);
        }
        return value;
    }

    @Nonnull
    public MageClassTemplate getTemplate() {
        return this.template;
    }

    @Nullable
    public MageClass getParent() {
        return this.parent;
    }

    public MageClass getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public void setParent(@Nonnull MageClass parent) {
        this.parent = parent;
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        super.describe(sender, ignoreProperties);
        Set hideKeys = this.getConfiguration().getKeys(false);
        if (ignoreProperties != null) {
            hideKeys.addAll(ignoreProperties);
        }
        this.template.describe(sender, hideKeys);
        hideKeys.addAll(this.template.getConfiguration().getKeys(false));
        MageClass parent = this.getParent();
        if (parent != null) {
            sender.sendMessage(ChatColor.AQUA + "Parent Class: " + ChatColor.GREEN + parent.getTemplate().getKey());
            parent.describe(sender, hideKeys);
        }
    }

    public ConfigurationSection getEffectiveConfiguration() {
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.getConfiguration());
        ConfigurationSection templateConfiguration = this.template.getConfiguration();
        ConfigurationUtils.overlayConfigurations(effectiveConfiguration, templateConfiguration);
        if (this.parent != null) {
            ConfigurationSection parentConfiguration = this.parent.getEffectiveConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        } else {
            ConfigurationSection mageConfiguration = this.mage.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, mageConfiguration);
        }
        return effectiveConfiguration;
    }

    @Override
    protected BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case SUBCLASS: {
                return this;
            }
            case CLASS: {
                return this.getRoot();
            }
            case MAGE: {
                return this.mage;
            }
        }
        return null;
    }

    @Override
    public boolean tickMana() {
        if (!this.hasOwnMana() && this.parent != null) {
            return this.parent.tickMana();
        }
        return super.tickMana();
    }

    @Override
    public void loadProperties() {
        if (this.parent != null) {
            this.parent.loadProperties();
        }
        super.loadProperties();
    }

    @Override
    public String getKey() {
        return this.template.getKey();
    }
}

