/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicProperties;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class BaseMagicProperties
implements MagicProperties {
    @Nonnull
    protected final MagicController controller;
    protected ConfigurationSection configuration = new MemoryConfiguration();
    private static int MAX_PROPERTY_DISPLAY_LENGTH = 50;
    public static final Set<String> PROPERTY_KEYS = ImmutableSet.of((Object)"active_spell", (Object)"active_brush", (Object)"path", (Object)"template", (Object)"passive", (Object)"mana", (Object[])new String[]{"mana_regeneration", "mana_max", "mana_max_boost", "mana_regeneration_boost", "mana_per_damage", "bound", "soul", "has_uses", "uses", "upgrade", "indestructible", "undroppable", "consume_reduction", "cost_reduction", "cooldown_reduction", "effect_bubbles", "effect_color", "effect_particle", "effect_particle_count", "effect_particle_data", "effect_particle_interval", "effect_particle_min_velocity", "effect_particle_radius", "effect_particle_offset", "effect_sound", "effect_sound_interval", "cast_spell", "cast_parameters", "cast_interval", "cast_min_velocity", "cast_velocity_direction", "hotbar_count", "hotbar", "icon", "icon_inactive", "icon_inactive_delay", "mode", "active_effects", "brush_mode", "keep", "locked", "quiet", "force", "rename", "rename_description", "power", "overrides", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "potion_effects", "brushes", "brush_inventory", "spells", "spell_inventory", "spell_levels", "powered", "protected", "heroes", "enchant_count", "max_enchant_count", "quick_cast", "left_click", "right_click", "drop", "swap", "block_fov", "block_chance", "block_reflect_chance", "block_mage_cooldown", "block_cooldown", "unique", "track", "invulnerable", "immortal", "inventory_rows", "cast_location", "sp_multiplier", "class", "consume_spell"});
    public static final Set<String> HIDDEN_PROPERTY_KEYS = ImmutableSet.of((Object)"owner", (Object)"owner_id", (Object)"version", (Object)"attributes", (Object)"attribute_slot", (Object)"mana_timestamp", (Object[])new String[]{"storage"});

    protected BaseMagicProperties(@Nonnull MageController controller) {
        Preconditions.checkArgument((boolean)(controller instanceof MagicController));
        this.controller = (MagicController)controller;
    }

    public void load(@Nullable ConfigurationSection configuration) {
        this.configuration = ConfigurationUtils.cloneConfiguration(configuration);
    }

    public boolean hasOwnProperty(String key) {
        return this.configuration.contains(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasOwnProperty(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.configuration.get(key);
    }

    public <T> Optional<T> getProperty(String key, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null || !type.isInstance(value)) {
            return Optional.absent();
        }
        return Optional.of(type.cast(value));
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        Class<?> clazz = defaultValue.getClass();
        Object value = this.getProperty(key);
        if (value != null && clazz.isInstance(value)) {
            return (T)clazz.cast(value);
        }
        return defaultValue;
    }

    public Object getObject(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public Object getObject(String key) {
        return this.getProperty(key);
    }

    public double getDouble(String key, double defaultValue) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof Number) ? defaultValue : NumberConversions.toDouble((Object)value);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public float getFloat(String key, float defaultValue) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof Number) ? defaultValue : NumberConversions.toFloat((Object)value);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof Number) ? defaultValue : NumberConversions.toInt((Object)value);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public long getLong(String key, long defaultValue) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof Number) ? defaultValue : NumberConversions.toLong((Object)value);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof Boolean) ? defaultValue : (Boolean)value;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof String) ? defaultValue : (String)value;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public ConfigurationSection getConfigurationSection(String key) {
        Object value = this.getProperty(key);
        return value == null || !(value instanceof ConfigurationSection) ? null : (ConfigurationSection)value;
    }

    public Vector getVector(String key, Vector def) {
        String stringData = this.getString(key, null);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toVector(stringData);
    }

    public Vector getVector(String key) {
        return this.getVector(key, null);
    }

    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    protected static String getPotionEffectString(Map<PotionEffectType, Integer> potionEffects) {
        if (potionEffects.size() == 0) {
            return null;
        }
        ArrayList<String> effectStrings = new ArrayList<String>();
        for (Map.Entry<PotionEffectType, Integer> entry : potionEffects.entrySet()) {
            String effectString = entry.getKey().getName();
            if (entry.getValue() > 0) {
                effectString = effectString + ":" + entry.getValue();
            }
            effectStrings.add(effectString);
        }
        return StringUtils.join(effectStrings, (String)",");
    }

    protected String describePotionEffect(PotionEffectType effect, int level) {
        String effectName = effect.getName();
        String effectFirst = effectName.substring(0, 1);
        effectName = effectName.substring(1).toLowerCase().replace("_", " ");
        effectName = effectFirst + effectName;
        return this.controller.getMessages().getLevelString("wand.potion_effect", level, 5.0f).replace("$effect", effectName);
    }

    protected void sendDebug(String debugMessage) {
    }

    protected void sendMessage(String messageKey) {
    }

    protected void sendAddMessage(String messageKey, String nameParam) {
        String message = this.getMessage(messageKey).replace("$name", nameParam);
        this.sendMessage(message);
    }

    protected String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    protected String getMessage(String messageKey, String defaultValue) {
        return this.controller.getMessages().get(messageKey, defaultValue);
    }

    public static String describeProperty(Object property) {
        return InventoryUtils.describeProperty(property, MAX_PROPERTY_DISPLAY_LENGTH);
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        ConfigurationSection itemConfig = this.getConfiguration();
        Set keys = itemConfig.getKeys(false);
        for (String key : keys) {
            Object value = itemConfig.get(key);
            if (value == null || ignoreProperties != null && ignoreProperties.contains(key)) continue;
            String propertyColor = PROPERTY_KEYS.contains(key) ? ChatColor.DARK_AQUA.toString() : ChatColor.DARK_GREEN.toString();
            sender.sendMessage(propertyColor + key + ChatColor.GRAY + ": " + ChatColor.WHITE + BaseMagicProperties.describeProperty(value));
        }
    }

    @Override
    public void describe(CommandSender sender) {
        this.describe(sender, null);
    }

    protected void clearProperty(String key) {
        this.configuration.set(key, null);
    }
}

