/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.heroes;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.heroes.HeroesSkillSpell;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.party.HeroParty;
import com.herocraftonline.heroes.characters.skill.ActiveSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillManager;
import com.herocraftonline.heroes.characters.skill.SkillSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HeroesManager {
    private Heroes heroes;
    private CharacterManager characters;
    private SkillManager skills;
    private static final Set<String> emptySkills = new HashSet<String>();
    private static final List<String> emptySkillList = new ArrayList<String>();

    public HeroesManager(Plugin plugin, Plugin heroesPlugin) {
        if (!(heroesPlugin instanceof Heroes)) {
            plugin.getLogger().warning("Heroes found, but is not instance of Heroes plugin!");
            return;
        }
        this.heroes = (Heroes)heroesPlugin;
        this.characters = this.heroes.getCharacterManager();
        this.skills = this.heroes.getSkillManager();
        if (this.characters != null && this.skills != null) {
            plugin.getLogger().info("Heroes found, skills available for wand and hotbar use.");
            plugin.getLogger().info("Give Magic.commands.mskills permission for /mskills command");
            plugin.getLogger().info("Use \"/wand heroes\" for a wand that uses Heroes skills");
        } else {
            plugin.getLogger().warning("Heroes found, but failed to integrate!");
            if (this.characters == null) {
                plugin.getLogger().warning(" CharacterManager is null");
            }
            if (this.skills == null) {
                plugin.getLogger().warning(" SkillManager is null");
            }
        }
    }

    public boolean canUseSkill(Player player, String skillName) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return false;
        }
        return hero.canUseSkill(skillName);
    }

    public List<String> getSkillList(Player player, boolean showUnuseable, boolean showPassive) {
        if (this.skills == null) {
            return emptySkillList;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return emptySkillList;
        }
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondClass();
        HashSet<String> primarySkills = new HashSet<String>();
        HashSet<String> secondarySkills = new HashSet<String>();
        this.addSkills(hero, heroClass, primarySkills, showUnuseable, showPassive);
        this.addSkills(hero, secondClass, secondarySkills, showUnuseable, showPassive);
        secondarySkills.removeAll(primarySkills);
        Multimap<Integer, Skill> primaryMap = this.mapSkillsByLevel(hero, primarySkills);
        Multimap<Integer, Skill> secondaryMap = this.mapSkillsByLevel(hero, secondarySkills);
        ArrayList<String> skillNames = new ArrayList<String>();
        for (Skill skill : primaryMap.values()) {
            skillNames.add(skill.getName());
        }
        for (Skill skill : secondaryMap.values()) {
            skillNames.add(skill.getName());
        }
        return skillNames;
    }

    private Multimap<Integer, Skill> mapSkillsByLevel(Hero hero, Collection<String> skillNames) {
        TreeMultimap skillMap = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new Comparator<Skill>(){

            @Override
            public int compare(Skill skill1, Skill skill2) {
                return skill1.getName().compareTo(skill2.getName());
            }
        });
        for (String skillName : skillNames) {
            Skill skill = this.skills.getSkill(skillName);
            if (skill == null) continue;
            int level = SkillConfigManager.getUseSetting((Hero)hero, (Skill)skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
            skillMap.put((Object)level, (Object)skill);
        }
        return skillMap;
    }

    public int getSkillLevel(Player player, String skillName) {
        Skill skill = this.skills.getSkill(skillName);
        if (skill == null) {
            return 0;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return SkillConfigManager.getUseSetting((Hero)hero, (Skill)skill, (SkillSetting)SkillSetting.LEVEL, (int)1, (boolean)true);
    }

    public Set<String> getSkills(Player player) {
        return this.getSkills(player, false, false);
    }

    private void addSkills(Hero hero, HeroClass heroClass, Collection<String> skillSet, boolean showUnuseable, boolean showPassive) {
        if (heroClass != null) {
            Set classSkills = heroClass.getSkillNames();
            for (String classSkill : classSkills) {
                Skill skill = this.skills.getSkill(classSkill);
                if (!showUnuseable && !hero.canUseSkill(skill) || !showPassive && !(skill instanceof ActiveSkill) || !SkillConfigManager.getRaw((Skill)skill, (String)"wand", (String)"true").equalsIgnoreCase("true")) continue;
                skillSet.add(classSkill);
            }
        }
    }

    public Set<String> getSkills(Player player, boolean showUnuseable, boolean showPassive) {
        if (this.skills == null) {
            return emptySkills;
        }
        Hero hero = this.getHero(player);
        if (hero == null) {
            return emptySkills;
        }
        HashSet<String> skillSet = new HashSet<String>();
        HeroClass heroClass = hero.getHeroClass();
        HeroClass secondClass = hero.getSecondClass();
        this.addSkills(hero, heroClass, skillSet, showUnuseable, showPassive);
        this.addSkills(hero, secondClass, skillSet, showUnuseable, showPassive);
        return skillSet;
    }

    public void clearCooldown(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        hero.clearCooldowns();
    }

    public void setCooldown(Player player, long ms) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        long cooldown = System.currentTimeMillis() + ms;
        Set<String> skills = this.getSkills(player, false, false);
        for (String skill : skills) {
            Long currentCooldown = hero.getCooldown(skill);
            if (currentCooldown != null && currentCooldown >= cooldown) continue;
            hero.setCooldown(skill, cooldown);
        }
    }

    public SpellTemplate createSkillSpell(MagicController controller, String skillName) {
        if (this.skills == null) {
            return null;
        }
        Skill skill = this.skills.getSkill(skillName);
        if (skill == null) {
            return null;
        }
        HeroesSkillSpell newSpell = new HeroesSkillSpell();
        newSpell.initialize(controller);
        MemoryConfiguration config = new MemoryConfiguration();
        String iconURL = SkillConfigManager.getRaw((Skill)skill, (String)"icon-url", (String)SkillConfigManager.getRaw((Skill)skill, (String)"icon_url", null));
        if (iconURL == null || iconURL.isEmpty()) {
            String icon = SkillConfigManager.getRaw((Skill)skill, (String)"icon", null);
            if (icon == null || icon.isEmpty()) {
                config.set("icon", (Object)controller.getDefaultSkillIcon());
            } else if (icon.startsWith("http://")) {
                config.set("icon_url", (Object)icon);
            } else {
                config.set("icon", (Object)icon);
            }
        } else {
            config.set("icon_url", (Object)iconURL);
        }
        String iconDisabledURL = SkillConfigManager.getRaw((Skill)skill, (String)"icon-disabled-url", (String)SkillConfigManager.getRaw((Skill)skill, (String)"icon_disabled_url", null));
        if (iconDisabledURL == null || iconDisabledURL.isEmpty()) {
            String icon = SkillConfigManager.getRaw((Skill)skill, (String)"icon-disabled", (String)SkillConfigManager.getRaw((Skill)skill, (String)"icon_disabled", null));
            if (icon != null && !icon.isEmpty()) {
                if (icon.startsWith("http://")) {
                    config.set("icon_disabled_url", (Object)icon);
                } else {
                    config.set("icon_disabled", (Object)icon);
                }
            }
        } else {
            config.set("icon_disabled_url", (Object)iconDisabledURL);
        }
        String nameTemplate = controller.getMessages().get("skills.item_name", "$skill");
        String skillDisplayName = SkillConfigManager.getRaw((Skill)skill, (String)"name", (String)skill.getName());
        config.set("name", (Object)nameTemplate.replace("$skill", skillDisplayName));
        config.set("category", (Object)"skills");
        String descriptionTemplate = controller.getMessages().get("skills.item_description", "$description");
        descriptionTemplate = descriptionTemplate.replace("$description", SkillConfigManager.getRaw((Skill)skill, (String)"description", (String)""));
        config.set("description", (Object)descriptionTemplate);
        newSpell.loadTemplate("heroes*" + skillName, (ConfigurationSection)config);
        return newSpell;
    }

    public String getClassName(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return "";
        }
        HeroClass heroClass = hero.getHeroClass();
        if (heroClass == null) {
            return "";
        }
        return heroClass.getName();
    }

    public String getSecondaryClassName(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return "";
        }
        HeroClass heroClass = hero.getSecondClass();
        if (heroClass == null) {
            return "";
        }
        return heroClass.getName();
    }

    protected Skill getSkill(String key) {
        if (this.skills == null) {
            return null;
        }
        return this.skills.getSkill(key);
    }

    protected Hero getHero(Player player) {
        if (this.characters == null) {
            return null;
        }
        return this.characters.getHero(player);
    }

    public int getMaxMana(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getMaxMana();
    }

    public int getManaRegen(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getManaRegen();
    }

    public int getMana(Player player) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return 0;
        }
        return hero.getMana();
    }

    public void removeMana(Player player, int amount) {
        Hero hero = this.getHero(player);
        if (hero == null) {
            return;
        }
        hero.setMana(Math.max(0, hero.getMana() - amount));
    }

    public boolean isInParty(Player source, Player check, boolean pvpCheck) {
        Hero sourceHero = this.getHero(source);
        Hero checkHero = this.getHero(check);
        if (sourceHero == null || checkHero == null) {
            return false;
        }
        HeroParty party = sourceHero.getParty();
        if (party == null || pvpCheck && !party.isNoPvp().booleanValue()) {
            return false;
        }
        return party.getMembers().contains(checkHero);
    }
}

