/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class OrientAction
extends BaseSpellAction {
    private Float pitch;
    private Float yaw;
    private Float pitchOffset;
    private Float yawOffset;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.pitch = parameters.contains("pitch") ? Float.valueOf((float)parameters.getDouble("pitch")) : null;
        this.yaw = parameters.contains("yaw") ? Float.valueOf((float)parameters.getDouble("yaw")) : null;
        this.pitchOffset = parameters.contains("pitch_offset") ? Float.valueOf((float)parameters.getDouble("pitch_offset")) : null;
        this.yawOffset = parameters.contains("yaw_offset") ? Float.valueOf((float)parameters.getDouble("yaw_offset")) : null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        Entity entity = mage.getEntity();
        if (entity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        context.registerMoved(entity);
        Location location = entity.getLocation();
        if (this.pitch != null || this.yaw != null) {
            if (this.pitch != null) {
                location.setPitch(this.pitch.floatValue());
            }
            if (this.yaw != null) {
                location.setYaw(this.yaw.floatValue());
            }
        }
        if (this.pitchOffset != null || this.yawOffset != null) {
            if (this.pitchOffset != null) {
                location.setPitch(location.getPitch() + this.pitchOffset.floatValue());
            }
            if (this.yawOffset != null) {
                location.setYaw(location.getYaw() + this.yawOffset.floatValue());
            }
        }
        if (this.pitchOffset == null && this.yawOffset == null && this.yaw == null && this.pitch == null) {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity == null) {
                return SpellResult.NO_TARGET;
            }
            Location direction = targetEntity.getLocation().subtract(location);
            location.setDirection(direction.toVector());
        }
        entity.teleport(location);
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("pitch");
        parameters.add("yaw");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("pitch") || parameterKey.equals("yaw")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

