/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.protection.TownyManager;
import org.bukkit.configuration.ConfigurationSection;

public class CreatePlotAction
extends BaseSpellAction {
    private Double price;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.price = parameters.contains("price") ? Double.valueOf(parameters.getDouble("price", 0.0)) : null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        MageController apiController = context.getController();
        if (!(apiController instanceof MagicController)) {
            return SpellResult.FAIL;
        }
        MagicController controller = (MagicController)apiController;
        TownyManager towny = controller.getTowny();
        if (!towny.createPlot(context.getTargetLocation(), this.price)) {
            return SpellResult.NO_TARGET;
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

