/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActionFactory {
    private static List<ActionResolver> resolvers = new ArrayList<ActionResolver>();

    public static List<ActionResolver> getActionResolvers() {
        return Collections.unmodifiableList(resolvers);
    }

    public static void registerResolver(ActionResolver actionResolver) {
        ActionFactory.registerResolver(actionResolver, false);
    }

    public static void registerResolver(ActionResolver actionResolver, boolean highPriority) {
        Preconditions.checkNotNull((Object)actionResolver);
        if (!resolvers.contains(actionResolver)) {
            if (highPriority) {
                resolvers.add(0, actionResolver);
            } else {
                resolvers.add(actionResolver);
            }
        }
    }

    public static void removeResolver(ActionResolver actionResolver) {
        Preconditions.checkNotNull((Object)actionResolver);
        Iterator<ActionResolver> it = resolvers.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(actionResolver)) continue;
            it.remove();
        }
    }

    private ActionFactory() {
    }

    public static void registerActionClass(String name, Class<?> clazz) {
        if (!BaseSpellAction.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Must extend SpellAction");
        }
        ActionConstructor constructor = InternalActionResolver.createConstructor(clazz);
        if (constructor == null) {
            throw new IllegalArgumentException("Class does not have a valid no-args constructor");
        }
        InternalActionResolver.actionClasses.put(name, constructor);
    }

    public static BaseSpellAction construct(String actionClassName) throws ActionFactoryException {
        ArrayList<String> attempts = new ArrayList<String>();
        for (ActionResolver resolver : resolvers) {
            ActionConstructor constructor = resolver.resolve(actionClassName, attempts);
            if (constructor == null) continue;
            return constructor.construct();
        }
        throw new ActionFactoryException("Failed to resolve class: " + actionClassName + "\nTried: " + attempts);
    }

    static {
        resolvers.add(new InternalActionResolver());
    }

    public static final class ActionFactoryException
    extends Exception {
        public ActionFactoryException(String msg, Throwable e) {
            super(msg, e);
        }

        public ActionFactoryException(String msg) {
            super(msg);
        }
    }

    private static final class InternalActionConstructor
    implements ActionConstructor {
        private Constructor<?> constructor;

        public InternalActionConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public BaseSpellAction construct() throws ActionFactoryException {
            try {
                return (BaseSpellAction)this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new ActionFactoryException("Failed to instantiate with reflection", e);
            }
        }
    }

    private static final class InternalActionResolver
    implements ActionResolver {
        private static final String ACTION_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.action.builtin";
        private static Map<String, ActionConstructor> actionClasses = new HashMap<String, ActionConstructor>();
        private static final String[] patterns = new String[]{"com.elmakers.mine.bukkit.action.builtin.%sAction", "com.elmakers.mine.bukkit.action.builtin.%s", "%sAction", "%s"};

        private InternalActionResolver() {
        }

        @Override
        public ActionConstructor resolve(String className, List<String> attempts) {
            ActionConstructor constructor = actionClasses.get(className);
            if (constructor != null) {
                return constructor;
            }
            for (String pattern : patterns) {
                Class<?> clazz;
                String path = String.format(pattern, className);
                attempts.add(path);
                try {
                    clazz = Class.forName(path);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!BaseSpellAction.class.isAssignableFrom(clazz) || (constructor = InternalActionResolver.createConstructor(clazz)) == null) continue;
                actionClasses.put(className, constructor);
                return constructor;
            }
            return null;
        }

        private static ActionConstructor createConstructor(Class<?> clazz) {
            Constructor<?> constructor;
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
            if (!Modifier.isPublic(constructor.getModifiers())) {
                return null;
            }
            return new InternalActionConstructor(constructor);
        }
    }

    public static interface ActionConstructor {
        public BaseSpellAction construct() throws ActionFactoryException;
    }

    public static class NamedActionResolver
    extends ForwardingMap<String, ActionConstructor>
    implements ActionResolver {
        private final Map<String, ActionConstructor> delegate;

        public NamedActionResolver(Map<String, ActionConstructor> delegate) {
            this.delegate = delegate;
        }

        public NamedActionResolver() {
            this(Maps.newHashMap());
        }

        @Override
        public ActionConstructor resolve(String className, List<String> attempts) {
            return (ActionConstructor)this.get(className);
        }

        protected Map<String, ActionConstructor> delegate() {
            return this.delegate;
        }
    }

    public static interface ActionResolver {
        public ActionConstructor resolve(String var1, List<String> var2);
    }
}

