/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ConfigUtils;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ParticleEffect;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ConfigurationUtils
extends ConfigUtils {
    public static Random random = new Random();

    public static Location getLocation(ConfigurationSection node, String path) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return null;
        }
        return ConfigurationUtils.toLocation(stringData);
    }

    public static BlockFace toBlockFace(String s) {
        BlockFace face = null;
        try {
            face = BlockFace.valueOf((String)s.toUpperCase());
        }
        catch (Exception ex) {
            face = null;
        }
        return face;
    }

    public static String fromBlockFace(BlockFace face) {
        return face.name().toLowerCase();
    }

    public static String fromVector(Vector vector) {
        if (vector == null) {
            return "";
        }
        return vector.getX() + "," + vector.getY() + "," + vector.getZ();
    }

    public static Vector getVector(ConfigurationSection node, String path) {
        return ConfigurationUtils.getVector(node, path, null);
    }

    public static Vector getVector(ConfigurationSection node, String path, Vector def) {
        String stringData = node.getString(path, null);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toVector(stringData);
    }

    public static Material getMaterial(ConfigurationSection node, String path, Material def) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toMaterial(stringData);
    }

    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterialAndData(node, path, null);
    }

    public static MaterialAndData getMaterialAndData(ConfigurationSection node, String path, MaterialAndData def) {
        String stringData = node.getString(path);
        if (stringData == null) {
            return def;
        }
        return ConfigurationUtils.toMaterialAndData(stringData);
    }

    public static Material getMaterial(ConfigurationSection node, String path) {
        return ConfigurationUtils.getMaterial(node, path, null);
    }

    public static String fromLocation(Location location) {
        if (location == null) {
            return "";
        }
        if (location.getWorld() == null) {
            return "";
        }
        return location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName() + "," + location.getYaw() + "," + location.getPitch();
    }

    public static String fromMaterial(Material material) {
        return material.name().toLowerCase();
    }

    public static String fromBlock(Block block) {
        return ConfigurationUtils.fromLocation(block.getLocation()) + "|" + block.getTypeId() + ":" + block.getData();
    }

    public static Location toLocation(Object o) {
        if (o instanceof Location) {
            return (Location)o;
        }
        if (o instanceof String) {
            try {
                float pitch = 0.0f;
                float yaw = 0.0f;
                String[] pieces = StringUtils.split((String)((String)o), (char)',');
                double x = Double.parseDouble(pieces[0]);
                double y = Double.parseDouble(pieces[1]);
                double z = Double.parseDouble(pieces[2]);
                World world = null;
                world = pieces.length > 3 ? Bukkit.getWorld((String)pieces[3]) : (World)Bukkit.getWorlds().get(0);
                if (pieces.length > 5) {
                    yaw = Float.parseFloat(pieces[4]);
                    pitch = Float.parseFloat(pieces[5]);
                }
                return new Location(world, x, y, z, yaw, pitch);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Vector toVector(Object o) {
        if (o instanceof Vector) {
            return (Vector)o;
        }
        if (o instanceof String) {
            try {
                String parse = (String)o;
                if (parse.isEmpty()) {
                    return null;
                }
                if (!parse.contains(" ")) {
                    parse = parse.replace(",", " ");
                }
                parse = parse.replace("|", " ");
                String[] pieces = StringUtils.split((String)parse, (char)' ');
                double x = ConfigurationUtils.parseDouble(pieces[0]);
                double y = ConfigurationUtils.parseDouble(pieces[1]);
                double z = ConfigurationUtils.parseDouble(pieces[2]);
                return new Vector(x, y, z);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                Integer value = Integer.parseInt(matName);
                return Material.getMaterial((int)value);
            }
            catch (NumberFormatException numberFormatException) {
                return Material.getMaterial((String)matName.toUpperCase());
            }
        }
        return null;
    }

    public static MaterialAndData toMaterialAndData(Object o) {
        if (o instanceof MaterialAndData) {
            return (MaterialAndData)o;
        }
        if (o instanceof String) {
            String matName = (String)o;
            return new MaterialAndData(matName);
        }
        return null;
    }

    protected void combine(Map<Object, Object> to, Map<? extends Object, Object> from) {
        for (Map.Entry<? extends Object, Object> entry : from.entrySet()) {
            Object toValue;
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value instanceof Map && to.containsKey(key) && (toValue = to.get(key)) instanceof Map) {
                this.combine((Map)toValue, (Map)value);
                continue;
            }
            to.put(key, value);
        }
    }

    public static ConfigurationSection cloneConfiguration(ConfigurationSection section) {
        return ConfigurationUtils.addConfigurations((ConfigurationSection)new MemoryConfiguration(), section);
    }

    private static Map<String, Object> replaceParameters(Map<String, Object> configuration, ConfigurationSection parameters) {
        if (configuration == null || configuration.isEmpty()) {
            return configuration;
        }
        HashMap<String, Object> replaced = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : configuration.entrySet()) {
            Object entryValue = entry.getValue();
            Object replacement = ConfigurationUtils.replaceParameters(entryValue, parameters);
            if (replacement == null) continue;
            replaced.put(entry.getKey(), replacement);
        }
        return replaced;
    }

    private static Object replaceParameters(Object value, ConfigurationSection parameters) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            value = ConfigurationUtils.replaceParameters(map, parameters);
        } else if (value instanceof ConfigurationSection) {
            value = ConfigurationUtils.replaceParameters(value, parameters);
        } else if (value instanceof List) {
            List list = (List)value;
            value = ConfigurationUtils.replaceParameters(list, parameters);
        } else if (value instanceof String) {
            value = ConfigurationUtils.replaceParameter((String)value, parameters);
        }
        return value;
    }

    private static List<Object> replaceParameters(List<Object> configurations, ConfigurationSection parameters) {
        if (configurations == null || configurations.size() == 0) {
            return configurations;
        }
        ArrayList<Object> replaced = new ArrayList<Object>();
        for (Object value : configurations) {
            Object replacement = ConfigurationUtils.replaceParameters(value, parameters);
            if (replacement == null) continue;
            replaced.add(replacement);
        }
        return replaced;
    }

    private static Object replaceParameter(String value, ConfigurationSection parameters) {
        if (value.length() < 2 || value.charAt(0) != '$') {
            return value;
        }
        return parameters.get(value.substring(1));
    }

    public static ConfigurationSection replaceParameters(ConfigurationSection configuration, ConfigurationSection parameters) {
        if (configuration == null) {
            return null;
        }
        MemoryConfiguration replaced = new MemoryConfiguration();
        Map<String, Object> map = NMSUtils.getMap(configuration);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object replacement;
            Object value = entry.getValue();
            if (value == null || (replacement = ConfigurationUtils.replaceParameters(value, parameters)) == null) continue;
            replaced.set(entry.getKey(), replacement);
        }
        return replaced;
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second) {
        return ConfigurationUtils.addConfigurations(first, second, true);
    }

    public static ConfigurationSection addConfigurations(ConfigurationSection first, ConfigurationSection second, boolean override) {
        if (second == null) {
            return first;
        }
        Map<String, Object> map = NMSUtils.getMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey();
            Object existingValue = first.get(key);
            if (value instanceof Map) {
                value = ConfigurationUtils.getConfigurationSection(second, key);
            }
            if (existingValue instanceof Map) {
                existingValue = ConfigurationUtils.getConfigurationSection(first, key);
            }
            if (value instanceof ConfigurationSection && (existingValue == null || existingValue instanceof ConfigurationSection)) {
                ConfigurationSection addChild = (ConfigurationSection)value;
                if (existingValue == null || !addChild.getBoolean("inherit", true)) {
                    ConfigurationSection newChild = first.createSection(key);
                    ConfigurationUtils.addConfigurations(newChild, addChild, override);
                    continue;
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)existingValue, addChild, override);
                continue;
            }
            if (!override && existingValue != null) continue;
            first.set(key, value);
        }
        return first;
    }

    public static ConfigurationSection replaceConfigurations(ConfigurationSection first, ConfigurationSection second) {
        if (second == null) {
            return first;
        }
        Map<String, Object> map = NMSUtils.getMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            first.set(entry.getKey(), entry.getValue());
        }
        return first;
    }

    public static ConfigurationSection overlayConfigurations(ConfigurationSection first, ConfigurationSection second) {
        if (second == null) {
            return first;
        }
        Map<String, Object> map = NMSUtils.getMap(second);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (first.contains(entry.getKey())) continue;
            first.set(entry.getKey(), entry.getValue());
        }
        return first;
    }

    protected static double parseDouble(String s) {
        char firstChar = s.charAt(0);
        if (firstChar == 'r' || firstChar == 'R') {
            String[] pieces = StringUtils.split((String)s, (String)"(,)");
            try {
                double min = Double.parseDouble(pieces[1].trim());
                double max = Double.parseDouble(pieces[2].trim());
                return random.nextDouble() * (max - min) + min;
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Failed to parse: " + s);
                ex.printStackTrace();
            }
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Failed to parse as double: " + s);
            ex.printStackTrace();
            return 0.0;
        }
    }

    protected static int parseInt(String s) {
        char firstChar = s.charAt(0);
        if (firstChar == 'r' || firstChar == 'R') {
            String[] pieces = StringUtils.split((String)s, (String)"(,)");
            try {
                double min = Double.parseDouble(pieces[1].trim());
                double max = Double.parseDouble(pieces[2].trim());
                return (int)Math.floor(random.nextDouble() * (max - min) + min);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Failed to parse: " + s);
                ex.printStackTrace();
            }
        }
        try {
            return (int)Math.floor(Double.parseDouble(s));
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Failed to parse as int: " + s);
            ex.printStackTrace();
            return 0;
        }
    }

    public static double overrideDouble(String override, double value) {
        if (override == null || override.length() == 0) {
            return value;
        }
        try {
            if (override.startsWith("~")) {
                override = override.substring(1);
                value += ConfigurationUtils.parseDouble(override);
            } else if (override.startsWith("*")) {
                override = override.substring(1);
                value *= ConfigurationUtils.parseDouble(override);
            } else {
                value = ConfigurationUtils.parseDouble(override);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected static double overrideDouble(ConfigurationSection node, double value, String nodeName) {
        String override = node.getString(nodeName);
        return ConfigurationUtils.overrideDouble(override, value);
    }

    public static World overrideWorld(ConfigurationSection node, String path, World world, boolean canCreateWorlds) {
        return ConfigurationUtils.overrideWorld(node.getString(path), world, canCreateWorlds);
    }

    public static World overrideWorld(String worldName, World world, boolean canCreateWorlds) {
        World worldOverride;
        if (worldName == null || worldName.length() == 0) {
            return null;
        }
        if (worldName.charAt(0) == '~') {
            if (world == null) {
                return null;
            }
            String baseWorld = world.getName();
            worldName = worldName.substring(1);
            if ((worldName = worldName.trim()).charAt(0) == '-') {
                worldName = worldName.substring(1);
                worldName = worldName.trim();
                worldName = baseWorld.replace(worldName, "");
            } else {
                worldName = baseWorld + worldName;
            }
        }
        if ((worldOverride = Bukkit.getWorld((String)worldName)) == null) {
            if (canCreateWorlds && world != null) {
                Bukkit.getLogger().info("Creating/Loading world: " + worldName);
                worldOverride = Bukkit.createWorld((WorldCreator)new WorldCreator(worldName).copy(world));
                if (worldOverride == null) {
                    Bukkit.getLogger().warning("Failed to load world: " + worldName);
                    return null;
                }
            } else {
                Bukkit.getLogger().warning("Could not load world: " + worldName);
                return null;
            }
        }
        return worldOverride;
    }

    public static Location overrideLocation(ConfigurationSection node, String basePath, Location location, boolean canCreateWorlds) {
        String xName = basePath + "x";
        String yName = basePath + "y";
        String zName = basePath + "z";
        String dxName = basePath + "dx";
        String dyName = basePath + "dy";
        String dzName = basePath + "dz";
        boolean hasPosition = node.contains(xName) || node.contains(yName) || node.contains(zName);
        boolean hasDirection = node.contains(dxName) || node.contains(dyName) || node.contains(dzName);
        World baseWorld = location == null ? null : location.getWorld();
        World worldOverride = ConfigurationUtils.overrideWorld(node, basePath + "world", baseWorld, canCreateWorlds);
        if (!hasPosition && !hasDirection && worldOverride == null) {
            return null;
        }
        if (location == null) {
            if (worldOverride == null) {
                return null;
            }
            location = new Location(worldOverride, 0.0, 0.0, 0.0);
        } else {
            location = location.clone();
            if (worldOverride != null) {
                location.setWorld(worldOverride);
            }
        }
        if (hasPosition) {
            location.setX(ConfigurationUtils.overrideDouble(node, location.getX(), xName));
            location.setY(ConfigurationUtils.overrideDouble(node, location.getY(), yName));
            location.setZ(ConfigurationUtils.overrideDouble(node, location.getZ(), zName));
        }
        if (hasDirection) {
            Vector direction = location.getDirection();
            direction.setX(ConfigurationUtils.overrideDouble(node, direction.getX(), dxName));
            direction.setY(ConfigurationUtils.overrideDouble(node, direction.getY(), dyName));
            direction.setZ(ConfigurationUtils.overrideDouble(node, direction.getZ(), dzName));
            location.setDirection(direction);
        }
        return location;
    }

    public static Color getColor(ConfigurationSection node, String path, Color def) {
        Color o = ConfigurationUtils.toColor(node.get(path));
        return o == null ? def : o;
    }

    public static Color toColor(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return Color.fromRGB((int)((Byte)o).byteValue());
        }
        if (o instanceof Integer) {
            return Color.fromRGB((int)((Integer)o));
        }
        if (o instanceof Double) {
            return Color.fromRGB((int)((int)((Double)o).doubleValue()));
        }
        if (o instanceof Float) {
            return Color.fromRGB((int)((int)((Float)o).floatValue()));
        }
        if (o instanceof Long) {
            return Color.fromRGB((int)((int)((Long)o).longValue()));
        }
        if (o instanceof String) {
            try {
                String s = (String)o;
                if (s.length() == 0) {
                    return null;
                }
                if (s.charAt(0) == '#') {
                    s = s.substring(1, s.length());
                }
                Integer rgb = Integer.parseInt(s, 16);
                return Color.fromRGB((int)rgb);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static Integer getInteger(ConfigurationSection node, String path, Integer def) {
        if (node.contains(path)) {
            return ConfigurationUtils.parseInt(node.getString(path));
        }
        return def;
    }

    public static Double getDouble(ConfigurationSection node, String path, Double def) {
        if (node.contains(path)) {
            return ConfigurationUtils.parseDouble(node.getString(path));
        }
        return def;
    }

    public static Boolean getBoolean(ConfigurationSection node, String path, Boolean def) {
        if (node.contains(path)) {
            return node.getBoolean(path);
        }
        return def;
    }

    public static List<Object> getList(ConfigurationSection section, String path) {
        Object o = section.get(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            return new ArrayList<Object>(Arrays.asList(StringUtils.split((String)((String)o), (char)',')));
        }
        ArrayList<Object> single = new ArrayList<Object>();
        single.add(o);
        return single;
    }

    public static void addIfNotEmpty(String message, Collection<String> list) {
        if (message != null && !message.isEmpty()) {
            list.add(message);
        }
    }

    public static List<String> getStringList(ConfigurationSection section, String path, List<String> def) {
        ArrayList list = ConfigurationUtils.getStringList(section, path);
        return list == null ? (def == null ? new ArrayList() : def) : list;
    }

    public static List<String> getStringList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigurationUtils.getList(section, path);
        if (raw == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public static List<Integer> getIntegerList(ConfigurationSection section, String path) {
        List<Object> raw = ConfigurationUtils.getList(section, path);
        if (raw == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigurationUtils.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static void addParameters(String[] extraParameters, ConfigurationSection parameters) {
        if (extraParameters != null) {
            for (int i = 0; i < extraParameters.length - 1; i += 2) {
                ConfigurationUtils.set(parameters, extraParameters[i], extraParameters[i + 1]);
            }
        }
    }

    public static String getParameters(ConfigurationSection parameters) {
        ArrayList<String> parameterStrings = new ArrayList<String>();
        Map<String, Object> map = NMSUtils.getMap(parameters);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            parameterStrings.add(entry.getKey());
            parameterStrings.add(entry.getValue().toString());
        }
        return StringUtils.join(parameterStrings, (char)' ');
    }

    public static SoundEffect toSoundEffect(String soundConfig) {
        return new SoundEffect(soundConfig);
    }

    public static ParticleEffect toParticleEffect(String effectParticleName) {
        ParticleEffect effectParticle = null;
        if (effectParticleName.length() > 0) {
            String particleName = effectParticleName.toUpperCase();
            try {
                effectParticle = ParticleEffect.valueOf(particleName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return effectParticle;
    }

    public static Collection<PrerequisiteSpell> getPrerequisiteSpells(MageController controller, ConfigurationSection node, String key, String loadContext, boolean removeMissing) {
        if (node == null || key == null) {
            return new ArrayList<PrerequisiteSpell>(0);
        }
        Collection spells = null;
        if (node.isString(key)) {
            spells = ConfigurationUtils.getStringList(node, key);
        } else if (node.isConfigurationSection(key)) {
            ConfigurationSection spellSection = node.getConfigurationSection(key);
            if (spellSection != null) {
                spells = spellSection.getKeys(false);
            }
        } else {
            spells = node.getList(key);
        }
        if (spells == null) {
            spells = new ArrayList(0);
        }
        ArrayList<PrerequisiteSpell> requiredSpells = new ArrayList<PrerequisiteSpell>(spells.size());
        for (Object o : spells) {
            String spell;
            PrerequisiteSpell prerequisiteSpell = null;
            if (o instanceof String) {
                prerequisiteSpell = new PrerequisiteSpell(new SpellKey((String)o), 0L);
            } else if (o instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)o;
                spell = section.getString("spell");
                long progressLevel = section.getLong("progress_level");
                prerequisiteSpell = new PrerequisiteSpell(new SpellKey(spell), progressLevel);
            } else if (o instanceof Map) {
                String progressLevelString;
                Map map = (Map)o;
                spell = map.get("spell").toString();
                String string = progressLevelString = map.containsKey("progress_level") ? map.get("progress_level").toString() : "0";
                if (spell != null && StringUtils.isNumeric((String)progressLevelString)) {
                    long progressLevel = 0L;
                    try {
                        progressLevel = Long.parseLong(progressLevelString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    prerequisiteSpell = new PrerequisiteSpell(new SpellKey(spell), progressLevel);
                }
            }
            if (prerequisiteSpell == null) continue;
            if (controller.getSpellTemplate(prerequisiteSpell.getSpellKey().getKey()) != null) {
                requiredSpells.add(prerequisiteSpell);
                continue;
            }
            if (!removeMissing) {
                requiredSpells.add(prerequisiteSpell);
                controller.getLogger().warning("Unknown or disabled spell requirement " + prerequisiteSpell.getSpellKey().getKey() + " in " + loadContext + ", upgrade will be disabled");
                continue;
            }
            controller.getLogger().warning("Unknown or disabled spell prerequisite " + prerequisiteSpell.getSpellKey().getKey() + " in " + loadContext + ", ignoring");
        }
        return requiredSpells;
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig) {
        return ConfigurationUtils.getPotionEffects(effectConfig, null);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig, Integer duration) {
        return ConfigurationUtils.getPotionEffects(effectConfig, duration, true, true);
    }

    public static Collection<PotionEffect> getPotionEffects(ConfigurationSection effectConfig, Integer duration, boolean ambient, boolean particles) {
        if (effectConfig == null) {
            return null;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        Set keys = effectConfig.getKeys(false);
        if (keys.isEmpty()) {
            return null;
        }
        for (String key : keys) {
            String value = effectConfig.getString(key);
            try {
                PotionEffectType effectType = PotionEffectType.getByName((String)key.toUpperCase());
                int ticks = 10;
                int power = 1;
                if (value.contains(",")) {
                    String[] pieces = StringUtils.split((String)value, (char)',');
                    ticks = (int)Float.parseFloat(pieces[0]);
                    power = (int)Float.parseFloat(pieces[1]);
                } else {
                    power = (int)Float.parseFloat(value);
                    if (duration != null) {
                        ticks = duration / 50;
                    }
                }
                PotionEffect effect = new PotionEffect(effectType, ticks, power, ambient, particles);
                effects.add(effect);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Error parsing potion effect for " + key + ": " + value);
            }
        }
        return effects;
    }

    public static List<PotionEffect> getPotionEffectObjects(ConfigurationSection baseConfig, String key, Logger log) {
        ArrayList<PotionEffect> potionEffects = null;
        Collection<ConfigurationSection> potionEffectList = ConfigurationUtils.getNodeList(baseConfig, key);
        if (potionEffectList != null) {
            potionEffects = new ArrayList<PotionEffect>();
            for (ConfigurationSection potionEffectSection : potionEffectList) {
                try {
                    PotionEffectType effectType = PotionEffectType.getByName((String)potionEffectSection.getString("type").toUpperCase());
                    if (effectType == null) {
                        log.log(Level.WARNING, "Invalid potion effect type: " + potionEffectSection.getString("type", "(null)"));
                        continue;
                    }
                    int ticks = (int)(potionEffectSection.getLong("duration", 3600000L) / 50L);
                    ticks = potionEffectSection.getInt("ticks", ticks);
                    int amplifier = potionEffectSection.getInt("amplifier", 0);
                    boolean ambient = potionEffectSection.getBoolean("ambient", true);
                    boolean particles = potionEffectSection.getBoolean("particles", true);
                    potionEffects.add(new PotionEffect(effectType, ticks, amplifier, ambient, particles));
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Invalid potion effect type: " + potionEffectSection.getString("type", "(null)"), ex);
                }
            }
        }
        return potionEffects;
    }
}

