/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;

public class MagicMobCommandExecutor
extends MagicTabExecutor {
    public MagicMobCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        BlockCommandSender commandBlock;
        if (!this.api.hasPermission(sender, "Magic.commands.mmob")) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: mmob [spawn|list] <type>");
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            this.onListMobs(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("clear")) {
            String mobType = args.length > 1 ? args[1] : null;
            String worldName = args.length > 2 ? args[2] : null;
            this.onClearMobs(sender, mobType, worldName);
            return true;
        }
        if (!args[0].equalsIgnoreCase("spawn") || args.length < 2) {
            return false;
        }
        if (!(sender instanceof Player) && !(sender instanceof BlockCommandSender) && args.length < 6) {
            sender.sendMessage(ChatColor.RED + "Usage: mmob spawn <type> <x> <y> <z> <world>");
            return true;
        }
        Location targetLocation = null;
        World targetWorld = null;
        Player player = sender instanceof Player ? (Player)sender : null;
        BlockCommandSender blockCommandSender = commandBlock = sender instanceof BlockCommandSender ? (BlockCommandSender)sender : null;
        if (args.length >= 6) {
            targetWorld = Bukkit.getWorld((String)args[5]);
            if (targetWorld == null) {
                sender.sendMessage(ChatColor.RED + "Invalid world: " + ChatColor.GRAY + args[5]);
                return true;
            }
        } else if (player != null) {
            targetWorld = player.getWorld();
        } else if (commandBlock != null) {
            Block block = commandBlock.getBlock();
            targetWorld = block.getWorld();
            targetLocation = block.getLocation();
        }
        if (args.length >= 5) {
            try {
                double currentX = 0.0;
                double currentY = 0.0;
                double currentZ = 0.0;
                if (player != null) {
                    Location currentLocation = player.getLocation();
                    currentX = currentLocation.getX();
                    currentY = currentLocation.getY();
                    currentZ = currentLocation.getZ();
                } else if (commandBlock != null) {
                    Block blockLocation = commandBlock.getBlock();
                    currentX = blockLocation.getX();
                    currentY = blockLocation.getY();
                    currentZ = blockLocation.getZ();
                }
                targetLocation = new Location(targetWorld, ConfigurationUtils.overrideDouble(args[2], currentX), ConfigurationUtils.overrideDouble(args[3], currentY), ConfigurationUtils.overrideDouble(args[4], currentZ));
            }
            catch (Exception ex) {
                targetLocation = null;
            }
        } else if (player != null) {
            Location location = player.getEyeLocation();
            BlockIterator iterator = new BlockIterator(location.getWorld(), location.toVector(), location.getDirection(), 0.0, 64);
            Block block = location.getBlock();
            while (block.getType() == Material.AIR && iterator.hasNext()) {
                block = iterator.next();
            }
            block = block.getRelative(BlockFace.UP);
            targetLocation = block.getLocation();
        }
        if (targetLocation == null || targetLocation.getWorld() == null) {
            sender.sendMessage(ChatColor.RED + "Usage: mmob spawn <type> <x> <y> <z> <world>");
            return true;
        }
        String mobKey = args[1];
        MageController controller = this.api.getController();
        Entity spawned = controller.spawnMob(mobKey, targetLocation);
        if (spawned == null) {
            sender.sendMessage(ChatColor.RED + "Unknown mob type " + mobKey);
            return true;
        }
        String name = spawned.getName();
        if (name == null) {
            name = mobKey;
        }
        sender.sendMessage(ChatColor.AQUA + "Spawned mob: " + ChatColor.LIGHT_PURPLE + name);
        return true;
    }

    protected void onListMobs(CommandSender sender) {
        HashMap<String, Integer> mobCounts = new HashMap<String, Integer>();
        ArrayList<Mage> mages = new ArrayList<Mage>(this.api.getController().getMages());
        for (Mage mage : mages) {
            EntityData entityData = mage.getEntityData();
            if (entityData == null) continue;
            Integer mobCount = (Integer)mobCounts.get(entityData.getKey());
            if (mobCount == null) {
                mobCounts.put(entityData.getKey(), 1);
                continue;
            }
            mobCounts.put(entityData.getKey(), mobCount + 1);
        }
        Set<String> keys = this.api.getController().getMobKeys();
        for (String key : keys) {
            EntityData mobType = this.api.getController().getMob(key);
            String message = ChatColor.AQUA + key + ChatColor.WHITE + " : " + ChatColor.DARK_AQUA + mobType.describe();
            Integer mobCount = (Integer)mobCounts.get(key);
            if (mobCount != null) {
                message = message + ChatColor.GRAY + " (" + ChatColor.GREEN + mobCount + ChatColor.DARK_GREEN + " Active" + ChatColor.GRAY + ")";
            }
            sender.sendMessage(message);
        }
    }

    protected void onClearMobs(CommandSender sender, String mobType, String worldName) {
        ArrayList<Mage> mages = new ArrayList<Mage>(this.api.getController().getMages());
        int removed = 0;
        for (Mage mage : mages) {
            EntityData entityData = mage.getEntityData();
            if (entityData == null || worldName != null && !mage.getLocation().getWorld().getName().equals(worldName) || mobType != null && !entityData.getKey().equals(mobType)) continue;
            Entity entity = mage.getEntity();
            mage.undoScheduled();
            this.api.getController().removeMage(mage);
            if (entity != null) {
                entity.remove();
            }
            ++removed;
        }
        ArrayList<World> worlds = new ArrayList<World>();
        if (worldName != null) {
            worlds.add(Bukkit.getWorld((String)worldName));
        } else {
            worlds.addAll(Bukkit.getWorlds());
        }
        HashSet<String> mobNames = new HashSet<String>();
        if (mobType != null) {
            EntityData mob = this.api.getController().getMob(mobType);
            mobNames.add(mob.getName());
        } else {
            Set<String> allKeys = this.api.getController().getMobKeys();
            for (String key : allKeys) {
                EntityData mob = this.api.getController().getMob(key);
                mobNames.add(mob.getName());
            }
        }
        for (World world : worlds) {
            List entities = world.getEntities();
            for (Entity entity : entities) {
                String customName = entity.getCustomName();
                if (!entity.isValid() || customName == null || !mobNames.contains(customName)) continue;
                entity.remove();
                ++removed;
            }
        }
        sender.sendMessage("Removed " + removed + " magic mobs");
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options;
        block4: {
            block5: {
                block3: {
                    options = new ArrayList<String>();
                    if (!sender.hasPermission("Magic.commands.mmob")) {
                        return options;
                    }
                    if (args.length != 1) break block3;
                    options.add("spawn");
                    options.add("list");
                    options.add("clear");
                    break block4;
                }
                if (args.length != 2 || !args[0].equalsIgnoreCase("spawn") && !args[0].equalsIgnoreCase("clear")) break block5;
                options.addAll(this.api.getController().getMobKeys());
                for (EntityType entityType : EntityType.values()) {
                    if (!entityType.isAlive() || !entityType.isSpawnable()) continue;
                    options.add(entityType.name().toLowerCase());
                }
                break block4;
            }
            if (args.length != 3 || !args[0].equalsIgnoreCase("clear")) break block4;
            List worlds = this.api.getPlugin().getServer().getWorlds();
            for (World world : worlds) {
                options.add(world.getName());
            }
        }
        return options;
    }
}

