/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MageProperties
extends CasterProperties {
    private final Mage mage;

    public MageProperties(Mage mage) {
        super(MagicPropertyType.MAGE, mage.getController());
        this.mage = mage;
    }

    @Override
    protected void rebuildEffectiveConfiguration(ConfigurationSection effectiveConfiguration) {
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        sender.sendMessage(ChatColor.AQUA + "Properties for Mage " + ChatColor.GREEN + this.mage.getName());
        Set hideKeys = ignoreProperties;
        MageClass activeClass = this.mage.getActiveClass();
        if (activeClass != null) {
            hideKeys = activeClass.getEffectiveConfiguration().getKeys(false);
            if (ignoreProperties != null) {
                hideKeys.addAll(ignoreProperties);
            }
        }
        super.describe(sender, hideKeys);
        if (activeClass != null) {
            sender.sendMessage(ChatColor.AQUA + "Active Class: " + ChatColor.GREEN + activeClass.getTemplate().getKey());
            activeClass.describe(sender, ignoreProperties);
        }
    }
}

