/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageProperties;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MageClass
extends CasterProperties
implements com.elmakers.mine.bukkit.api.magic.MageClass {
    protected final MageClassTemplate template;
    protected final MageProperties mage;
    private MageClass parent;

    public MageClass(@Nonnull Mage mage, @Nonnull MageClassTemplate template) {
        super(template.hasParent() ? MagicPropertyType.SUBCLASS : MagicPropertyType.CLASS, mage.getController());
        this.template = template;
        this.mage = mage.getProperties();
    }

    @Override
    protected void rebuildEffectiveConfiguration(@Nonnull ConfigurationSection effectiveConfiguration) {
        ConfigurationSection templateConfiguration = this.template.getEffectiveConfiguration();
        ConfigurationUtils.overlayConfigurations(effectiveConfiguration, templateConfiguration);
        if (this.parent != null) {
            ConfigurationSection parentConfiguration = this.parent.getEffectiveConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        } else {
            ConfigurationSection mageConfiguration = this.mage.getEffectiveConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, mageConfiguration);
        }
    }

    @Nonnull
    public MageClassTemplate getTemplate() {
        return this.template;
    }

    @Nullable
    public MageClass getParent() {
        return this.parent;
    }

    public void setParent(@Nonnull MageClass parent) {
        this.parent = parent;
        this.dirty = true;
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties) {
        super.describe(sender, ignoreProperties);
        Set hideKeys = this.getConfiguration().getKeys(false);
        if (ignoreProperties != null) {
            hideKeys.addAll(ignoreProperties);
        }
        this.template.describe(sender, hideKeys);
        hideKeys.addAll(this.template.getConfiguration().getKeys(false));
        MageClass parent = this.getParent();
        if (parent != null) {
            sender.sendMessage(ChatColor.AQUA + "Parent Class: " + ChatColor.GREEN + parent.getTemplate().getKey());
            parent.describe(sender, hideKeys);
        }
    }
}

