/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public abstract class InheritedMagicProperties
extends BaseMagicProperties {
    protected ConfigurationSection effectiveConfiguration = new MemoryConfiguration();
    protected boolean dirty = true;

    protected InheritedMagicProperties(@Nonnull MageController controller) {
        super(controller);
    }

    @Override
    public ConfigurationSection getEffectiveConfiguration() {
        this.rebuildEffectiveConfiguration();
        return this.effectiveConfiguration;
    }

    protected void rebuildEffectiveConfiguration() {
        if (this.dirty) {
            this.effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.configuration);
            this.rebuildEffectiveConfiguration(this.effectiveConfiguration);
            this.dirty = false;
        }
    }

    protected abstract void rebuildEffectiveConfiguration(@Nonnull ConfigurationSection var1);

    @Override
    public void clear() {
        super.clear();
        this.effectiveConfiguration = new MemoryConfiguration();
        this.dirty = true;
    }

    @Override
    public void load(@Nullable ConfigurationSection configuration) {
        super.load(configuration);
        this.dirty = true;
    }
}

