/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public abstract class CasterProperties
extends BaseMagicConfigurable {
    protected int manaRegeneration = 0;
    protected int manaMax = 0;
    protected long lastManaRegeneration = 0L;
    protected float mana = 0.0f;
    protected int effectiveManaMax = 0;
    protected int effectiveManaRegeneration = 0;
    protected float manaMaxBoost = 0.0f;
    protected float manaRegenerationBoost = 0.0f;
    protected float costReduction = 0.0f;

    public CasterProperties(MagicPropertyType type, MageController controller) {
        super(type, controller);
    }

    public int getManaRegeneration() {
        return this.manaRegeneration;
    }

    public int getManaMax() {
        return this.manaMax;
    }

    public void setMana(float mana) {
        if (this.isCostFree()) {
            this.setProperty("mana", null);
        } else {
            this.mana = Math.max(0.0f, mana);
            this.setProperty("mana", Float.valueOf(this.mana));
        }
    }

    public void setManaMax(int manaMax) {
        this.manaMax = Math.max(0, manaMax);
        this.setProperty("mana_max", this.manaMax);
    }

    public float getMana() {
        return this.mana;
    }

    public void removeMana(float amount) {
        this.setMana(this.mana - amount);
    }

    public float getManaRegenerationBoost() {
        return this.manaRegenerationBoost;
    }

    public float getManaMaxBoost() {
        return this.manaMaxBoost;
    }

    public float getCostReduction() {
        if (this.isCostFree()) {
            return 1.0f;
        }
        return this.controller.getCostReduction() + this.costReduction * this.controller.getMaxCostReduction();
    }

    public boolean isCostFree() {
        return this.costReduction > 1.0f;
    }

    public int getEffectiveManaMax() {
        return this.effectiveManaMax;
    }

    public int getEffectiveManaRegeneration() {
        return this.effectiveManaRegeneration;
    }

    public void loadProperties() {
        this.loadProperties(this.getEffectiveConfiguration());
    }

    protected void loadProperties(ConfigurationSection config) {
        this.manaRegeneration = config.getInt("mana_regeneration", config.getInt("xp_regeneration"));
        this.manaMax = config.getInt("mana_max", config.getInt("xp_max"));
        this.mana = config.getInt("mana", config.getInt("xp"));
        this.lastManaRegeneration = config.getLong("mana_timestamp");
        this.manaMaxBoost = (float)config.getDouble("mana_max_boost", config.getDouble("xp_max_boost"));
        this.manaRegenerationBoost = (float)config.getDouble("mana_regeneration_boost", config.getDouble("xp_regeneration_boost"));
        this.updateMaxMana(null);
    }

    protected boolean updateMaxMana(Mage mage) {
        if (!this.usesMana()) {
            return false;
        }
        int currentMana = this.effectiveManaMax;
        int currentManaRegen = this.effectiveManaRegeneration;
        float effectiveBoost = this.manaMaxBoost;
        float effectiveRegenBoost = this.manaRegenerationBoost;
        if (mage != null) {
            Wand offhandWand;
            Collection<Wand> activeArmor = mage.getActiveArmor();
            for (Wand armorWand : activeArmor) {
                effectiveBoost += armorWand.getManaMaxBoost();
                effectiveRegenBoost += armorWand.getManaRegenerationBoost();
            }
            Wand activeWand = mage.getActiveWand();
            if (activeWand != null && !activeWand.isPassive()) {
                effectiveBoost += activeWand.getManaMaxBoost();
                effectiveRegenBoost += activeWand.getManaRegenerationBoost();
            }
            if ((offhandWand = mage.getOffhandWand()) != null && !offhandWand.isPassive()) {
                effectiveBoost += offhandWand.getManaMaxBoost();
                effectiveRegenBoost += offhandWand.getManaRegenerationBoost();
            }
        }
        this.effectiveManaMax = this.manaMax;
        if (effectiveBoost != 0.0f) {
            this.effectiveManaMax = (int)Math.ceil((float)this.effectiveManaMax + effectiveBoost * (float)this.effectiveManaMax);
        }
        this.effectiveManaRegeneration = this.manaRegeneration;
        if (effectiveRegenBoost != 0.0f) {
            this.effectiveManaRegeneration = (int)Math.ceil((float)this.effectiveManaRegeneration + effectiveRegenBoost * (float)this.effectiveManaRegeneration);
        }
        return currentMana != this.effectiveManaMax || this.effectiveManaRegeneration != currentManaRegen;
    }

    public boolean usesMana() {
        if (this.isCostFree()) {
            return false;
        }
        return this.manaMax > 0;
    }

    public boolean tickMana() {
        boolean updated = false;
        if (this.usesMana()) {
            long now = System.currentTimeMillis();
            if (this.manaRegeneration > 0 && this.lastManaRegeneration > 0L && this.effectiveManaRegeneration > 0) {
                long delta = now - this.lastManaRegeneration;
                if (this.effectiveManaMax == 0 && this.manaMax > 0) {
                    this.effectiveManaMax = this.manaMax;
                }
                this.setMana(Math.min((float)this.effectiveManaMax, this.mana + (float)this.effectiveManaRegeneration * (float)delta / 1000.0f));
                updated = true;
            }
            this.lastManaRegeneration = now;
            this.setProperty("mana_timestamp", this.lastManaRegeneration);
        }
        return updated;
    }

    public void tick() {
        this.tickMana();
    }
}

