/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicConfigurable;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.InheritedMagicProperties;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.NumberConversions;

public abstract class BaseMagicConfigurable
extends InheritedMagicProperties
implements MagicConfigurable {
    protected final MagicPropertyType type;

    public BaseMagicConfigurable(MagicPropertyType type, MageController controller) {
        super(controller);
        this.type = type;
    }

    public void setProperty(String key, Object value) {
        this.configuration.set(key, value);
        this.dirty = true;
    }

    protected void convertProperties(ConfigurationSection properties) {
        Set keys = properties.getKeys(true);
        for (String key : keys) {
            Object converted;
            Object original = properties.get(key);
            if (original == (converted = this.convertProperty(original))) continue;
            properties.set(key, converted);
        }
    }

    protected Object convertProperty(Object value) {
        Object result = value;
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            result = isTrue;
        } else {
            try {
                result = value instanceof Double ? (Double)value : (value instanceof Float ? (double)((Float)value).floatValue() : Double.parseDouble(value.toString()));
            }
            catch (Exception notADouble) {
                try {
                    result = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected boolean upgradeProperty(String key, Object value) {
        return this.upgradeProperty(key, value, false);
    }

    protected boolean upgradeProperty(String key, Object value, boolean force) {
        value = this.convertProperty(value);
        Object currentValue = this.getEffectiveConfiguration().get(key);
        if (currentValue == value) {
            return false;
        }
        if (currentValue != null && value != null && !force) {
            if (currentValue.equals(value)) {
                return false;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                String stringCurrent = (String)currentValue;
                if (stringValue.equalsIgnoreCase(stringCurrent)) {
                    return false;
                }
            } else if (value instanceof Number) {
                float floatValue = NumberConversions.toFloat((Object)value);
                float floatCurrent = NumberConversions.toFloat((Object)currentValue);
                if (floatCurrent >= floatValue) {
                    return false;
                }
            }
        }
        this.sendDebug("Upgraded property: " + key);
        if (value != null && value instanceof Number) {
            this.sendAddMessage("upgraded_property", this.controller.getMessages().getLevelString("wand." + key, NumberConversions.toFloat((Object)value)));
        }
        this.sendMessage(key + "_usage");
        this.setProperty(key, value);
        return true;
    }

    protected void addPotionEffects(Map<PotionEffectType, Integer> effects, String effectsString) {
        String[] effectStrings;
        if (effectsString == null || effectsString.isEmpty()) {
            return;
        }
        effectsString = effectsString.replaceAll("[\\]\\[]", "");
        for (String effectString : effectStrings = StringUtils.split((String)effectsString, (char)',')) {
            try {
                PotionEffectType type;
                effectString = effectString.trim();
                int power = 0;
                if (effectString.contains(":")) {
                    String[] pieces = StringUtils.split((String)effectString, (char)':');
                    type = PotionEffectType.getByName((String)pieces[0].toUpperCase());
                    power = Integer.parseInt(pieces[1]);
                } else {
                    type = PotionEffectType.getByName((String)effectString.toUpperCase());
                }
                if (type == null) {
                    throw new Exception("Invalid potion effect");
                }
                Integer existing = effects.get(type);
                if (existing != null && existing >= power) continue;
                effects.put(type, power);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Invalid potion effect: " + effectString);
            }
        }
    }

    protected boolean upgradePotionEffects(String key, Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        boolean modified = false;
        String currentValue = this.getEffectiveConfiguration().getString(key);
        HashMap<PotionEffectType, Integer> currentEffects = new HashMap<PotionEffectType, Integer>();
        HashMap<PotionEffectType, Integer> newEffects = new HashMap<PotionEffectType, Integer>();
        this.addPotionEffects(currentEffects, currentValue);
        this.addPotionEffects(newEffects, (String)value);
        for (Map.Entry otherEffects : newEffects.entrySet()) {
            Integer current = (Integer)currentEffects.get(otherEffects.getKey());
            if (current != null && current >= (Integer)otherEffects.getValue()) continue;
            currentEffects.put((PotionEffectType)otherEffects.getKey(), (Integer)otherEffects.getValue());
            this.sendAddMessage("upgraded_property", this.describePotionEffect((PotionEffectType)otherEffects.getKey(), (Integer)otherEffects.getValue()));
            this.sendDebug("Added potion effect: " + otherEffects.getKey());
            modified = true;
        }
        if (modified) {
            this.setProperty("potion_effects", BaseMagicConfigurable.getPotionEffectString(currentEffects));
        }
        return modified;
    }

    protected boolean organizeInventory() {
        return false;
    }

    protected boolean alphabetizeInventory() {
        return false;
    }

    public boolean addBrush(String materialKey) {
        return false;
    }

    private boolean upgradeBrushes(Object value) {
        if (!(value instanceof String) && !(value instanceof List)) {
            return false;
        }
        boolean modified = false;
        List<String> materials = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        for (String materialKey : materials) {
            if (!this.addBrush(materialKey = StringUtils.split((String)materialKey, (char)'@')[0].trim())) continue;
            modified = true;
            this.sendDebug("Added brush: " + materialKey);
        }
        return modified;
    }

    public boolean addOverride(String key, String value) {
        return false;
    }

    private boolean upgradeOverrides(Object value) {
        boolean modified = false;
        List<String> overrides = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        HashSet<String> upgradedSpells = new HashSet<String>();
        for (String override : overrides) {
            String[] pairs = StringUtils.split((String)(override = override.replace("\\|", ",")), (char)' ');
            if (pairs.length <= 1 || !this.addOverride(pairs[0], pairs[1])) continue;
            this.sendDebug("Added override: " + pairs[0] + " " + pairs[1]);
            String[] pieces = StringUtils.split((String)pairs[0], (char)'.');
            if (pieces.length > 1 && !upgradedSpells.contains(pieces[0])) {
                upgradedSpells.add(pieces[0]);
                SpellTemplate spell = this.controller.getSpellTemplate(pieces[0]);
                if (spell != null) {
                    this.sendAddMessage("spell_override_upgraded", spell.getName());
                }
            }
            modified = true;
        }
        return modified;
    }

    public boolean addSpell(String spellKey) {
        return false;
    }

    private boolean upgradeSpells(Object value) {
        if (!(value instanceof String) && !(value instanceof List)) {
            return false;
        }
        boolean modified = false;
        List<String> spells = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        for (String spellKey : spells) {
            if (!this.addSpell(spellKey = StringUtils.split((String)spellKey, (char)'@')[0].trim())) continue;
            modified = true;
            this.sendDebug("Added spell: " + spellKey);
        }
        return modified;
    }

    @Override
    public void configure(@Nonnull ConfigurationSection configuration) {
        this.convertProperties(configuration);
        ConfigurationUtils.addConfigurations(this.configuration, configuration);
        this.dirty = true;
        this.updated();
    }

    @Override
    public boolean upgrade(ConfigurationSection configuration) {
        boolean modified = false;
        Set keys = configuration.getKeys(false);
        block25: for (String key : keys) {
            Object value = configuration.get(key);
            switch (key) {
                case "quiet": {
                    modified = this.upgradeProperty(key, value, true) || modified;
                    continue block25;
                }
                case "potion_effects": {
                    modified = this.upgradePotionEffects(key, value);
                    continue block25;
                }
                case "mana": 
                case "mana_regeneration": 
                case "mana_max": 
                case "mana_per_damage": {
                    double costReduction = this.getEffectiveConfiguration().getDouble("cost_reduction", 0.0);
                    if (!(costReduction <= 1.0)) continue block25;
                    modified = this.upgradeProperty(key, value) || modified;
                    continue block25;
                }
                case "effect_color": {
                    if (!(value instanceof String)) continue block25;
                    ColorHD newColor = new ColorHD((String)value);
                    modified = this.upgradeProperty(key, newColor.toString(), true) || modified;
                    continue block25;
                }
                case "organize": {
                    if (!this.organizeInventory()) continue block25;
                    modified = true;
                    this.sendMessage("reorganized");
                    continue block25;
                }
                case "alphabetize": {
                    if (!this.alphabetizeInventory()) continue block25;
                    modified = true;
                    this.sendMessage("alphabetized");
                    continue block25;
                }
                case "spells": {
                    modified = this.upgradeSpells(value) || modified;
                    continue block25;
                }
                case "materials": {
                    modified = this.upgradeBrushes(value) || modified;
                    continue block25;
                }
                case "overrides": {
                    modified = this.upgradeOverrides(value) || modified;
                    continue block25;
                }
            }
            modified = this.upgradeProperty(key, value) || modified;
        }
        boolean bl = this.dirty = this.dirty || modified;
        if (modified) {
            this.updated();
        }
        return modified;
    }

    protected void updated() {
    }

    @Override
    public boolean removeProperty(String key) {
        if (!this.hasOwnProperty(key)) {
            return false;
        }
        this.setProperty(key, null);
        this.updated();
        return true;
    }
}

