/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.batch.UndoBatch;
import com.elmakers.mine.bukkit.block.BlockComparator;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.block.UndoRegistry;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    public static int BLOCK_BREAK_RANGE = 64;
    public static Set<Material> attachables;
    public static Set<Material> attachablesWall;
    public static Set<Material> attachablesDouble;
    protected static final UndoRegistry registry;
    protected static BlockComparator blockComparator;
    protected Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> watching;
    private boolean loading = false;
    protected Set<Entity> entities;
    protected List<Runnable> runnables;
    protected HashMap<UUID, EntityData> modifiedEntities;
    protected WeakReference<CastContext> context;
    protected Mage owner;
    protected Plugin plugin;
    protected boolean undone = false;
    protected int timeToLive = 0;
    protected boolean applyPhysics = false;
    protected boolean bypass = false;
    protected boolean hasBeenScheduled = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected long scheduledTime;
    protected double speed = 0.0;
    protected Spell spell;
    protected Batch batch;
    protected UndoQueue undoQueue;
    protected UndoList next;
    protected UndoList previous;
    protected String name;
    private boolean consumed = false;
    private boolean undoEntityEffects = true;
    private Set<EntityType> undoEntityTypes = null;
    protected boolean undoBreakable = false;
    protected boolean undoReflective = false;
    protected boolean undoBreaking = false;

    public UndoList(Mage mage, String name) {
        this(mage);
        this.name = name;
    }

    public UndoList(Mage mage) {
        this.setMage(mage);
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public void setMage(Mage mage) {
        this.owner = mage;
        if (mage != null) {
            this.plugin = mage.getController().getPlugin();
        }
    }

    @Override
    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    @Override
    public void setSpell(Spell spell) {
        this.spell = spell;
        this.context = spell == null ? null : new WeakReference<CastContext>(spell.getCurrentCast());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockList != null && !this.blockList.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
        this.updateScheduledUndo();
    }

    @Override
    public void updateScheduledUndo() {
        if (this.timeToLive > 0) {
            this.scheduledTime = System.currentTimeMillis() + (long)this.timeToLive;
        }
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean hasChanges() {
        return this.size() > 0 || this.runnables != null && !this.runnables.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.undoEntityEffects && this.modifiedEntities != null && !this.modifiedEntities.isEmpty();
    }

    @Override
    public void clearAttachables(Block block) {
        this.clearAttachables(block, BlockFace.NORTH, attachablesWall);
        this.clearAttachables(block, BlockFace.SOUTH, attachablesWall);
        this.clearAttachables(block, BlockFace.EAST, attachablesWall);
        this.clearAttachables(block, BlockFace.WEST, attachablesWall);
        this.clearAttachables(block, BlockFace.UP, attachables);
        this.clearAttachables(block, BlockFace.DOWN, attachables);
    }

    protected boolean clearAttachables(Block block, BlockFace direction, Set<Material> materials) {
        if (materials == null) {
            return false;
        }
        Block testBlock = block.getRelative(direction);
        Long blockId = BlockData.getBlockId(testBlock);
        if (!materials.contains(testBlock.getType())) {
            return false;
        }
        if (this.blockIdMap != null && this.blockIdMap.contains(blockId)) {
            return false;
        }
        this.add(testBlock);
        MaterialAndData.clearItems(testBlock.getState());
        DeprecatedUtils.setTypeIdAndData(testBlock, DeprecatedUtils.getId(Material.AIR), (byte)0, false);
        return true;
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData attachedBlock;
        if (this.bypass) {
            return true;
        }
        if (!super.add(blockData)) {
            return false;
        }
        this.modifiedTime = System.currentTimeMillis();
        if (this.watching != null && (attachedBlock = this.watching.remove(blockData.getId())) != null) {
            UndoList.removeFromWatched(attachedBlock);
        }
        UndoList.register(blockData);
        blockData.setUndoList(this);
        if (this.loading) {
            return true;
        }
        this.addAttachable(blockData, BlockFace.NORTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.SOUTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.EAST, attachablesWall);
        this.addAttachable(blockData, BlockFace.WEST, attachablesWall);
        this.addAttachable(blockData, BlockFace.UP, attachables);
        this.addAttachable(blockData, BlockFace.DOWN, attachables);
        return true;
    }

    protected boolean addAttachable(com.elmakers.mine.bukkit.api.block.BlockData block, BlockFace direction, Set<Material> materials) {
        BlockData newBlock;
        Block testBlock = block.getBlock().getRelative(direction);
        Long blockId = BlockData.getBlockId(testBlock);
        if (this.blockIdMap != null && this.blockIdMap.contains(blockId)) {
            return false;
        }
        if (this.watching != null && this.watching.containsKey(blockId)) {
            return false;
        }
        Material material = testBlock.getType();
        if (materials != null && materials.contains(material) && this.contain(newBlock = new BlockData(testBlock))) {
            this.registerWatched(newBlock);
            newBlock.setUndoList(this);
            if (attachablesDouble != null && attachablesDouble.contains(material)) {
                if (direction != BlockFace.UP) {
                    this.addAttachable(newBlock, BlockFace.DOWN, materials);
                } else if (direction != BlockFace.DOWN) {
                    this.addAttachable(newBlock, BlockFace.UP, materials);
                }
            }
            return true;
        }
        return false;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData register(Block block) {
        BlockData blockData = new BlockData(block);
        registry.registerModified(blockData);
        return blockData;
    }

    public static void register(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        registry.registerModified(blockData);
    }

    public void registerWatched(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        registry.registerWatched(blockData);
        if (this.watching == null) {
            this.watching = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
        }
        this.watching.put(blockData.getId(), blockData);
    }

    @Override
    public void commit() {
        this.unlink();
        this.unregisterWatched();
        if (this.blockList == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockList) {
            UndoList.commit(block);
        }
        this.clear();
    }

    public static void commitAll() {
        registry.commitAll();
    }

    public static void commit(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.commit(block);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)o;
            UndoList.removeFromModified(block);
        }
        return super.remove(o);
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.removeFromModified(block);
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        registry.removeFromModified(block, priorState);
    }

    protected static void removeFromWatched(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.removeFromWatched(block);
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.BlockData undoNext(boolean applyPhysics) {
        if (this.blockList.size() == 0) {
            return null;
        }
        com.elmakers.mine.bukkit.api.block.BlockData blockData = (com.elmakers.mine.bukkit.api.block.BlockData)this.blockList.removeFirst();
        BlockState currentState = blockData.getBlock().getState();
        if (this.undo(blockData, applyPhysics)) {
            this.blockIdMap.remove(blockData.getId());
            if (this.consumed && currentState.getType() != Material.AIR && this.owner != null) {
                this.owner.giveItem(new ItemStack(currentState.getType(), 1, (short)DeprecatedUtils.getRawData(currentState)));
            }
            return blockData;
        }
        this.blockList.addFirst(blockData);
        return null;
    }

    private boolean undo(com.elmakers.mine.bukkit.api.block.BlockData undoBlock, boolean applyPhysics) {
        boolean isTopOfQueue;
        com.elmakers.mine.bukkit.api.block.BlockData priorState = undoBlock.getPriorState();
        if (this.undoBreakable) {
            registry.removeBreakable(undoBlock);
        }
        if (this.undoReflective) {
            registry.removeReflective(undoBlock);
        }
        boolean bl = isTopOfQueue = undoBlock.getNextState() == null;
        if (undoBlock.undo(applyPhysics)) {
            UndoList.removeFromModified(undoBlock, priorState);
            this.registerWatched(undoBlock);
            if (this.undoBreaking && isTopOfQueue && registry.removeBreaking(undoBlock) != null) {
                CompatibilityUtils.setBreaking(undoBlock.getBlock(), 10, BLOCK_BREAK_RANGE);
            }
            return true;
        }
        return false;
    }

    public void undoEntityEffects() {
        if (this.entities != null || this.modifiedEntities != null) {
            if (this.entities != null) {
                for (Entity entity : this.entities) {
                    if (entity == null) continue;
                    if (!entity.isValid()) {
                        if (!entity.getLocation().getChunk().isLoaded()) {
                            entity.getLocation().getChunk().load();
                        }
                        entity = NMSUtils.getEntity(entity.getWorld(), entity.getUniqueId());
                    }
                    if (entity == null || !entity.isValid()) continue;
                    entity.remove();
                }
                this.entities = null;
            }
            if (this.modifiedEntities != null) {
                for (EntityData data : this.modifiedEntities.values()) {
                    if (!this.undoEntityEffects && this.undoEntityTypes != null && !this.undoEntityTypes.contains(data.getType())) continue;
                    data.undo();
                }
                this.modifiedEntities = null;
            }
        }
    }

    @Override
    public void undo() {
        this.undo(false);
    }

    @Override
    public void undo(boolean blocking) {
        if (this.spell != null) {
            this.spell.cancel();
        }
        this.undo(blocking, true);
    }

    @Override
    public void undoScheduled(boolean blocking) {
        this.undo(blocking, false);
        if (this.isScheduled()) {
            this.owner.getController().cancelScheduledUndo(this);
        }
    }

    @Override
    public void undoScheduled() {
        this.undo(false, false);
    }

    public void unregisterWatched() {
        if (this.watching != null) {
            for (com.elmakers.mine.bukkit.api.block.BlockData block : this.watching.values()) {
                UndoList.removeFromWatched(block);
            }
            this.watching = null;
        }
    }

    public void undo(boolean blocking, boolean undoEntities) {
        if (this.undone) {
            return;
        }
        this.undone = true;
        if (this.batch != null && !this.batch.isFinished()) {
            this.batch.finish();
        }
        if (undoEntities) {
            this.speed = 0.0;
        }
        this.undoEntityEffects = this.undoEntityEffects || undoEntities;
        this.unlink();
        CastContext context = this.getContext();
        if (context != null) {
            context.cancelEffects();
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockList == null) {
            this.undoEntityEffects();
            return;
        }
        UndoBatch batch = new UndoBatch(this);
        if (blocking) {
            while (!batch.isFinished()) {
                batch.process(1000);
            }
        } else {
            this.owner.addUndoBatch(batch);
        }
    }

    @Override
    public void load(ConfigurationSection node) {
        this.loading = true;
        super.load(node);
        this.loading = false;
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.name = node.getString("name", this.name);
        this.applyPhysics = node.getBoolean("apply_physics", this.applyPhysics);
        this.consumed = node.getBoolean("consumed", this.consumed);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("name", (Object)this.name);
        if (this.applyPhysics) {
            node.set("apply_physics", (Object)true);
        }
        if (this.consumed) {
            node.set("consumed", (Object)true);
        }
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        entity.setMetadata("MagicBlockList", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this));
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities == null) {
            this.entities = new HashSet<Entity>();
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        this.entities.add(entity);
        if (this.isScheduled()) {
            entity.setMetadata("temporary", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
        this.watch(entity);
        this.contain(entity.getLocation().toVector());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.runnables == null) {
            this.runnables = new LinkedList<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public EntityData modify(Entity entity) {
        EntityData entityData = null;
        if (entity == null || entity.hasMetadata("notarget")) {
            return entityData;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return entityData;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        if (this.entities != null && this.entities.contains(entity) && !entity.isValid()) {
            this.entities.remove(entity);
        } else if (entity.isValid()) {
            UUID entityId;
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap();
            }
            if ((entityData = this.modifiedEntities.get(entityId = entity.getUniqueId())) == null) {
                entityData = new EntityData(entity);
                this.modifiedEntities.put(entityId, entityData);
                this.watch(entity);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
        return entityData;
    }

    @Override
    public EntityData damage(Entity entity) {
        EntityData data = this.modify(entity);
        if (this.undoEntityTypes != null && this.undoEntityTypes.contains(entity.getType())) {
            if (data != null) {
                data.removed(entity);
            }
            if (entity instanceof Hanging) {
                entity.remove();
            }
        }
        if (data != null) {
            data.setRespawn(true);
        }
        return data;
    }

    @Override
    public void move(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasMoved(true);
        }
    }

    @Override
    public void modifyVelocity(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasVelocity(true);
        }
    }

    @Override
    public void addPotionEffects(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasPotionEffects(true);
        }
    }

    @Override
    public void remove(Entity entity) {
        entity.removeMetadata("MagicBlockList", this.plugin);
        if (this.entities != null) {
            this.entities.remove(entity);
        }
        UUID entityId = entity.getUniqueId();
        if (this.modifiedEntities != null) {
            this.modifiedEntities.remove(entityId);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        this.remove(fallingBlock);
        this.add(block);
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        if (this.isScheduled() && fallingBlock instanceof FallingBlock) {
            ((FallingBlock)fallingBlock).setDropItem(false);
        }
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void finalizeExplosion(Entity explodingEntity, List<Block> blocks) {
        this.remove(explodingEntity);
        if (this.isScheduled()) {
            for (Block block : blocks) {
                BlockState state = block.getState();
                if (state instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)state;
                    holder.getInventory().clear();
                    state.update();
                }
                block.setType(Material.AIR);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        this.remove(explodingEntity);
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        if (location == null || this.area == null || this.worldName == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return this.area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockList == null) {
            return;
        }
        ArrayList current = new ArrayList(this.blockList);
        this.blockList = null;
        this.blockIdMap = null;
        for (com.elmakers.mine.bukkit.api.block.BlockData block : current) {
            if (block.isDifferent()) {
                super.add(block);
                continue;
            }
            UndoList.removeFromModified(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getOwner() {
        return this.owner;
    }

    @Override
    public CastContext getContext() {
        return this.context == null ? null : (CastContext)this.context.get();
    }

    @Override
    public long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public boolean isScheduled() {
        return this.timeToLive > 0;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.block.UndoList o) {
        return (int)(this.scheduledTime - o.getScheduledTime());
    }

    @Override
    public boolean hasBeenScheduled() {
        return this.hasBeenScheduled;
    }

    @Override
    public void setHasBeenScheduled() {
        this.hasBeenScheduled = true;
    }

    @Override
    public void setEntityUndo(boolean undoEntityEffects) {
        this.undoEntityEffects = undoEntityEffects;
    }

    @Override
    public void setEntityUndoTypes(Set<EntityType> undoTypes) {
        this.undoEntityTypes = undoTypes;
    }

    public void setNext(UndoList next) {
        this.next = next;
    }

    public void setPrevious(UndoList previous) {
        this.previous = previous;
    }

    public void setUndoQueue(com.elmakers.mine.bukkit.api.block.UndoQueue undoQueue) {
        if (undoQueue != null && undoQueue instanceof UndoQueue) {
            this.undoQueue = (UndoQueue)undoQueue;
        }
    }

    public boolean hasUndoQueue() {
        return this.undoQueue != null;
    }

    public void unlink() {
        if (this.undoQueue != null) {
            this.undoQueue.removed(this);
            this.undoQueue = null;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        this.previous = null;
        this.next = null;
    }

    public UndoList getNext() {
        return this.next;
    }

    public UndoList getPrevious() {
        return this.previous;
    }

    @Override
    public void setApplyPhysics(boolean applyPhysics) {
        this.applyPhysics = applyPhysics;
    }

    @Override
    public boolean getApplyPhysics() {
        return this.applyPhysics;
    }

    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity != null && entity.hasMetadata("MagicBlockList")) {
            List values = entity.getMetadata("MagicBlockList");
            for (MetadataValue metadataValue : values) {
                Object value = metadataValue.value();
                if (!(value instanceof com.elmakers.mine.bukkit.api.block.UndoList)) continue;
                blockList = (com.elmakers.mine.bukkit.api.block.UndoList)value;
            }
        }
        return blockList;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData getBlockData(Location location) {
        return registry.getBlockData(location);
    }

    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Location location) {
        com.elmakers.mine.bukkit.api.block.BlockData blockData = UndoList.getBlockData(location);
        return blockData == null ? null : blockData.getUndoList();
    }

    public static UndoRegistry getRegistry() {
        return registry;
    }

    @Override
    public void setUndoBreakable(boolean breakable) {
        this.undoBreakable = breakable;
    }

    @Override
    public void setUndoReflective(boolean reflective) {
        this.undoReflective = reflective;
    }

    @Override
    public void setUndoBreaking(boolean breaking) {
        this.undoBreaking = breaking;
    }

    @Override
    public Collection<Entity> getAllEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.entities != null) {
            for (Entity entity : this.entities) {
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        if (this.modifiedEntities != null) {
            for (EntityData entityData : this.modifiedEntities.values()) {
                Entity entity = entityData.getEntity();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public void sort(Set<Material> attachables) {
        if (this.blockList == null) {
            return;
        }
        Collections.reverse(this.blockList);
        if (attachables == null) {
            return;
        }
        blockComparator.setAttachables(attachables);
        Collections.sort(this.blockList, blockComparator);
    }

    public double getUndoSpeed() {
        return this.speed;
    }

    @Override
    public void setUndoSpeed(double speed) {
        this.speed = speed;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    static {
        registry = new UndoRegistry();
        blockComparator = new BlockComparator();
    }
}

