/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.UndoList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class UndoBatch
implements com.elmakers.mine.bukkit.api.batch.UndoBatch {
    protected final MageController controller;
    protected boolean finished = false;
    protected boolean applyPhysics = false;
    protected UndoList undoList;
    protected int listSize;
    protected int listProcessed;
    protected double partialWork = 0.0;
    private final Set<Material> attachables;

    public UndoBatch(UndoList blockList) {
        Set<Material> addToAttachables;
        Mage mage = blockList.getOwner();
        this.controller = mage.getController();
        this.undoList = blockList;
        this.applyPhysics = blockList.getApplyPhysics();
        this.attachables = new HashSet<Material>();
        CastContext context = this.undoList.getContext();
        if (context != null) {
            context.playEffects("undo");
        }
        if ((addToAttachables = this.controller.getMaterialSet("attachable")) != null) {
            this.attachables.addAll(addToAttachables);
        }
        if ((addToAttachables = this.controller.getMaterialSet("attachable_wall")) != null) {
            this.attachables.addAll(addToAttachables);
        }
        if ((addToAttachables = this.controller.getMaterialSet("attachable_double")) != null) {
            this.attachables.addAll(addToAttachables);
        }
        if ((addToAttachables = this.controller.getMaterialSet("delayed")) != null) {
            this.attachables.addAll(addToAttachables);
        }
        this.undoList.sort(this.attachables);
        this.listSize = this.undoList.size();
    }

    @Override
    public int size() {
        return this.listSize;
    }

    @Override
    public int remaining() {
        return this.undoList == null ? 0 : this.undoList.size();
    }

    @Override
    public int process(int maxBlocks) {
        BlockData undone;
        int processedBlocks = 0;
        double undoSpeed = this.undoList.getUndoSpeed();
        if (undoSpeed > 0.0 && this.listProcessed < this.listSize) {
            this.partialWork += undoSpeed;
            if (this.partialWork > 1.0) {
                maxBlocks = (int)Math.floor(this.partialWork);
                this.partialWork -= (double)maxBlocks;
            } else {
                return 0;
            }
        }
        while (this.undoList.size() > 0 && processedBlocks < maxBlocks && (undone = this.undoList.undoNext(this.applyPhysics)) != null) {
            ++processedBlocks;
            ++this.listProcessed;
        }
        if (this.undoList.size() == 0) {
            this.finish();
        }
        return processedBlocks;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            CastContext context;
            this.finished = true;
            this.undoList.unregisterWatched();
            this.undoList.undoEntityEffects();
            if (!this.undoList.isScheduled()) {
                this.controller.update(this.undoList);
            }
            if ((context = this.undoList.getContext()) != null) {
                context.playEffects("undo_finished");
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public String getName() {
        return "Undo " + this.undoList.getName();
    }
}

