/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.SpellBatch;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.spell.Spell;

public class ActionBatch
implements SpellBatch {
    private final int actionCount;
    private final CastContext context;
    private final ActionHandler handler;
    private boolean finished = false;

    public ActionBatch(CastContext context, ActionHandler handler) {
        UndoList undoList;
        this.context = context;
        this.handler = handler;
        this.actionCount = handler.getActionCount();
        if (handler.isUndoable() && (undoList = context.getUndoList()) != null) {
            undoList.setBatch(this);
        }
    }

    @Override
    public int process(int maxBlocks) {
        if (this.finished) {
            return 0;
        }
        Spell spell = this.context.getSpell();
        if (spell != null && spell.cancelOnNoPermission() && !this.context.canCast(this.context.getLocation())) {
            spell.cancel();
            this.finish();
            return 0;
        }
        this.context.setWorkAllowed(maxBlocks);
        this.handler.perform(this.context);
        if (this.handler.isFinished() && !this.context.hasHandlers()) {
            this.finish();
        }
        return maxBlocks - this.context.getWorkAllowed();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void finish() {
        if (!this.finished) {
            this.handler.cancel(this.context);
            this.handler.finish(this.context);
            this.context.finish();
            UndoList undoList = this.context.getUndoList();
            if (undoList != null) {
                undoList.setBatch(null);
            }
            this.finished = true;
        }
    }

    @Override
    public int size() {
        return this.actionCount;
    }

    @Override
    public int remaining() {
        return Math.max(0, this.actionCount - this.context.getActionsPerformed());
    }

    @Override
    public Spell getSpell() {
        return this.context.getSpell();
    }

    @Override
    public String getName() {
        Spell spell = this.getSpell();
        if (spell == null) {
            return "Unknown";
        }
        return spell.getName();
    }
}

