/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StashWandAction
extends BaseSpellAction {
    private ItemStack stashedItem;
    private Mage targetMage;
    private int slotNumber;
    private boolean returnOnFinish = true;

    private void returnItem() {
        if (this.targetMage == null || this.stashedItem == null) {
            return;
        }
        Player player = this.targetMage.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack existing = player.getInventory().getItem(this.slotNumber);
        if (existing == null || existing.getType() == Material.AIR) {
            player.getInventory().setItem(this.slotNumber, this.stashedItem);
        } else {
            this.targetMage.giveItem(this.stashedItem);
        }
        this.targetMage.checkWand();
        this.stashedItem = null;
        this.targetMage = null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            if (!context.getTargetsCaster()) {
                return SpellResult.NO_TARGET;
            }
            entity = context.getEntity();
        }
        if (entity == null || !(entity instanceof Player)) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)entity;
        MageController controller = context.getController();
        Mage mage = controller.getMage(player);
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            return SpellResult.FAIL;
        }
        Wand activeWand = mage.getActiveWand();
        if (activeWand != context.getWand()) {
            return SpellResult.NO_TARGET;
        }
        if (activeWand != null) {
            activeWand.deactivate();
        }
        this.slotNumber = player.getInventory().getHeldItemSlot();
        this.stashedItem = player.getInventory().getItemInMainHand();
        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        this.targetMage = mage;
        context.registerForUndo(new StashWandUndoAction());
        return SpellResult.CAST;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.returnOnFinish = parameters.getBoolean("return_on_finish", false);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("return_on_finish");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("return_on_finish")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        if (this.returnOnFinish) {
            this.returnItem();
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    private class StashWandUndoAction
    implements Runnable {
        @Override
        public void run() {
            StashWandAction.this.returnItem();
        }
    }
}

