/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.heroes.HeroesManager;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SkillSelectorAction
extends BaseSpellAction
implements GUIAction {
    private int page;
    private List<SkillDescription> allSkills = new ArrayList<SkillDescription>();
    private String inventoryTitle;
    private CastContext context;

    @Override
    public SpellResult perform(CastContext context) {
        this.context = context;
        MageController apiController = context.getController();
        Player player = context.getMage().getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (!(apiController instanceof MagicController)) {
            return SpellResult.FAIL;
        }
        MagicController controller = (MagicController)apiController;
        Messages messages = controller.getMessages();
        HeroesManager heroes = controller.getHeroes();
        this.allSkills.clear();
        if (controller.useHeroesSkills() && heroes != null) {
            String classString = heroes.getClassName(player);
            String class2String = heroes.getSecondaryClassName(player);
            String messageKey = !class2String.isEmpty() ? "skills.inventory_title_secondary" : "skills.inventory_title";
            this.inventoryTitle = controller.getMessages().get(messageKey, "Skills ($page/$pages)");
            this.inventoryTitle = this.inventoryTitle.replace("$class2", class2String).replace("$class", classString);
            List<String> heroesSkills = heroes.getSkillList(player, true, true);
            for (String heroesSkill : heroesSkills) {
                this.allSkills.add(new SkillDescription(heroes, controller, player, heroesSkill));
            }
        } else {
            this.inventoryTitle = messages.get("skills.inventory_title");
        }
        if (controller.usePermissionSkills()) {
            boolean bypassHidden = player.hasPermission("Magic.bypass_hidden");
            Collection<SpellTemplate> spells = controller.getSpellTemplates(bypassHidden);
            for (SpellTemplate spell : spells) {
                SpellKey key = spell.getSpellKey();
                if (key.isVariant() || key.getBaseKey().startsWith("heroes*") || !spell.hasCastPermission((CommandSender)player)) continue;
                this.allSkills.add(new SkillDescription(spell));
            }
        }
        if (this.allSkills.size() == 0) {
            player.sendMessage(messages.get("skills.none"));
            return SpellResult.NO_ACTION;
        }
        Collections.sort(this.allSkills);
        this.openInventory();
        return SpellResult.CAST;
    }

    public void setPage(int page) {
        this.page = page;
    }

    protected void openInventory() {
        MageController apiController = this.context.getController();
        if (!(apiController instanceof MagicController)) {
            return;
        }
        MagicController controller = (MagicController)apiController;
        HeroesManager heroes = controller.getHeroes();
        int inventorySize = 9 * controller.getSkillInventoryRows();
        int numPages = (int)Math.ceil((float)this.allSkills.size() / (float)inventorySize);
        if (this.page < 1) {
            this.page = numPages;
        } else if (this.page > numPages) {
            this.page = 1;
        }
        Mage mage = this.context.getMage();
        Player player = mage.getPlayer();
        int pageIndex = this.page - 1;
        int startIndex = pageIndex * inventorySize;
        int maxIndex = (pageIndex + 1) * inventorySize - 1;
        ArrayList<SkillDescription> skills = new ArrayList<SkillDescription>();
        for (int i = startIndex; i <= maxIndex && i < this.allSkills.size(); ++i) {
            skills.add(this.allSkills.get(i));
        }
        if (skills.size() == 0) {
            String messageTemplate = controller.getMessages().get("skills.none_on_page", "$page");
            player.sendMessage(messageTemplate.replace("$page", Integer.toString(this.page)));
            return;
        }
        int invSize = (int)Math.ceil((float)skills.size() / 9.0f) * 9;
        String title = this.inventoryTitle;
        title = title.replace("$pages", Integer.toString(numPages)).replace("$page", Integer.toString(this.page));
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, title);
        for (SkillDescription skill : skills) {
            ItemStack skillItem = controller.getAPI().createItem(skill.getSkillKey(), mage);
            if (skillItem == null) continue;
            if (skill.isHeroes() && heroes != null && !heroes.canUseSkill(player, skill.heroesSkill)) {
                String nameTemplate = controller.getMessages().get("skills.item_name_unavailable", "$skill");
                String spellName = skill.spell != null ? skill.spell.getName() : skill.heroesSkill;
                CompatibilityUtils.setDisplayName(skillItem, nameTemplate.replace("$skill", spellName));
                InventoryUtils.setMetaBoolean(skillItem, "unavailable", true);
                if (skill.spell != null) {
                    MaterialAndData disabledIcon = skill.spell.getDisabledIcon();
                    if (disabledIcon != null) {
                        disabledIcon.applyToItem(skillItem);
                    } else {
                        String disabledIconURL = skill.spell.getDisabledIconURL();
                        if (disabledIconURL != null && !disabledIconURL.isEmpty()) {
                            InventoryUtils.setNewSkullURL(skillItem, disabledIconURL);
                        }
                    }
                }
            }
            displayInventory.addItem(new ItemStack[]{skillItem});
        }
        mage.deactivateGUI();
        mage.activateGUI(this, displayInventory);
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING) {
            int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
            this.page += direction;
            this.openInventory();
            event.setCancelled(true);
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && InventoryUtils.getMetaBoolean(clickedItem, "unavailable", false)) {
            event.setCancelled(true);
            return;
        }
        Mage mage = this.context.getMage();
        if (action == InventoryAction.PICKUP_HALF && mage != null) {
            MageSpell spell = mage.getSpell(Wand.getSpell(clickedItem));
            if (spell != null) {
                spell.cast();
            }
            mage.getPlayer().closeInventory();
            event.setCancelled(true);
        }
    }

    @Override
    public void dragged(InventoryDragEvent event) {
    }

    class SkillDescription
    implements Comparable<SkillDescription> {
        public String heroesSkill;
        public SpellTemplate spell;
        private int skillLevel = 0;

        public SkillDescription(SpellTemplate spell) {
            this.spell = spell;
        }

        public SkillDescription(HeroesManager heroes, MageController controller, Player player, String heroesSkill) {
            this.heroesSkill = heroesSkill;
            this.spell = controller.getSpellTemplate(this.getSpellKey());
            this.skillLevel = heroes.getSkillLevel(player, heroesSkill);
        }

        public String getSkillKey() {
            String key = this.getSpellKey();
            if (key != null) {
                key = "skill:" + key;
            }
            return key;
        }

        public String getSpellKey() {
            if (this.heroesSkill != null) {
                return "heroes*" + this.heroesSkill;
            }
            if (this.spell != null) {
                return this.spell.getKey();
            }
            return null;
        }

        public String getSpellName() {
            if (this.spell != null) {
                return this.spell.getName();
            }
            return this.heroesSkill;
        }

        public boolean isHeroes() {
            return this.heroesSkill != null;
        }

        @Override
        public int compareTo(SkillDescription other) {
            if (this.heroesSkill != null && this.skillLevel != other.skillLevel) {
                return Integer.compare(this.skillLevel, other.skillLevel);
            }
            return this.getSpellName().compareTo(other.getSpellName());
        }
    }
}

