/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import org.bukkit.configuration.ConfigurationSection;

public class CheckManaAction
extends CompoundAction {
    private boolean requireNotFull = false;
    private boolean requireEmpty = false;
    private double requireAmount = 0.0;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.requireAmount = parameters.getDouble("require_mana", 0.0);
        this.requireNotFull = parameters.getBoolean("require_mana_not_full", false);
        this.requireEmpty = parameters.getBoolean("require_mana_empty", false);
    }

    protected boolean isAllowed(CastContext context) {
        Wand wand = context.getWand();
        if (wand == null) {
            return false;
        }
        double currentMana = wand.getMana();
        if (this.requireAmount > 0.0 && currentMana < this.requireAmount) {
            return false;
        }
        if (this.requireEmpty && currentMana > 0.0) {
            return false;
        }
        int manaMax = wand.getManaMax();
        return !this.requireNotFull || !(currentMana >= (double)manaMax);
    }

    @Override
    public SpellResult step(CastContext context) {
        boolean allowed = this.isAllowed(context);
        ActionHandler actions = this.getHandler("actions");
        if (actions == null || actions.size() == 0) {
            return allowed ? SpellResult.CAST : SpellResult.STOP;
        }
        if (!allowed) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }

    @Override
    public boolean requiresTarget() {
        return false;
    }
}

