/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.EntityProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.slikey.effectlib.math.VectorTransform;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStandProjectileAction
extends EntityProjectileAction {
    private boolean smallArmorStand = false;
    private boolean armorStandMarker = false;
    private boolean armorStandInvisible = false;
    private boolean armorStandGravity = false;
    private boolean adjustArmPitch = false;
    private boolean adjustHeadPitch = false;
    private boolean showArmorStandArms = true;
    private boolean showArmorStandBaseplate = false;
    private boolean unbreakableItems = false;
    private ItemStack rightArmItem = null;
    private ItemStack helmetItem = null;
    private ItemStack chestplateItem = null;
    private ItemStack leggingsItem = null;
    private ItemStack bootsItem = null;
    private VectorTransform leftArmTransform;
    private VectorTransform rightArmTransform;
    private VectorTransform leftLegTransform;
    private VectorTransform rightLegTransform;
    private VectorTransform bodyTransform;
    private VectorTransform headTransform;
    private int visibleDelayTicks = 1;
    private int stepCount = 0;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.isConfigurationSection("left_arm_transform")) {
            this.leftArmTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_arm_transform"));
        }
        if (parameters.isConfigurationSection("right_arm_transform")) {
            this.rightArmTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_arm_transform"));
        }
        if (parameters.isConfigurationSection("right_leg_transform")) {
            this.rightLegTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_leg_transform"));
        }
        if (parameters.isConfigurationSection("left_leg_transform")) {
            this.leftLegTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "left_leg_transform"));
        }
        if (parameters.isConfigurationSection("head_transform")) {
            this.headTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "head_transform"));
        }
        if (parameters.isConfigurationSection("body_transform")) {
            this.bodyTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "body_transform"));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.armorStandMarker = parameters.getBoolean("armor_stand_marker", true);
        this.armorStandInvisible = parameters.getBoolean("armor_stand_invisible", true);
        this.armorStandGravity = parameters.getBoolean("armor_stand_gravity", false);
        this.showArmorStandArms = parameters.getBoolean("armor_stand_arms", true);
        this.showArmorStandBaseplate = parameters.getBoolean("armor_stand_baseplate", false);
        this.smallArmorStand = parameters.getBoolean("armor_stand_small", false);
        this.adjustHeadPitch = parameters.getBoolean("orient_head", false);
        this.adjustArmPitch = parameters.getBoolean("orient_right_arm", false);
        this.unbreakableItems = parameters.getBoolean("unbreakable_items", false);
        this.visibleDelayTicks = parameters.getInt("visible_delay_ticks", 1);
        MageController controller = context.getController();
        ItemData itemType = controller.getOrCreateItem(parameters.getString("right_arm_item"));
        if (itemType != null) {
            this.rightArmItem = itemType.getItemStack(1);
            if (this.rightArmItem != null && this.unbreakableItems) {
                InventoryUtils.makeUnbreakable(this.rightArmItem);
            }
        }
        if ((itemType = controller.getOrCreateItem(parameters.getString("helmet_item"))) != null) {
            this.helmetItem = itemType.getItemStack(1);
            if (this.helmetItem != null && this.unbreakableItems) {
                InventoryUtils.makeUnbreakable(InventoryUtils.makeReal(this.helmetItem));
            }
        }
        if ((itemType = controller.getOrCreateItem(parameters.getString("chestplate_item"))) != null) {
            this.chestplateItem = itemType.getItemStack(1);
            if (this.chestplateItem != null && this.unbreakableItems) {
                InventoryUtils.makeUnbreakable(InventoryUtils.makeReal(this.chestplateItem));
            }
        }
        if ((itemType = controller.getOrCreateItem(parameters.getString("leggings_item"))) != null) {
            this.leggingsItem = itemType.getItemStack(1);
            if (this.leggingsItem != null && this.unbreakableItems) {
                InventoryUtils.makeUnbreakable(InventoryUtils.makeReal(this.leggingsItem));
            }
        }
        if ((itemType = controller.getOrCreateItem(parameters.getString("boots_item"))) != null) {
            this.bootsItem = itemType.getItemStack(1);
            if (this.bootsItem != null && this.unbreakableItems) {
                InventoryUtils.makeUnbreakable(InventoryUtils.makeReal(this.bootsItem));
            }
        }
    }

    @Override
    public SpellResult start(CastContext context) {
        MageController controller = context.getController();
        Location location = this.adjustLocation(this.sourceLocation.getLocation(context));
        ArmorStand armorStand = (ArmorStand)this.setEntity(controller, (Entity)CompatibilityUtils.spawnArmorStand(location));
        armorStand.setMarker(this.armorStandMarker);
        armorStand.setVisible(!this.armorStandInvisible);
        armorStand.setBasePlate(this.showArmorStandBaseplate);
        armorStand.setGravity(this.armorStandGravity);
        armorStand.setSmall(this.smallArmorStand);
        armorStand.setArms(this.showArmorStandArms);
        CompatibilityUtils.setSilent((Entity)armorStand, true);
        CompatibilityUtils.setDisabledSlots(armorStand, 0x1F1F00);
        this.update(armorStand);
        CompatibilityUtils.addToWorld(location.getWorld(), (Entity)armorStand, this.spawnReason);
        return super.start(context);
    }

    protected void update(ArmorStand armorStand) {
        double pitchOffset;
        Vector direction;
        double t = (double)this.flightTime / 1000.0;
        Location currentLocation = armorStand.getLocation();
        if (this.leftArmTransform != null) {
            direction = this.leftArmTransform.get(this.launchLocation, t);
            armorStand.setLeftArmPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.rightArmTransform != null) {
            direction = this.rightArmTransform.get(this.launchLocation, t);
            pitchOffset = this.adjustArmPitch ? Math.toRadians(currentLocation.getPitch()) : 0.0;
            armorStand.setRightArmPose(new EulerAngle(direction.getX(), direction.getY() + pitchOffset, direction.getZ()));
        } else if (this.adjustArmPitch) {
            EulerAngle armPose = armorStand.getRightArmPose();
            armPose = armPose.setY(Math.toRadians(-currentLocation.getPitch()));
            armorStand.setRightArmPose(armPose);
        }
        if (this.leftLegTransform != null) {
            direction = this.leftLegTransform.get(this.launchLocation, t);
            armorStand.setLeftLegPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.rightLegTransform != null) {
            direction = this.rightLegTransform.get(this.launchLocation, t);
            armorStand.setRightLegPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.bodyTransform != null) {
            direction = this.bodyTransform.get(this.launchLocation, t);
            armorStand.setBodyPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.headTransform != null) {
            direction = this.headTransform.get(this.launchLocation, t);
            pitchOffset = this.adjustHeadPitch ? Math.toRadians(currentLocation.getPitch()) : 0.0;
            armorStand.setHeadPose(new EulerAngle(direction.getX(), direction.getY() + pitchOffset, direction.getZ()));
        } else if (this.adjustHeadPitch) {
            EulerAngle headPose = armorStand.getHeadPose();
            headPose = headPose.setX(Math.toRadians(currentLocation.getPitch()));
            armorStand.setHeadPose(headPose);
        }
    }

    @Override
    public SpellResult step(CastContext context) {
        SpellResult result = super.step(context);
        if (this.entity == null) {
            return SpellResult.FAIL;
        }
        ArmorStand armorStand = (ArmorStand)this.entity;
        this.update(armorStand);
        if (this.stepCount == this.visibleDelayTicks) {
            armorStand.setItemInHand(this.rightArmItem);
            armorStand.setHelmet(this.helmetItem);
            armorStand.setChestplate(this.chestplateItem);
            armorStand.setLeggings(this.leggingsItem);
            armorStand.setBoots(this.bootsItem);
        }
        ++this.stepCount;
        return result;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.stepCount = 0;
    }
}

