/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

@Deprecated
public class TreeSpell
extends TargetingSpell {
    private TreeType lastTreeType = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean result;
        Block target = this.getTargetBlock();
        this.lastTreeType = null;
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        boolean requireSapling = parameters.getBoolean("require_sapling", false);
        if (requireSapling && target.getType() != Material.SAPLING) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location treeLoc = new Location(this.getWorld(), (double)target.getX(), (double)(target.getY() + 1), (double)target.getZ(), 0.0f, 0.0f);
        String typeString = parameters.getString("type", "");
        TreeType treeType = TreeSpell.parseTreeString(typeString, null);
        if (treeType == null) {
            treeType = TreeType.values()[(int)(Math.random() * (double)TreeType.values().length)];
        }
        if (result = this.getWorld().generateTree(treeLoc, treeType)) {
            this.controller.updateBlock(target);
            this.lastTreeType = treeType;
        }
        return result ? SpellResult.CAST : SpellResult.FAIL;
    }

    public String getTreeName(TreeType treeType) {
        if (treeType == null || treeType.name() == null) {
            return "Tree";
        }
        return treeType.name().toLowerCase();
    }

    public static TreeType parseTreeString(String s, TreeType defaultTreeType) {
        if (s.equalsIgnoreCase("big")) {
            return TreeType.BIG_TREE;
        }
        if (s.equalsIgnoreCase("tall")) {
            return TreeType.TALL_REDWOOD;
        }
        TreeType tree = defaultTreeType;
        for (TreeType t : TreeType.values()) {
            if (!t.name().equalsIgnoreCase(s)) continue;
            tree = t;
        }
        return tree;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        return message.replace("$tree", this.getTreeName(this.lastTreeType));
    }
}

