/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.MaterialBrush;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public abstract class TargetingSpell
extends BaseSpell {
    private static final int MAX_RANGE = 511;
    private Targeting targeting = new Targeting();
    private Location targetLocation = null;
    protected Location targetLocation2 = null;
    private Entity targetEntity = null;
    private boolean targetNPCs = false;
    private boolean targetArmorStands = false;
    private boolean targetInvisible = true;
    private boolean targetVanished = false;
    private boolean targetUnknown = true;
    protected Class<?> targetEntityType = null;
    protected Set<EntityType> targetEntityTypes = null;
    protected Material targetContents = null;
    protected double targetBreakables = 0.0;
    protected boolean instantBlockEffects = false;
    private double range = 0.0;
    private boolean checkProtection = false;
    private int damageResistanceProtection = 0;
    private boolean allowMaxRange = false;
    private boolean bypassBackfire = false;
    private Set<Material> targetThroughMaterials = new HashSet<Material>();
    private Set<Material> targetableMaterials = null;
    private Set<Material> reflectiveMaterials = null;
    private boolean reverseTargeting = false;
    private boolean originAtTarget = false;

    protected void initializeTargeting() {
        this.targeting.reset();
        this.reverseTargeting = false;
        this.targetLocation = null;
        this.targetLocation2 = null;
    }

    @Override
    public String getMessage(String messageKey, String def) {
        Target target;
        String message = super.getMessage(messageKey, def);
        String useTargetName = null;
        if (this.currentCast != null) {
            useTargetName = this.currentCast.getTargetName();
        }
        if (useTargetName == null && (target = this.targeting.getTarget()) != null) {
            com.elmakers.mine.bukkit.block.MaterialAndData material;
            if (target.hasEntity() && this.getTargetType() != TargetType.BLOCK) {
                useTargetName = this.controller.getEntityDisplayName(target.getEntity());
            } else if (target.isValid() && this.getTargetType() != TargetType.OTHER_ENTITY && this.getTargetType() != TargetType.ANY_ENTITY && (material = target.getTargetedMaterial()) != null) {
                useTargetName = material.getName();
            }
        }
        message = useTargetName == null ? message.replace("$target", "Nothing") : message.replace("$target", useTargetName);
        return message;
    }

    public boolean isReflective(Material mat) {
        return this.reflectiveMaterials != null && this.reflectiveMaterials.contains(mat);
    }

    public boolean isTargetable(CastContext context, Block block) {
        if (this.targetBreakables > 0.0 && context.isBreakable(block)) {
            return true;
        }
        if (!this.bypassBackfire && context.isReflective(block)) {
            return true;
        }
        return this.isTargetable(block.getType());
    }

    public boolean isTargetable(Material mat) {
        if (!this.allowPassThrough(mat)) {
            return true;
        }
        boolean targetThrough = this.targetThroughMaterials.contains(mat);
        if (this.reverseTargeting) {
            return targetThrough;
        }
        if (!targetThrough && this.targetableMaterials != null) {
            return this.targetableMaterials.contains(mat);
        }
        return !targetThrough;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public void setTargetSpaceRequired() {
        this.targeting.setTargetSpaceRequired(true);
    }

    public void setTargetMinOffset(int offset) {
        this.targeting.setTargetMinOffset(offset);
    }

    public void setTarget(Location location) {
        this.targeting.targetBlock(this.getEyeLocation(), location == null ? null : location.getBlock());
    }

    public void setTargetingHeight(int offset) {
        this.targeting.setYOffset(offset);
    }

    public TargetType getTargetType() {
        return this.targeting.getTargetType();
    }

    public Block getPreviousBlock() {
        return this.targeting.getPreviousBlock();
    }

    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox, int yOffset, boolean targetSpaceRequired, int targetMinOffset) {
        this.initializeTargeting();
        this.range = range;
        this.targeting.setYOffset(yOffset);
        this.targeting.setTargetSpaceRequired(targetSpaceRequired);
        this.targeting.setTargetMinOffset(targetMinOffset);
        this.targeting.setFOV(fov);
        this.targeting.setCloseRange(closeFOV);
        this.targeting.setCloseFOV(closeRange);
        this.targeting.setUseHitbox(useHitbox);
        this.target();
    }

    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        this.initializeTargeting();
        this.range = range;
        this.targeting.setFOV(fov);
        this.targeting.setCloseRange(closeFOV);
        this.targeting.setCloseFOV(closeRange);
        this.targeting.setUseHitbox(useHitbox);
        this.target();
    }

    @Override
    public void target() {
        if (!this.targeting.hasTarget()) {
            this.getTarget();
        }
    }

    protected Target processBlockEffects() {
        Target target;
        Target originalTarget = target = this.targeting.getTarget();
        Block block = target.getBlock();
        Double backfireAmount = this.currentCast.getReflective(block);
        if (backfireAmount != null && random.nextDouble() < backfireAmount) {
            final Entity mageEntity = this.mage.getEntity();
            final Location location = this.getLocation();
            final Location originLocation = block.getLocation();
            Vector direction = location.getDirection();
            originLocation.setDirection(direction.multiply(-1));
            this.location = originLocation;
            this.backfire();
            final Collection<EffectPlayer> effects = this.getEffects("cast");
            if (effects.size() > 0) {
                Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        for (EffectPlayer player : effects) {
                            player.setMaterial(TargetingSpell.this.getEffectMaterial());
                            player.setColor(TargetingSpell.this.mage.getEffectColor());
                            player.start(originLocation, null, location, mageEntity);
                        }
                    }
                }, 5L);
            }
            target = new Target(this.getEyeLocation(), mageEntity);
        }
        if (this.targetBreakables > 0.0 && originalTarget.isValid() && block != null && this.currentCast.isBreakable(block)) {
            this.targeting.breakBlock(this.currentCast, block, this.targetBreakables);
        }
        return target;
    }

    protected Target findTarget() {
        boolean isBlock;
        Location source = this.getEyeLocation();
        TargetType targetType = this.targeting.getTargetType();
        boolean bl = isBlock = targetType == TargetType.BLOCK || targetType == TargetType.SELECT;
        if (!isBlock && this.targetEntity != null) {
            return this.targeting.overrideTarget(this.currentCast, new Target(source, this.targetEntity));
        }
        if (targetType != TargetType.SELF && this.targetLocation != null) {
            return this.targeting.overrideTarget(this.currentCast, new Target(source, this.targetLocation.getBlock()));
        }
        Target target = this.targeting.target(this.currentCast, this.getMaxRange());
        return this.targeting.getResult() == Targeting.TargetingResult.MISS && !this.allowMaxRange ? new Target(source) : target;
    }

    protected Target getTarget() {
        Target target = this.findTarget();
        if (this.instantBlockEffects) {
            target = this.processBlockEffects();
        }
        if (this.originAtTarget && target.isValid()) {
            Location previous = this.location;
            if (previous == null && this.mage != null) {
                previous = this.mage.getLocation();
            }
            this.location = target.getLocation().clone();
            if (previous != null) {
                this.location.setPitch(previous.getPitch());
                this.location.setYaw(previous.getYaw());
            }
        }
        if (this.currentCast != null) {
            Entity targetEntity = target != null ? target.getEntity() : null;
            Location targetLocation = target != null ? target.getLocation() : null;
            this.currentCast.setTargetLocation(targetLocation);
            this.currentCast.setTargetEntity(targetEntity);
        }
        return target;
    }

    public Target getCurrentTarget() {
        return this.targeting.getOrCreateTarget(this.getEyeLocation());
    }

    public Block getTargetBlock() {
        return this.getTarget().getBlock();
    }

    public List<Target> getAllTargetEntities() {
        this.targeting.start(this.currentCast.getEyeLocation());
        return this.targeting.getAllTargetEntities(this.currentCast, this.getMaxRange());
    }

    @Override
    public boolean canTarget(Entity entity) {
        ItemFrame itemFrame;
        ItemStack item;
        LivingEntity living;
        if (!this.targetUnknown && entity.getType() == EntityType.UNKNOWN) {
            return false;
        }
        if (entity.hasMetadata("notarget")) {
            return false;
        }
        if (!this.targetNPCs && this.controller.isNPC(entity)) {
            return false;
        }
        if (!this.targetArmorStands && entity instanceof ArmorStand) {
            return false;
        }
        if (this.damageResistanceProtection > 0 && entity instanceof LivingEntity && (living = (LivingEntity)entity).hasPotionEffect(PotionEffectType.DAMAGE_RESISTANCE)) {
            Collection effects = living.getActivePotionEffects();
            for (PotionEffect effect : effects) {
                if (!effect.getType().equals((Object)PotionEffectType.DAMAGE_RESISTANCE) || effect.getAmplifier() < this.damageResistanceProtection) continue;
                return false;
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.checkProtection && player.hasPermission("Magic.protected." + this.getKey())) {
                return false;
            }
            if (this.controller.isMage(entity) && this.isSuperProtected(this.controller.getMage(entity))) {
                return false;
            }
        }
        if (!this.targetInvisible && entity instanceof LivingEntity && ((LivingEntity)entity).hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return false;
        }
        if (!this.targetVanished && entity instanceof Player && this.controller.isVanished(entity)) {
            return false;
        }
        if (this.targetContents != null && entity instanceof ItemFrame && ((item = (itemFrame = (ItemFrame)entity).getItem()) == null || item.getType() != this.targetContents)) {
            return false;
        }
        if (this.targetEntityType == null && this.targetEntityTypes == null) {
            return super.canTarget(entity);
        }
        if (this.targetEntityTypes != null) {
            return this.targetEntityTypes.contains(entity.getType()) && super.canTarget(entity);
        }
        return this.targetEntityType.isAssignableFrom(entity.getClass()) && super.canTarget(entity);
    }

    public boolean isSuperProtected(Mage mage) {
        return !this.bypassProtection && mage.isSuperProtected();
    }

    protected double getMaxRange() {
        if (this.allowMaxRange) {
            return Math.min(511.0, this.range);
        }
        float multiplier = this.mage == null ? 1.0f : this.mage.getRangeMultiplier();
        return Math.min(511.0, (double)multiplier * this.range);
    }

    @Override
    public double getRange() {
        TargetType targetType = this.targeting.getTargetType();
        if (targetType == TargetType.NONE || targetType == TargetType.SELF) {
            return 0.0;
        }
        return this.getMaxRange();
    }

    protected double getMaxRangeSquared() {
        double maxRange = this.getMaxRange();
        return maxRange * maxRange;
    }

    protected void setMaxRange(double range) {
        this.range = range;
    }

    public boolean isTransparent(Material material) {
        return this.targetThroughMaterials.contains(material);
    }

    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock.getType())) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    public Block findBlockUnder(Block block) {
        int depth = 0;
        if (this.targetThroughMaterials.contains(block.getType())) {
            while (depth < this.verticalSearchDistance && this.targetThroughMaterials.contains(block.getType())) {
                ++depth;
                block = block.getRelative(BlockFace.DOWN);
            }
        } else {
            while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains(block.getType())) {
                ++depth;
                block = block.getRelative(BlockFace.UP);
            }
            block = block.getRelative(BlockFace.DOWN);
        }
        return block;
    }

    public Block findSpaceAbove(Block block) {
        int depth = 0;
        while (depth < this.verticalSearchDistance && !this.targetThroughMaterials.contains(block.getType())) {
            ++depth;
            block = block.getRelative(BlockFace.UP);
        }
        return block;
    }

    @Override
    protected void reset() {
        super.reset();
        this.initializeTargeting();
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        if (parameters != null) {
            this.processTemplateParameters(parameters);
        }
    }

    protected void processTemplateParameters(ConfigurationSection parameters) {
        TargetType targetType;
        this.range = parameters.getDouble("range", 0.0);
        boolean hasTargeting = parameters.contains("target");
        this.targeting.parseTargetType(parameters.getString("target"));
        if (this.range > 0.0 && !hasTargeting) {
            this.targeting.setTargetType(TargetType.OTHER);
        }
        if ((targetType = this.targeting.getTargetType()) != TargetType.NONE && targetType != TargetType.SELF && this.range == 0.0) {
            this.range = 32.0;
        }
        this.targetSelf = targetType == TargetType.SELF;
        this.targetSelf = parameters.getBoolean("target_self", this.targetSelf);
    }

    @Override
    public void processParameters(ConfigurationSection parameters) {
        String reflectiveKey;
        super.processParameters(parameters);
        this.targeting.processParameters(parameters);
        this.processTemplateParameters(parameters);
        this.allowMaxRange = parameters.getBoolean("allow_max_range", false);
        this.bypassBackfire = parameters.getBoolean("bypass_backfire", false);
        this.checkProtection = parameters.getBoolean("check_protection", false);
        this.damageResistanceProtection = parameters.getInt("damage_resistance_protection", 0);
        this.targetBreakables = parameters.getDouble("target_breakables", 1.0);
        this.reverseTargeting = parameters.getBoolean("reverse_targeting", false);
        this.instantBlockEffects = parameters.getBoolean("instant_block_effects", false);
        if (parameters.contains("transparent")) {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet(parameters.getString("transparent")));
        } else {
            this.targetThroughMaterials.clear();
            this.targetThroughMaterials.addAll(this.controller.getMaterialSet("transparent"));
        }
        if (parameters.contains("targetable")) {
            this.targetableMaterials = new HashSet<Material>();
            this.targetableMaterials.addAll(this.controller.getMaterialSet(parameters.getString("targetable")));
        } else {
            this.targetableMaterials = null;
        }
        this.reflectiveMaterials = null;
        if (parameters.contains("reflective")) {
            this.reflectiveMaterials = this.controller.getMaterialSet(parameters.getString("reflective"));
        }
        if (parameters.getBoolean("reflective_override", true) && (reflectiveKey = this.controller.getReflectiveMaterials(this.mage, this.mage.getLocation())) != null) {
            Set<Material> currentReflective = this.reflectiveMaterials;
            this.reflectiveMaterials = this.controller.getMaterialSet(reflectiveKey);
            if (currentReflective != null) {
                this.reflectiveMaterials = new HashSet<Material>(this.reflectiveMaterials);
                this.reflectiveMaterials.addAll(currentReflective);
            }
        }
        this.targetNPCs = parameters.getBoolean("target_npc", false);
        this.targetArmorStands = parameters.getBoolean("target_armor_stand", false);
        this.targetInvisible = parameters.getBoolean("target_invisible", true);
        this.targetVanished = parameters.getBoolean("target_vanished", false);
        this.targetUnknown = parameters.getBoolean("target_unknown", true);
        if (parameters.contains("target_type")) {
            String entityTypeName = parameters.getString("target_type");
            try {
                this.targetEntityType = Class.forName("org.bukkit.entity." + entityTypeName);
            }
            catch (Throwable ex) {
                this.controller.getLogger().warning("Unknown entity type in target_type of " + this.getKey() + ": " + entityTypeName);
                this.targetEntityType = null;
            }
        } else if (parameters.contains("target_types")) {
            this.targetEntityType = null;
            this.targetEntityTypes = new HashSet<EntityType>();
            List<String> typeKeys = ConfigurationUtils.getStringList(parameters, "target_types");
            for (String typeKey : typeKeys) {
                try {
                    EntityType entityType = EntityType.valueOf((String)typeKey.toUpperCase());
                    this.targetEntityTypes.add(entityType);
                }
                catch (Throwable ex) {
                    this.controller.getLogger().warning("Unknown entity type in target_types of " + this.getKey() + ": " + typeKey);
                }
            }
        } else {
            this.targetEntityType = null;
            this.targetEntityTypes = null;
        }
        this.targetContents = ConfigurationUtils.getMaterial(parameters, "target_contents", null);
        this.originAtTarget = parameters.getBoolean("origin_at_target", false);
        Location defaultLocation = this.getLocation();
        this.targetLocation = ConfigurationUtils.overrideLocation(parameters, "t", defaultLocation, this.controller.canCreateWorlds());
        defaultLocation = this.targetLocation == null ? defaultLocation : this.targetLocation;
        this.targetLocation2 = ConfigurationUtils.overrideLocation(parameters, "t2", defaultLocation, this.controller.canCreateWorlds());
        if (parameters.contains("player")) {
            Player player = DeprecatedUtils.getPlayer(parameters.getString("player"));
            if (player != null) {
                this.targetLocation = player.getLocation();
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        boolean targetUnderwater = parameters.getBoolean("target_underwater", true);
        if (targetUnderwater && this.isUnderwater()) {
            this.targetThroughMaterials.add(Material.WATER);
            this.targetThroughMaterials.add(Material.STATIONARY_WATER);
        }
    }

    @Override
    protected String getDisplayMaterialName() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            return MaterialBrush.getMaterialName(target.getBlock());
        }
        return super.getDisplayMaterialName();
    }

    @Override
    protected void onBackfire() {
        this.targeting.setTargetType(TargetType.SELF);
    }

    @Override
    public Location getTargetLocation() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            return target.getLocation();
        }
        return null;
    }

    @Override
    public Entity getTargetEntity() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            return target.getEntity();
        }
        return null;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        Target target = this.targeting.getTarget();
        if (target != null && target.isValid()) {
            Block block = target.getBlock();
            com.elmakers.mine.bukkit.block.MaterialAndData targetMaterial = new com.elmakers.mine.bukkit.block.MaterialAndData(block);
            if (targetMaterial.getMaterial() == Material.AIR) {
                targetMaterial.setMaterial(DEFAULT_EFFECT_MATERIAL);
            }
            return targetMaterial;
        }
        return super.getEffectMaterial();
    }

    public Class<?> getTargetEntityType() {
        return this.targetEntityType;
    }
}

