/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpellShopAction
extends BaseShopAction {
    private boolean showPath = true;
    private boolean showExtra = true;
    private boolean showRequired = false;
    private boolean showFree = false;
    private boolean showUpgrades = false;
    private boolean allowLocked = false;
    protected boolean requiresCastCounts = false;
    private Map<String, Double> spells = new HashMap<String, Double>();

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        block2: {
            block3: {
                super.initialize(spell, parameters);
                this.spells.clear();
                if (!parameters.contains("spells")) break block2;
                if (!parameters.isConfigurationSection("spells")) break block3;
                ConfigurationSection spellSection = ConfigurationUtils.getConfigurationSection(parameters, "spells");
                Set spellKeys = spellSection.getKeys(false);
                for (String spellKey : spellKeys) {
                    this.spells.put(spellKey, spellSection.getDouble(spellKey));
                }
                break block2;
            }
            List<String> spellList = ConfigurationUtils.getStringList(parameters, "spells");
            if (spellList == null) break block2;
            for (String spellKey : spellList) {
                this.spells.put(spellKey, null);
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.showPath = parameters.getBoolean("show_path_spells", true);
        this.showExtra = parameters.getBoolean("show_extra_spells", true);
        this.showRequired = parameters.getBoolean("show_required_spells", false);
        this.showFree = parameters.getBoolean("show_free", false);
        this.showUpgrades = parameters.getBoolean("show_upgrades", false);
        this.allowLocked = parameters.getBoolean("allow_locked", false);
        this.requiresCastCounts = parameters.getBoolean("upgrade_requires_casts", false);
        if (!this.castsSpells) {
            this.requireWand = true;
            this.applyToWand = true;
        }
    }

    @Override
    public List<BaseShopAction.ShopItem> getItems(CastContext context) {
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath currentPath;
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        boolean canProgress = false;
        if (wand != null && this.autoUpgrade && !(canProgress = wand.canProgress()) && wand.checkUpgrade(true) && wand.upgrade(false)) {
            return null;
        }
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath wandUpgradePath = currentPath = wand == null ? null : wand.getPath();
        if (!this.castsSpells && !this.allowLocked && wand.isLocked()) {
            context.showMessage(context.getMessage("no_path", "You may not learn with that $wand.").replace("$wand", wand.getName()));
            return null;
        }
        HashMap<String, Double> spellPrices = new HashMap<String, Double>();
        if (this.spells.size() > 0) {
            spellPrices.putAll(this.spells);
        } else {
            if (currentPath == null) {
                context.showMessage(context.getMessage("no_path", "You may not learn with that $wand.").replace("$wand", wand.getName()));
                return null;
            }
            if (this.showPath) {
                Collection<String> pathSpells = currentPath.getSpells();
                for (String string : pathSpells) {
                    spellPrices.put(string, null);
                }
            }
            if (this.showRequired) {
                Collection<String> requiredSpells = currentPath.getRequiredSpells();
                for (String string : requiredSpells) {
                    spellPrices.put(string, null);
                }
            }
            if (this.showUpgrades) {
                Collection<String> spells = wand.getSpells();
                for (String string : spells) {
                    MageSpell spell = mage.getSpell(string);
                    SpellTemplate upgradeSpell = spell.getUpgrade();
                    if (upgradeSpell == null) continue;
                    spellPrices.put(upgradeSpell.getKey(), null);
                }
            }
        }
        ArrayList<BaseShopAction.ShopItem> shopItems = new ArrayList<BaseShopAction.ShopItem>();
        for (Map.Entry entry : spellPrices.entrySet()) {
            BaseShopAction.ShopItem shopItem = this.createShopItem((String)entry.getKey(), (Double)entry.getValue(), context);
            if (shopItem == null) continue;
            shopItems.add(shopItem);
        }
        Collections.sort(shopItems);
        if (this.spells.size() == 0 && this.showExtra && !this.castsSpells && currentPath != null) {
            Collection<String> extraSpells = currentPath.getExtraSpells();
            ArrayList<BaseShopAction.ShopItem> arrayList = new ArrayList<BaseShopAction.ShopItem>();
            for (String spellKey : extraSpells) {
                BaseShopAction.ShopItem shopItem = this.createShopItem(spellKey, null, context);
                if (shopItem == null) continue;
                ItemStack spellItem = shopItem.getItem();
                ItemMeta meta = spellItem.getItemMeta();
                List itemLore = meta.getLore();
                itemLore.add(context.getMessage("extra_spell", "&aNot Required"));
                meta.setLore(itemLore);
                spellItem.setItemMeta(meta);
                arrayList.add(shopItem);
            }
            Collections.sort(arrayList);
            shopItems.addAll(arrayList);
        }
        if (wand != null && shopItems.size() == 0) {
            boolean bl;
            boolean canUpgrade = this.autoUpgrade && wand.checkUpgrade(false);
            boolean bl2 = bl = this.autoUpgrade && wand.hasUpgrade();
            if (!canProgress && !bl) {
                context.showMessage(context.getMessage("no_upgrade", "There is nothing more for you to learn here.").replace("$wand", wand.getName()));
                return null;
            }
            if (canUpgrade) {
                wand.upgrade(false);
                return null;
            }
            return null;
        }
        return shopItems;
    }

    private BaseShopAction.ShopItem createShopItem(String key, Double worth, CastContext context) {
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        MageController controller = context.getController();
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath currentPath = wand == null ? null : wand.getPath();
        key = context.parameterize(key);
        String spellKey = key.split(" ", 2)[0];
        if (!this.castsSpells && wand.hasSpell(spellKey)) {
            return null;
        }
        SpellTemplate spell = controller.getSpellTemplate(spellKey);
        if (spell == null) {
            return null;
        }
        if (worth == null) {
            worth = spell.getWorth();
        }
        if (worth <= 0.0 && !this.showFree) {
            return null;
        }
        if (!spell.hasCastPermission(mage.getCommandSender())) {
            return null;
        }
        ItemStack spellItem = controller.createSpellItem(key, this.castsSpells);
        if (!this.castsSpells) {
            int i;
            Spell mageSpell = wand != null ? wand.getSpell(spellKey) : null;
            String requiredPathKey = mageSpell != null ? mageSpell.getRequiredUpgradePath() : null;
            Set<String> requiredPathTags = mageSpell != null ? mageSpell.getRequiredUpgradeTags() : null;
            long requiredCastCount = mageSpell != null ? mageSpell.getRequiredUpgradeCasts() : 0L;
            long castCount = mageSpell != null ? Math.min(mageSpell.getCastCount(), requiredCastCount) : 0L;
            Collection<PrerequisiteSpell> missingSpells = PrerequisiteSpell.getMissingRequirements(wand, spell);
            ItemMeta meta = spellItem.getItemMeta();
            List itemLore = meta.getLore();
            ArrayList<String> lore = new ArrayList<String>();
            if (spell.getSpellKey().getLevel() > 1 && itemLore.size() > 0) {
                lore.add((String)itemLore.get(0));
            }
            String upgradeDescription = spell.getUpgradeDescription();
            if (this.showUpgrades && upgradeDescription != null && !upgradeDescription.isEmpty()) {
                InventoryUtils.wrapText(upgradeDescription, BaseSpell.MAX_LORE_LENGTH, lore);
            }
            String unpurchasableMessage = null;
            if (requiredPathKey != null && !currentPath.hasPath(requiredPathKey) || this.requiresCastCounts && requiredCastCount > 0L && castCount < requiredCastCount || requiredPathTags != null && !currentPath.hasAllTags(requiredPathTags) || !missingSpells.isEmpty()) {
                if (mageSpell != null && !spell.getName().equals(mageSpell.getName())) {
                    lore.add(context.getMessage("upgrade_name_change", "&r&4Upgrades: &r$name").replace("$name", mageSpell.getName()));
                }
                if (requiredPathKey != null && !currentPath.hasPath(requiredPathKey)) {
                    WandUpgradePath upgradePath = WandUpgradePath.getPath(requiredPathKey = currentPath.translatePath(requiredPathKey));
                    if (upgradePath != null) {
                        unpurchasableMessage = context.getMessage("level_requirement", "&r&cRequires: &6$path").replace("$path", upgradePath.getName());
                        InventoryUtils.wrapText(unpurchasableMessage, BaseSpell.MAX_LORE_LENGTH, lore);
                    }
                } else if (requiredPathTags != null && !requiredPathTags.isEmpty() && !currentPath.hasAllTags(requiredPathTags)) {
                    Set<String> tags = currentPath.getMissingTags(requiredPathTags);
                    unpurchasableMessage = context.getMessage("tags_requirement", "&r&cRequires: &6$tags").replace("$tags", controller.getMessages().formatList("tags", tags, "name"));
                    InventoryUtils.wrapText(unpurchasableMessage, BaseSpell.MAX_LORE_LENGTH, lore);
                }
                if (this.requiresCastCounts && requiredCastCount > 0L && castCount < requiredCastCount) {
                    unpurchasableMessage = ChatColor.RED + context.getMessage("cast_requirement", "&r&cCasts: &6$current&f/&e$required").replace("$current", Long.toString(castCount)).replace("$required", Long.toString(requiredCastCount));
                    lore.add(unpurchasableMessage);
                }
                if (!missingSpells.isEmpty()) {
                    ArrayList<String> spells = new ArrayList<String>(missingSpells.size());
                    for (PrerequisiteSpell s : missingSpells) {
                        SpellTemplate template = context.getController().getSpellTemplate(s.getSpellKey().getKey());
                        String spellMessage = context.getMessage("prerequisite_spell_level", "&6$name").replace("$name", template.getName());
                        if (s.getProgressLevel() > 1L) {
                            spellMessage = spellMessage + context.getMessage("prerequisite_spell_progress_level", " (Progress $level/$max_level)").replace("$level", Long.toString(s.getProgressLevel())).replace("$max_level", Long.toString(Math.max(1L, template.getMaxProgressLevel())));
                        }
                        spells.add(spellMessage);
                    }
                    unpurchasableMessage = ChatColor.RED + context.getMessage("required_spells", "&r&cRequires: $spells").replace("$spells", StringUtils.join(spells, (String)", "));
                    InventoryUtils.wrapText(ChatColor.GOLD.toString(), unpurchasableMessage, BaseSpell.MAX_LORE_LENGTH, lore);
                }
            }
            int n = i = spell.getSpellKey().getLevel() > 1 ? 1 : 0;
            while (i < itemLore.size()) {
                lore.add((String)itemLore.get(i));
                ++i;
            }
            meta.setLore(lore);
            spellItem.setItemMeta(meta);
            if (unpurchasableMessage != null) {
                InventoryUtils.setMeta(spellItem, "unpurchasable", unpurchasableMessage);
            }
        }
        return new BaseShopAction.ShopItem(spellItem, worth);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("show_free");
        parameters.add("show_path_spells");
        parameters.add("show_extra_spells");
        parameters.add("show_required_spells");
        parameters.add("show_upgrades");
        parameters.add("allow_locked");
        parameters.add("upgrade_requires_casts");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("show_free") || parameterKey.equals("show_required")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

