/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InventoryAction
extends BaseSpellAction {
    private InventoryType inventoryType;
    private String title;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        String inventoryTypeString = parameters.getString("type", "ender_chest").toUpperCase();
        if (inventoryTypeString.equals("ENDER")) {
            inventoryTypeString = "ENDER_CHEST";
        } else if (inventoryTypeString.equals("INVENTORY")) {
            inventoryTypeString = "CRAFTING";
        }
        this.title = parameters.getString("title");
        try {
            this.inventoryType = InventoryType.valueOf((String)inventoryTypeString);
        }
        catch (Exception ex) {
            context.getLogger().warning("Invalid inventory type in " + context.getSpell().getKey() + ": " + inventoryTypeString);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        MageController controller = context.getController();
        Entity targetEntity = context.getTargetEntity();
        Mage showMage = context.getMage();
        Player showPlayer = showMage.getPlayer();
        if (showPlayer == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Wand activeWand = showMage.getActiveWand();
        if (activeWand != null) {
            activeWand.closeInventory();
        }
        if (this.inventoryType == InventoryType.CRAFTING) {
            if (targetEntity == null || !(targetEntity instanceof Player)) {
                return SpellResult.NO_TARGET;
            }
            Mage mage = controller.getMage(targetEntity);
            Inventory inventory = mage.getInventory();
            showPlayer.openInventory(inventory);
        } else if (this.inventoryType == InventoryType.ENDER_CHEST) {
            if (targetEntity == null || !(targetEntity instanceof HumanEntity)) {
                return SpellResult.NO_TARGET;
            }
            HumanEntity humanTarget = (HumanEntity)targetEntity;
            Inventory enderInventory = humanTarget.getEnderChest();
            showPlayer.openInventory(enderInventory);
        } else if (this.inventoryType == InventoryType.WORKBENCH) {
            showPlayer.openWorkbench(null, true);
        } else {
            Inventory inventory = this.title != null && !this.title.isEmpty() ? Bukkit.createInventory((InventoryHolder)showPlayer, (InventoryType)this.inventoryType, (String)this.title) : Bukkit.createInventory((InventoryHolder)showPlayer, (InventoryType)this.inventoryType);
            showPlayer.openInventory(inventory);
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean requiresTargetEntity() {
        return this.inventoryType == InventoryType.ENDER_CHEST || this.inventoryType == InventoryType.CRAFTING;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("type");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("type")) {
            for (InventoryType invType : InventoryType.values()) {
                examples.add(invType.name().toLowerCase());
            }
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

