/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtils
extends NMSUtils {
    public static boolean saveTagsToItem(ConfigurationSection tags, ItemStack item) {
        Object handle = InventoryUtils.getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        return InventoryUtils.saveTagsToNBT(tags, tag, null);
    }

    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node) {
        return InventoryUtils.saveTagsToNBT(tags, node, null);
    }

    public static boolean saveTagsToNBT(ConfigurationSection tags, Object node, Set<String> tagNames) {
        return InventoryUtils.saveTagsToNBT(InventoryUtils.getMap(tags), node, tagNames);
    }

    public static boolean saveTagsToNBT(Map<String, Object> tags, Object node, Set<String> tagNames) {
        Set<String> currentTags;
        if (node == null) {
            Bukkit.getLogger().warning("Trying to save tags to a null node");
            return false;
        }
        if (!class_NBTTagCompound.isAssignableFrom(node.getClass())) {
            Bukkit.getLogger().warning("Trying to save tags to a non-CompoundTag");
            return false;
        }
        if (tagNames == null) {
            tagNames = tags.keySet();
        }
        currentTags = (currentTags = InventoryUtils.getTagKeys(node)) != null && !tagNames.containsAll(currentTags) ? new HashSet<String>(currentTags) : null;
        for (String tagName : tagNames) {
            if (currentTags != null) {
                currentTags.remove(tagName);
            }
            Object value = tags.get(tagName);
            try {
                Object wrappedTag = InventoryUtils.wrapInTag(value);
                if (wrappedTag == null) continue;
                class_NBTTagCompound_setMethod.invoke(node, tagName, wrappedTag);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error saving item data tag " + tagName, ex);
            }
        }
        if (currentTags != null) {
            for (String currentTag : currentTags) {
                InventoryUtils.removeMeta(node, currentTag);
            }
        }
        return true;
    }

    public static Object wrapInTag(Object value) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (value == null) {
            return null;
        }
        Object wrappedValue = null;
        if (value instanceof Boolean) {
            wrappedValue = class_NBTTagByte_constructor.newInstance((byte)((Boolean)value != false ? 1 : 0));
        } else if (value instanceof Double) {
            wrappedValue = class_NBTTagDouble_constructor.newInstance((double)((Double)value));
        } else if (value instanceof Float) {
            wrappedValue = class_NBTTagFloat_constructor.newInstance(Float.valueOf(((Float)value).floatValue()));
        } else if (value instanceof Integer) {
            wrappedValue = class_NBTTagInt_constructor.newInstance((int)((Integer)value));
        } else if (value instanceof Long) {
            wrappedValue = class_NBTTagLong_constructor.newInstance((long)((Long)value));
        } else if (value instanceof ConfigurationSection) {
            wrappedValue = class_NBTTagCompound.newInstance();
            InventoryUtils.saveTagsToNBT((ConfigurationSection)value, wrappedValue, null);
        } else if (value instanceof Map) {
            wrappedValue = class_NBTTagCompound.newInstance();
            Map valueMap = (Map)value;
            InventoryUtils.saveTagsToNBT(valueMap, wrappedValue, null);
        } else if (value instanceof Collection) {
            Collection list = (Collection)value;
            Object listMeta = class_NBTTagList.newInstance();
            for (Object item : list) {
                if (item == null) continue;
                class_NBTTagList_addMethod.invoke(listMeta, InventoryUtils.wrapInTag(item));
            }
            wrappedValue = listMeta;
        } else {
            wrappedValue = class_NBTTagString_consructor.newInstance(value.toString());
        }
        return wrappedValue;
    }

    public static Set<String> getTagKeys(Object tag) {
        if (tag == null || class_NBTTagCompound_getKeysMethod == null) {
            return null;
        }
        try {
            return (Set)class_NBTTagCompound_getKeysMethod.invoke(tag, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, Object tag) {
        try {
            Set<String> keys = InventoryUtils.getTagKeys(tag);
            if (keys == null) {
                return false;
            }
            for (String tagName : keys) {
                Object metaBase = class_NBTTagCompound_getMethod.invoke(tag, tagName);
                if (metaBase == null) continue;
                if (class_NBTTagCompound.isAssignableFrom(metaBase.getClass())) {
                    ConfigurationSection newSection = tags.createSection(tagName);
                    InventoryUtils.loadAllTagsFromNBT(newSection, metaBase);
                    continue;
                }
                if (class_NBTTagString.isAssignableFrom(metaBase.getClass())) {
                    ConfigurationUtils.set(tags, tagName, class_NBTTagString_dataField.get(metaBase));
                    continue;
                }
                tags.set(tagName, InventoryUtils.getTagValue(metaBase));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static Object getMetaObject(Object tag, String key) {
        try {
            Object metaBase = class_NBTTagCompound_getMethod.invoke(tag, key);
            return InventoryUtils.getTagValue(metaBase);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Object getTagValue(Object tag) throws IllegalAccessException, InvocationTargetException {
        if (tag == null) {
            return null;
        }
        Object value = null;
        if (class_NBTTagDouble.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagDouble_dataField.get(tag);
        } else if (class_NBTTagInt.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagInt_dataField.get(tag);
        } else if (class_NBTTagLong.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagLong_dataField.get(tag);
        } else if (class_NBTTagFloat.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagFloat_dataField.get(tag);
        } else if (class_NBTTagShort.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagShort_dataField.get(tag);
        } else if (class_NBTTagByte.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagByte_dataField.get(tag);
            if (value != null && value.equals((byte)0)) {
                value = false;
            } else if (value != null && value.equals((byte)1)) {
                value = true;
            }
        } else if (class_NBTTagList.isAssignableFrom(tag.getClass())) {
            List items = (List)class_NBTTagList_list.get(tag);
            ArrayList<Object> converted = new ArrayList<Object>();
            for (Object baseTag : items) {
                Object convertedBase = InventoryUtils.getTagValue(baseTag);
                if (convertedBase == null) continue;
                converted.add(convertedBase);
            }
            value = converted;
        } else if (class_NBTTagString.isAssignableFrom(tag.getClass())) {
            value = class_NBTTagString_dataField.get(tag);
        } else if (class_NBTTagCompound.isAssignableFrom(tag.getClass())) {
            HashMap<String, Object> compoundMap = new HashMap<String, Object>();
            Set<String> keys = InventoryUtils.getTagKeys(tag);
            for (String key : keys) {
                Object baseTag = class_NBTTagCompound_getMethod.invoke(tag, key);
                Object convertedBase = InventoryUtils.getTagValue(baseTag);
                if (convertedBase == null) continue;
                compoundMap.put(key, convertedBase);
            }
            value = compoundMap;
        }
        return value;
    }

    public static boolean loadAllTagsFromNBT(ConfigurationSection tags, ItemStack item) {
        if (item == null) {
            return false;
        }
        Object handle = InventoryUtils.getHandle(item);
        if (handle == null) {
            return false;
        }
        Object tag = InventoryUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        return InventoryUtils.loadAllTagsFromNBT(tags, tag);
    }

    public static boolean inventorySetItem(Inventory inventory, int index, ItemStack item) {
        try {
            Method setItemMethod = class_CraftInventoryCustom.getMethod("setItem", Integer.TYPE, ItemStack.class);
            setItemMethod.invoke((Object)inventory, index, item);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean setInventoryResults(Inventory inventory, ItemStack item) {
        try {
            Method getResultsMethod = inventory.getClass().getMethod("getResultInventory", new Class[0]);
            Object inv = getResultsMethod.invoke((Object)inventory, new Object[0]);
            Method setItemMethod = inv.getClass().getMethod("setItem", Integer.TYPE, class_ItemStack);
            setItemMethod.invoke(inv, 0, InventoryUtils.getHandle(item));
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static ItemStack getURLSkull(String url) {
        return InventoryUtils.getURLSkull(url, "MHF_Question", UUID.randomUUID(), null);
    }

    public static ItemStack getURLSkull(URL url) {
        return InventoryUtils.getURLSkull(url, "MHF_Question", UUID.randomUUID(), null);
    }

    public static ItemStack getURLSkull(String url, String ownerName, UUID id, String itemName) {
        try {
            return InventoryUtils.getURLSkull(new URL(url), ownerName, id, itemName);
        }
        catch (MalformedURLException e) {
            Bukkit.getLogger().log(Level.WARNING, "Malformed URL: " + url, e);
            return new ItemStack(Material.SKULL_ITEM, 1, 0, Byte.valueOf((byte)3));
        }
    }

    public static ItemStack getURLSkull(URL url, String ownerName, UUID id, String itemName) {
        ItemStack skull = new ItemStack(Material.SKULL_ITEM, 1, 0, Byte.valueOf((byte)3));
        if (itemName != null) {
            ItemMeta meta = skull.getItemMeta();
            meta.setDisplayName(itemName);
            skull.setItemMeta(meta);
        }
        try {
            skull = InventoryUtils.makeReal(skull);
            Object skullOwner = InventoryUtils.createNode(skull, "SkullOwner");
            InventoryUtils.setMeta(skullOwner, "Id", id.toString());
            InventoryUtils.setMeta(skullOwner, "Name", ownerName);
            Object properties = InventoryUtils.createNode(skullOwner, "Properties");
            Object listMeta = class_NBTTagList.newInstance();
            Object textureNode = class_NBTTagCompound.newInstance();
            String textureJSON = "{textures:{SKIN:{url:\"" + url + "\"}}}";
            String encoded = Base64Coder.encodeString(textureJSON);
            InventoryUtils.setMeta(textureNode, "Value", encoded);
            class_NBTTagList_addMethod.invoke(listMeta, textureNode);
            class_NBTTagCompound_setMethod.invoke(properties, "textures", listMeta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return skull;
    }

    public static String getProfileURL(Object profile) {
        String url = null;
        if (profile == null) {
            return null;
        }
        try {
            Multimap properties = (Multimap)class_GameProfile_properties.get(profile);
            Collection textures = properties.get((Object)"textures");
            if (textures != null && textures.size() > 0) {
                Object textureProperty = textures.iterator().next();
                String texture = (String)class_GameProfileProperty_value.get(textureProperty);
                String decoded = Base64Coder.decodeString(texture);
                url = decoded.replace("{textures:{SKIN:{url:\"", "").replace("\"}}}", "").trim();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return url;
    }

    public static String getSkullURL(ItemStack skull) {
        return InventoryUtils.getProfileURL(InventoryUtils.getSkullProfile(skull.getItemMeta()));
    }

    public static ItemStack getPlayerSkull(String playerName) {
        return InventoryUtils.getPlayerSkull(playerName, UUID.randomUUID(), null);
    }

    public static ItemStack getPlayerSkull(String playerName, String itemName) {
        return InventoryUtils.getPlayerSkull(playerName, UUID.randomUUID(), itemName);
    }

    public static ItemStack getPlayerSkull(String playerName, UUID uuid) {
        return InventoryUtils.getPlayerSkull(playerName, uuid, null);
    }

    public static ItemStack getPlayerSkull(String playerName, UUID uuid, String itemName) {
        return InventoryUtils.getURLSkull(InventoryUtils.getPlayerSkullURL(playerName), playerName, uuid, itemName);
    }

    public static String getPlayerSkullURL(String playerName) {
        return "http://skins.minecraft.net/MinecraftSkins/" + playerName + ".png";
    }

    public static ItemStack getPlayerSkull(Player player) {
        return InventoryUtils.getPlayerSkull(player, null);
    }

    public static ItemStack getPlayerSkull(Player player, String itemName) {
        return InventoryUtils.getPlayerSkull(player.getName(), player.getUniqueId(), itemName);
    }

    public static Object getSkullProfile(ItemMeta itemMeta) {
        Object profile = null;
        try {
            if (itemMeta == null || !class_CraftMetaSkull.isInstance(itemMeta)) {
                return null;
            }
            profile = class_CraftMetaSkull_profile.get(itemMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profile;
    }

    public static boolean setSkullProfile(ItemMeta itemMeta, Object data) {
        try {
            if (itemMeta == null || !class_CraftMetaSkull.isInstance(itemMeta)) {
                return false;
            }
            class_CraftMetaSkull_profile.set(itemMeta, data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void wrapText(String text, int maxLength, Collection<String> list) {
        InventoryUtils.wrapText("", text, maxLength, list);
    }

    public static void wrapText(String prefix, String text, int maxLength, Collection<String> list) {
        while (text.length() > maxLength) {
            int spaceIndex = text.lastIndexOf(32, maxLength);
            if (spaceIndex <= 0) {
                list.add(prefix + text);
                return;
            }
            list.add(prefix + text.substring(0, spaceIndex));
            text = text.substring(spaceIndex);
        }
        list.add(prefix + text);
    }

    public static boolean hasItem(Mage mage, String itemName) {
        return InventoryUtils.hasItem(mage.getInventory(), itemName);
    }

    public static boolean hasItem(Inventory inventory, String itemName) {
        ItemStack[] items;
        if (inventory == null) {
            return false;
        }
        for (ItemStack item : items = inventory.getContents()) {
            String displayName;
            if (item == null || !item.hasItemMeta() || (displayName = item.getItemMeta().getDisplayName()) == null || !displayName.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public static void openSign(Player player, Location signBlock) {
        try {
            Object tileEntity = InventoryUtils.getTileEntity(signBlock);
            Object playerHandle = InventoryUtils.getHandle(player);
            if (tileEntity != null && playerHandle != null) {
                class_EntityPlayer_openSignMethod.invoke(playerHandle, tileEntity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void makeKeep(ItemStack itemStack) {
        InventoryUtils.setMeta(itemStack, "keep", "true");
    }

    public static boolean isKeep(ItemStack itemStack) {
        return InventoryUtils.hasMeta(itemStack, "keep");
    }

    public static void applyAttributes(ItemStack item, ConfigurationSection attributeConfig, String slot) {
        if (item == null || attributeConfig == null) {
            return;
        }
        Set attributeKeys = attributeConfig.getKeys(false);
        for (String attributeKey : attributeKeys) {
            try {
                double value;
                Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                if (CompatibilityUtils.setItemAttribute(item, attribute, value = attributeConfig.getDouble(attributeKey), slot)) continue;
                Bukkit.getLogger().warning("Failed to set attribute: " + attributeKey);
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid attribute: " + attributeKey);
            }
        }
    }

    public static void applyEnchantments(ItemStack item, ConfigurationSection enchantConfig) {
        if (item == null || enchantConfig == null) {
            return;
        }
        Set enchantKeys = enchantConfig.getKeys(false);
        for (String enchantKey : enchantKeys) {
            try {
                Enchantment enchantment = Enchantment.getByName((String)enchantKey.toUpperCase());
                item.addUnsafeEnchantment(enchantment, enchantConfig.getInt(enchantKey));
            }
            catch (Exception ex) {
                Bukkit.getLogger().warning("Invalid enchantment: " + enchantKey);
            }
        }
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return true;
        }
        if (class_ItemStack_isEmptyMethod == null) {
            return false;
        }
        try {
            Object handle = InventoryUtils.getHandle(itemStack);
            if (handle == null) {
                return false;
            }
            return (Boolean)class_ItemStack_isEmptyMethod.invoke(handle, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String describeProperty(Object property) {
        return InventoryUtils.describeProperty(property, 0);
    }

    public static String describeProperty(Object property, int maxLength) {
        String propertyString;
        if (property == null) {
            return "(Empty)";
        }
        if (property instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)property;
            Set keys = section.getKeys(false);
            String full = "{";
            boolean first = true;
            for (String key : keys) {
                if (!first) {
                    full = full + ",";
                }
                first = false;
                full = full + key + "=" + InventoryUtils.describeProperty(section.get(key));
            }
            propertyString = full + "}";
        } else {
            propertyString = property.toString();
        }
        if (maxLength > 0 && propertyString.length() > maxLength - 3) {
            propertyString = propertyString.substring(0, maxLength - 3) + "...";
        }
        return propertyString;
    }
}

