/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.batch.ShapeBatch;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class ShapeSpell
extends BrushSpell {
    public static final String[] CONSTRUCT_PARAMETERS = new String[]{"radius", "max_dimension", "orient_dimension_max", "orient_dimension_min", "thickness"};
    private static final ConstructionType DEFAULT_CONSTRUCTION_TYPE = ConstructionType.SPHERE;
    private static final int DEFAULT_RADIUS = 8;
    private static final int DEFAULT_MAX_DIMENSION = 32;
    private Block targetBlock = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Target t = this.getTarget();
        Block target = t.getBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        int radius = parameters.getInt("radius", 8);
        radius = parameters.getInt("r", radius);
        Location orientTo = null;
        if (this.getTargetType() == TargetType.SELECT) {
            if (this.targetLocation2 != null) {
                this.targetBlock = this.targetLocation2.getBlock();
            }
            if (this.targetBlock == null) {
                this.targetBlock = target;
                this.activate();
                return SpellResult.TARGET_SELECTED;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            orientTo = target.getLocation();
            target = this.targetBlock;
        }
        int maxDimension = parameters.getInt("max_dimension", 32);
        maxDimension = parameters.getInt("md", maxDimension);
        int diameter = radius * 2;
        maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
        if (diameter > maxDimension) {
            return SpellResult.FAIL;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getBrush();
        buildWith.setTarget(target.getLocation());
        ConstructionType conType = DEFAULT_CONSTRUCTION_TYPE;
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        int thickness = parameters.getInt("thickness", 1);
        ShapeBatch batch = new ShapeBatch(this, target.getLocation(), conType, radius, thickness, orientTo);
        if (parameters.contains("orient_dimension_max")) {
            batch.setOrientDimensionMax(parameters.getInt("orient_dimension_max"));
        } else if (parameters.contains("odmax")) {
            batch.setOrientDimensionMax(parameters.getInt("odmax"));
        }
        if (parameters.contains("orient_dimension_min")) {
            batch.setOrientDimensionMin(parameters.getInt("orient_dimension_min"));
        } else if (parameters.contains("odmin")) {
            batch.setOrientDimensionMin(parameters.getInt("odmin"));
        }
        boolean success = this.mage.addBatch(batch);
        this.deactivate();
        return success ? SpellResult.CAST : SpellResult.FAIL;
    }

    @Override
    protected boolean isBatched() {
        return true;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
    }

    @Override
    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.deactivate();
            return true;
        }
        return false;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(CONSTRUCT_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("radius") || parameterKey.equals("max_dimension") || parameterKey.equals("orient_dimension_max") || parameterKey.equals("orient_dimension_min") || parameterKey.equals("thickness")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("type")) {
            ConstructionType[] constructionTypes;
            for (ConstructionType constructionType : constructionTypes = ConstructionType.values()) {
                examples.add(constructionType.name().toLowerCase());
            }
        }
    }
}

