/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.protection.PVPManager;
import com.elmakers.mine.bukkit.protection.WorldGuardAPI;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardManager
implements PVPManager,
BlockBreakManager,
BlockBuildManager {
    private boolean enabled = false;
    private WorldGuardAPI worldGuard = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.worldGuard != null && this.worldGuard.isEnabled();
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            if (this.worldGuard == null) {
                plugin.getLogger().info("WorldGuard not found, region protection and pvp checks will not be used.");
            } else {
                plugin.getLogger().info("WorldGuard found, will respect build permissions for construction spells");
                this.worldGuard.checkFlagSupport();
            }
        } else {
            this.worldGuard = null;
            plugin.getLogger().info("WorldGuard integration disabled, region protection and pvp checks will not be used.");
        }
    }

    public void initializeFlags(Plugin plugin) {
        try {
            Plugin wgPlugin = plugin.getServer().getPluginManager().getPlugin("WorldGuard");
            if (wgPlugin != null) {
                String[] versionPieces = StringUtils.split((String)wgPlugin.getDescription().getVersion(), (char)'.');
                int version = Integer.parseInt(versionPieces[0]);
                if (version >= 6) {
                    this.worldGuard = new WorldGuardAPI(wgPlugin, plugin);
                } else {
                    plugin.getLogger().warning("Only WorldGuard 6 and above are supported- please update! (WG version: " + wgPlugin.getDescription().getVersion() + ")");
                }
            }
        }
        catch (Throwable ex) {
            plugin.getLogger().log(Level.WARNING, "Error setting up custom WorldGuard flags", ex);
        }
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (!this.enabled || this.worldGuard == null || location == null) {
            return true;
        }
        return this.worldGuard.isPVPAllowed(player, location);
    }

    @Override
    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.worldGuard != null) {
            return this.worldGuard.hasBuildPermission(player, block);
        }
        return true;
    }

    public Boolean getCastPermission(Player player, SpellTemplate spell, Location location) {
        if (this.enabled && this.worldGuard != null) {
            return this.worldGuard.getCastPermission(player, spell, location);
        }
        return null;
    }

    public Boolean getWandPermission(Player player, Wand wand, Location location) {
        if (this.enabled && this.worldGuard != null) {
            return this.worldGuard.getWandPermission(player, wand, location);
        }
        return null;
    }

    public String getReflective(Player player, Location location) {
        if (this.enabled && this.worldGuard != null) {
            return this.worldGuard.getReflective(player, location);
        }
        return null;
    }

    public String getDestructible(Player player, Location location) {
        if (this.enabled && this.worldGuard != null) {
            return this.worldGuard.getDestructible(player, location);
        }
        return null;
    }

    public Set<String> getSpellOverrides(Player player, Location location) {
        if (this.enabled && this.worldGuard != null) {
            return this.worldGuard.getSpellOverrides(player, location);
        }
        return null;
    }

    @Override
    public boolean hasBreakPermission(Player player, Block block) {
        return this.hasBuildPermission(player, block);
    }
}

