/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.protection.BlockBreakManager;
import com.elmakers.mine.bukkit.protection.BlockBuildManager;
import com.elmakers.mine.bukkit.protection.PVPManager;
import com.elmakers.mine.bukkit.protection.TownyAPI;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyManager
implements PVPManager,
BlockBreakManager,
BlockBuildManager {
    private boolean enabled = false;
    private TownyAPI towny = null;
    protected boolean wildernessBypass;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.towny != null;
    }

    public void initialize(Plugin plugin) {
        if (this.enabled) {
            try {
                Plugin townyPlugin = plugin.getServer().getPluginManager().getPlugin("Towny");
                if (townyPlugin != null) {
                    this.towny = new TownyAPI(this, townyPlugin);
                }
            }
            catch (Throwable ex) {
                plugin.getLogger().log(Level.WARNING, "Error initializing Towny integration", ex);
            }
            if (this.towny == null) {
                plugin.getLogger().info("Towny not found, region protection and pvp checks will not be used.");
            } else {
                plugin.getLogger().info("Towny found, will respect build permissions for construction spells");
            }
        } else {
            plugin.getLogger().info("Towny manager disabled, region protection and pvp checks will not be used.");
            this.towny = null;
        }
    }

    public void setWildernessBypass(boolean bypass) {
        this.wildernessBypass = bypass;
    }

    @Override
    public boolean hasBuildPermission(Player player, Block block) {
        if (this.enabled && block != null && this.towny != null) {
            return this.towny.hasBuildPermission(player, block);
        }
        return true;
    }

    @Override
    public boolean hasBreakPermission(Player player, Block block) {
        if (this.enabled && block != null && this.towny != null) {
            return this.towny.hasBreakPermission(player, block);
        }
        return true;
    }

    @Override
    public boolean isPVPAllowed(Player player, Location location) {
        if (!this.enabled || this.towny == null || location == null) {
            return true;
        }
        return this.towny.isPVPAllowed(location);
    }

    public boolean canTarget(Entity entity, Entity target) {
        if (!this.enabled || this.towny == null || entity == null || target == null) {
            return true;
        }
        return this.towny.canTarget(entity, target);
    }

    public Location getTownLocation(Player player) {
        if (!this.enabled || this.towny == null || player == null) {
            return null;
        }
        return this.towny.getTownLocation(player);
    }

    public boolean createPlot(Location center, Double price) {
        if (!this.enabled || this.towny == null || center == null) {
            return false;
        }
        return this.towny.createPlot(center, price);
    }
}

