/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompleteDragTask;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.elmakers.mine.bukkit.wand.WandMode;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class InventoryController
implements Listener {
    private final MagicController controller;
    private boolean enableItemHacks = true;
    private boolean dropChangesPages = false;

    public InventoryController(MagicController controller) {
        this.controller = controller;
    }

    public void setEnableItemHacks(boolean hack) {
        this.enableItemHacks = hack;
    }

    public void setDropChangesPages(boolean drop) {
        this.dropChangesPages = drop;
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        GUIAction activeGUI;
        Mage mage = this.controller.getMage((Entity)event.getWhoClicked());
        GUIAction gUIAction = activeGUI = mage == null ? null : mage.getActiveGUI();
        if (activeGUI != null) {
            activeGUI.dragged(event);
            return;
        }
        if (!this.enableItemHacks) {
            return;
        }
        ItemStack oldStack = event.getOldCursor();
        HumanEntity entity = event.getWhoClicked();
        if (oldStack != null && oldStack.hasItemMeta() && entity instanceof Player) {
            Map draggedSlots = event.getNewItems();
            if (draggedSlots.size() != 1) {
                return;
            }
            event.setCancelled(true);
            InventoryView view = event.getView();
            for (Integer dslot : draggedSlots.keySet()) {
                CompleteDragTask completeDrag = new CompleteDragTask((Player)entity, view, dslot);
                completeDrag.runTaskLater((Plugin)this.controller.getPlugin(), 1L);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        WandMode wandMode;
        Wand wand;
        boolean isContainerSlot;
        boolean isHotbar;
        boolean isSkill;
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = apiMage;
        GUIAction gui = mage.getActiveGUI();
        if (gui != null) {
            gui.clicked(event);
            return;
        }
        InventoryAction action = event.getAction();
        InventoryType inventoryType = event.getInventory().getType();
        ItemStack clickedItem = event.getCurrentItem();
        boolean isDrop = event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP;
        boolean bl = isSkill = clickedItem != null && Wand.isSkill(clickedItem);
        if (isSkill && inventoryType != InventoryType.CRAFTING) {
            if (!isDrop) {
                event.setCancelled(true);
            }
            return;
        }
        if (isSkill && action == InventoryAction.PICKUP_HALF) {
            MageSpell spell = mage.getSpell(Wand.getSpell(clickedItem));
            if (spell != null) {
                spell.cast();
            }
            player.closeInventory();
            event.setCancelled(true);
            return;
        }
        if (clickedItem != null && NMSUtils.isTemporary(clickedItem)) {
            String message = NMSUtils.getTemporaryMessage(clickedItem);
            if (message != null && message.length() > 1) {
                mage.sendMessage(message);
            }
            ItemStack replacement = NMSUtils.getReplacement(clickedItem);
            event.setCurrentItem(replacement);
            event.setCancelled(true);
            return;
        }
        ItemStack heldItem = event.getCursor();
        if (heldItem != null && event.getSlotType() == InventoryType.SlotType.ARMOR) {
            if (Wand.isSpell(heldItem)) {
                event.setCancelled(true);
                return;
            }
            if (Wand.isWand(clickedItem) || Wand.isWand(heldItem)) {
                this.controller.onArmorUpdated(mage);
            }
        }
        boolean bl2 = isHotbar = event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD;
        if (isHotbar && event.getSlotType() == InventoryType.SlotType.ARMOR) {
            int slot = event.getHotbarButton();
            ItemStack item = mage.getPlayer().getInventory().getItem(slot);
            if (item != null && Wand.isSpell(item)) {
                event.setCancelled(true);
                return;
            }
            this.controller.onArmorUpdated(mage);
        }
        Wand activeWand = mage.getActiveWand();
        boolean isChest = inventoryType == InventoryType.CHEST || inventoryType == InventoryType.HOPPER || inventoryType == InventoryType.DISPENSER || inventoryType == InventoryType.DROPPER;
        boolean clickedWand = Wand.isWand(clickedItem);
        boolean bl3 = isContainerSlot = event.getSlot() == event.getRawSlot();
        if (activeWand != null && activeWand.isInventoryOpen()) {
            PlayerInventory inventory = player.getInventory();
            for (int i = 0; i < 8; ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getAmount() != 0) continue;
                item.setAmount(1);
            }
            if (event.getRawSlot() == 45) {
                event.setCancelled(true);
                return;
            }
            if (Wand.isSpell(clickedItem) && clickedItem.getAmount() != 1) {
                clickedItem.setAmount(1);
            }
            if (clickedWand) {
                event.setCancelled(true);
                if (this.dropChangesPages) {
                    activeWand.cycleInventory();
                } else {
                    activeWand.cycleHotbar(1);
                }
                return;
            }
            if (isHotbar && Wand.isWand(player.getInventory().getItem(event.getHotbarButton()))) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedItem != null && this.controller.isWearable(clickedItem)) {
                event.setCancelled(true);
                return;
            }
            if (Wand.isWand(event.getCursor())) {
                activeWand.closeInventory();
                event.setCursor(null);
                event.setCancelled(true);
                return;
            }
        } else if (activeWand != null) {
            int activeSlot = player.getInventory().getHeldItemSlot();
            if (event.getSlot() == activeSlot || event.getAction() == InventoryAction.HOTBAR_SWAP && event.getHotbarButton() == activeSlot) {
                mage.checkWand();
                activeWand = mage.getActiveWand();
            }
        }
        if (clickedWand && Wand.Undroppable && !player.hasPermission("Magic.wand.override_drop") && isChest && !isContainerSlot && (wand = this.controller.getWand(clickedItem)).isUndroppable()) {
            event.setCancelled(true);
            return;
        }
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedItem != null && this.controller.isWearable(clickedItem)) {
            this.controller.onArmorUpdated(mage);
        }
        if (isDrop) {
            if (clickedWand && (wand = this.controller.getWand(clickedItem)).isUndroppable()) {
                event.setCancelled(true);
                if (activeWand != null) {
                    if (activeWand.getHotbarCount() > 1) {
                        activeWand.cycleHotbar(1);
                    } else {
                        activeWand.closeInventory();
                    }
                }
                return;
            }
            if (activeWand != null && activeWand.isInventoryOpen()) {
                ItemStack droppedItem = clickedItem;
                if (!Wand.isSpell(droppedItem)) {
                    mage.giveItem(droppedItem);
                    event.setCurrentItem(null);
                    event.setCancelled(true);
                    return;
                }
                Integer slot = event.getSlot();
                int heldSlot = player.getInventory().getHeldItemSlot();
                Inventory hotbar = activeWand.getHotbar();
                if (hotbar != null && slot >= 0 && slot <= hotbar.getSize() && slot != heldSlot && activeWand.getMode() == WandMode.INVENTORY) {
                    if (slot > heldSlot) {
                        Integer n = slot;
                        Integer n2 = slot = Integer.valueOf(slot - 1);
                    }
                    if (slot < hotbar.getSize()) {
                        droppedItem = hotbar.getItem(slot.intValue());
                    } else {
                        slot = null;
                    }
                } else {
                    slot = null;
                }
                if (!this.controller.isSpellDroppingEnabled()) {
                    MageSpell spell;
                    player.closeInventory();
                    String spellName = Wand.getSpell(droppedItem);
                    if (spellName != null && !activeWand.isManualQuickCastDisabled() && (spell = mage.getSpell(spellName)) != null) {
                        activeWand.cast(spell);
                        if (hotbar != null && slot != null) {
                            droppedItem = hotbar.getItem(slot.intValue());
                        }
                    }
                    event.setCancelled(true);
                    if (hotbar != null && slot != null && mage.getActiveGUI() == null) {
                        player.getInventory().setItem(event.getSlot(), droppedItem);
                        DeprecatedUtils.updateInventory(player);
                    }
                    return;
                }
                ItemStack newDrop = this.controller.removeItemFromWand(activeWand, droppedItem);
                if (newDrop != null) {
                    Location location = player.getLocation();
                    Item item = location.getWorld().dropItem(location, newDrop);
                    item.setVelocity(location.getDirection().normalize());
                } else {
                    event.setCancelled(true);
                }
            }
            return;
        }
        if (activeWand != null && ((wandMode = activeWand.getMode()) == WandMode.INVENTORY && inventoryType == InventoryType.CRAFTING || wandMode == WandMode.CHEST && inventoryType == InventoryType.CHEST) && activeWand.isInventoryOpen()) {
            if (event.getAction() == InventoryAction.NOTHING) {
                int direction = event.getClick() == ClickType.LEFT ? 1 : -1;
                activeWand.cycleInventory(direction);
                event.setCancelled(true);
                return;
            }
            if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.PICKUP_HALF || wandMode == WandMode.CHEST) {
                this.controller.onPlayerActivateIcon(mage, activeWand, clickedItem);
                player.closeInventory();
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        Wand previousWand;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = apiMage;
        GUIAction gui = mage.getActiveGUI();
        if (gui != null) {
            mage.onGUIDeactivate();
        }
        if ((previousWand = mage.getActiveWand()) != null && previousWand.isInventoryOpen()) {
            if (previousWand.getMode() == WandMode.INVENTORY) {
                previousWand.saveInventory();
                previousWand.updateHotbar();
            } else if (previousWand.getMode() == WandMode.CHEST) {
                previousWand.closeInventory();
            }
        } else {
            mage.checkWand();
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = apiMage;
        Wand wand = mage.getActiveWand();
        GUIAction gui = mage.getActiveGUI();
        if (!(wand == null || gui != null || event.getView().getType() == InventoryType.CRAFTING || wand.getMode() != WandMode.INVENTORY && wand.isInventoryOpen())) {
            wand.deactivate();
        }
    }
}

