/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class MagicItemCommandExecutor
extends MagicTabExecutor {
    public MagicItemCommandExecutor(MagicAPI api) {
        super(api);
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("delete")) {
            if (!this.api.hasPermission(sender, "Magic.commands.item.delete")) {
                this.sendNoPermission(sender);
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage("Usage: /mitem delete <itemkey>");
                return true;
            }
            this.onItemDelete(sender, args[1]);
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (!this.checkItem(player)) {
            return true;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        String subCommand = args[0];
        String[] args2 = Arrays.copyOfRange(args, 1, args.length);
        return this.processItemCommand(player, itemInHand, subCommand, args2);
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String subCommand2;
        int n;
        String subCommand;
        ArrayList<String> options = new ArrayList<String>();
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "add");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "remove");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "name");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "describe");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "duplicate");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "save");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "delete");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "destroy");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "worth");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "type");
            this.addIfPermissible(sender, options, "Magic.commands.mitem.", "skull");
        }
        if (args.length == 2) {
            File itemFolder;
            subCommand = args[0];
            String subCommandPNode = "Magic.commands.mitem." + subCommand;
            if (!this.api.hasPermission(sender, subCommandPNode)) {
                return options;
            }
            if (subCommand.equalsIgnoreCase("add")) {
                options.add("enchant");
                options.add("attribute");
                options.add("lore");
                options.add("flag");
                options.add("unbreakable");
                options.add("unplaceable");
            }
            if (subCommand.equalsIgnoreCase("remove")) {
                options.add("enchant");
                options.add("attribute");
                options.add("lore");
                options.add("flag");
                options.add("unbreakable");
                options.add("unplaceable");
            }
            if (subCommand.equalsIgnoreCase("type")) {
                for (Material material : Material.values()) {
                    options.add(material.name().toLowerCase());
                }
            }
            if (subCommand.equalsIgnoreCase("delete") && (itemFolder = new File(this.api.getController().getConfigFolder(), "items")).exists()) {
                File[] files;
                File[] fileArray = files = itemFolder.listFiles();
                int n2 = fileArray.length;
                for (n = 0; n < n2; ++n) {
                    File file = fileArray[n];
                    if (!file.getName().endsWith(".yml")) continue;
                    options.add(file.getName().replace(".yml", ""));
                }
            }
        }
        if (args.length == 3) {
            boolean isAddRemove;
            subCommand = args[0];
            subCommand2 = args[1];
            String commandPNode = "Magic.commands.mitem." + subCommand;
            if (!this.api.hasPermission(sender, commandPNode)) {
                return options;
            }
            boolean bl = isAddRemove = subCommand.equalsIgnoreCase("remove") || subCommand.equalsIgnoreCase("add");
            if (isAddRemove && subCommand2.equalsIgnoreCase("enchant")) {
                Enchantment[] enchantmentArray = Enchantment.values();
                int n3 = enchantmentArray.length;
                for (n = 0; n < n3; ++n) {
                    Enchantment enchantment = enchantmentArray[n];
                    options.add(enchantment.getName().toLowerCase());
                }
            }
            if (isAddRemove && subCommand2.equalsIgnoreCase("attribute")) {
                Attribute[] attributeArray = Attribute.values();
                int n4 = attributeArray.length;
                for (n = 0; n < n4; ++n) {
                    Attribute attribute = attributeArray[n];
                    options.add(attribute.name().toLowerCase());
                }
            }
            if (isAddRemove && subCommand2.equalsIgnoreCase("flag")) {
                for (ItemFlag flag : ItemFlag.values()) {
                    options.add(flag.name().toLowerCase());
                }
            }
            if (subCommand.equalsIgnoreCase("remove") && subCommand2.equalsIgnoreCase("lore")) {
                options.add("1");
                options.add("2");
                options.add("3");
            }
        }
        if (args.length == 5) {
            subCommand = args[0];
            subCommand2 = args[1];
            if (subCommand.equalsIgnoreCase("add") && subCommand2.equalsIgnoreCase("attribute")) {
                options.add("mainhand");
                options.add("offhand");
                options.add("feet");
                options.add("legs");
                options.add("chest");
                options.add("head");
            }
        }
        return options;
    }

    protected boolean processItemCommand(Player player, ItemStack item, String subCommand, String[] args) {
        if (!this.api.hasPermission((CommandSender)player, "Magic.commands.mitem." + subCommand)) {
            this.sendNoPermission((CommandSender)player);
            return true;
        }
        if (subCommand.equalsIgnoreCase("add")) {
            return this.onItemAdd(player, item, args);
        }
        if (subCommand.equalsIgnoreCase("remove")) {
            return this.onItemRemove(player, item, args);
        }
        if (subCommand.equalsIgnoreCase("destroy")) {
            return this.onItemDestroy(player);
        }
        if (subCommand.equalsIgnoreCase("worth")) {
            return this.onItemWorth(player, item);
        }
        if (subCommand.equalsIgnoreCase("type")) {
            return this.onItemType(player, item, args);
        }
        if (subCommand.equalsIgnoreCase("duplicate")) {
            return this.onItemDuplicate(player, item);
        }
        if (subCommand.equalsIgnoreCase("save")) {
            return this.onItemSave(player, item, args);
        }
        if (subCommand.equalsIgnoreCase("describe")) {
            return this.onItemDescribe(player, item);
        }
        if (subCommand.equalsIgnoreCase("name")) {
            return this.onItemName(player, item, args);
        }
        if (subCommand.equalsIgnoreCase("export")) {
            return this.onItemExport(player, item, args);
        }
        if (subCommand.equalsIgnoreCase("skull")) {
            return this.onItemSkull(player, item);
        }
        return false;
    }

    public boolean onItemDescribe(Player player, ItemStack item) {
        ItemData itemData;
        MaterialAndData material = new MaterialAndData(item);
        player.sendMessage(ChatColor.GOLD + material.getKey());
        YamlConfiguration configuration = new YamlConfiguration();
        if (InventoryUtils.loadAllTagsFromNBT((ConfigurationSection)configuration, item)) {
            player.sendMessage(ChatColor.YELLOW + " ---- EXTRA DATA ---- ");
            String itemString = configuration.saveToString().replace('\u00a7', '&');
            player.sendMessage(itemString);
        }
        if ((itemData = this.api.getController().getItem(item)) != null) {
            player.sendMessage(ChatColor.AQUA + "Give with: " + ChatColor.GRAY + "/mgive " + ChatColor.YELLOW + itemData.getKey());
            double worth = itemData.getWorth();
            if (worth > 0.0) {
                player.sendMessage(ChatColor.AQUA + " Worth " + ChatColor.GREEN + worth);
            }
        }
        return true;
    }

    public boolean onItemExport(Player player, ItemStack item, String[] parameters) {
        if (parameters.length == 0) {
            player.sendMessage(ChatColor.RED + "Usage: /mitem export filename");
            return true;
        }
        PlayerInventory inventory = player.getInventory();
        int itemSlot = inventory.getHeldItemSlot();
        TreeMap<String, MaterialAndData> items = new TreeMap<String, MaterialAndData>();
        VaultController vault = VaultController.getInstance();
        block11: for (Material material : Material.values()) {
            ItemStack testItem = new ItemStack(material, 1);
            inventory.setItem(itemSlot, testItem);
            ItemStack setItem = inventory.getItem(itemSlot);
            if (setItem == null || setItem.getType() != testItem.getType()) {
                player.sendMessage("Skipped: " + material.name());
                continue;
            }
            MaterialAndData mat = new MaterialAndData(material);
            items.put(mat.getKey(), mat);
            String baseName = mat.getName();
            for (short data = 1; data < 32; data = (short)(data + 1)) {
                String testVaultName;
                testItem = new ItemStack(material, 1, data);
                inventory.setItem(itemSlot, testItem);
                setItem = inventory.getItem(itemSlot);
                if (setItem == null || setItem.getType() != testItem.getType() || setItem.getDurability() != testItem.getDurability() || (mat = new MaterialAndData(material, data)).getName().equals(baseName) || (testVaultName = vault.getItemName(material, data)) == null || testVaultName.isEmpty()) continue block11;
                items.put(mat.getKey(), mat);
            }
        }
        File file = new File(this.api.getPlugin().getDataFolder(), parameters[0] + ".csv");
        try (FileWriter output = new FileWriter(file);){
            output.append("Name,Key,Cost\n");
            for (MaterialAndData material : items.values()) {
                Double worth = this.api.getController().getWorth(material.getItemStack(1));
                String worthString = worth == null ? "" : worth.toString();
                output.append(material.getName() + "," + material.getKey() + "," + worthString + "\n");
            }
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Error exporting data: " + ex.getMessage());
            ex.printStackTrace();
        }
        inventory.setItem(itemSlot, item);
        return true;
    }

    public boolean onItemSerialize(Player player, ItemStack item) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("item", (Object)item);
        String itemString = configuration.saveToString().replace("item:", "").replace('\u00a7', '&');
        player.sendMessage(itemString);
        return true;
    }

    public boolean onItemWorth(Player player, ItemStack item) {
        MageController controller = this.api.getController();
        Double worth = controller.getWorth(item);
        if (worth == null) {
            player.sendMessage(ChatColor.RED + "No worth defined for that item");
            return true;
        }
        String worthDescription = null;
        VaultController vault = VaultController.getInstance();
        int amount = item.getAmount();
        double totalWorth = worth * (double)amount;
        if (VaultController.hasEconomy()) {
            worthDescription = vault.format(totalWorth);
            if (amount > 1) {
                worthDescription = worthDescription + ChatColor.WHITE + " (" + ChatColor.GOLD + vault.format(worth) + ChatColor.WHITE + " each)";
            }
        } else {
            worthDescription = Double.toString(totalWorth);
            if (amount > 1) {
                worthDescription = worthDescription + ChatColor.WHITE + " (" + ChatColor.GOLD + Double.toString(worth) + ChatColor.WHITE + " each)";
            }
        }
        player.sendMessage("That item is worth " + ChatColor.GOLD + worthDescription);
        return true;
    }

    public boolean onItemDuplicate(Player player, ItemStack item) {
        ItemStack newItem = InventoryUtils.getCopy(item);
        this.api.giveItemToPlayer(player, newItem);
        player.sendMessage(this.api.getMessages().get("item.duplicated"));
        return true;
    }

    public boolean onItemSkull(Player player, ItemStack item) {
        ItemStack skullItem;
        if (item.getType() != Material.BOOK_AND_QUILL) {
            player.sendMessage(this.api.getMessages().get("item.skull_no_book"));
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !(meta instanceof BookMeta)) {
            player.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
            return true;
        }
        BookMeta bookMeta = (BookMeta)meta;
        List pages = bookMeta.getPages();
        if (pages.isEmpty()) {
            player.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
            return true;
        }
        String pageText = (String)pages.get(0);
        try {
            String decoded = Base64Coder.decodeString(pageText);
            if (decoded == null || decoded.isEmpty()) {
                player.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
                return true;
            }
            String url = decoded.replace("\"", "").replace("{textures:{SKIN:{url:", "").replace("}}}", "").trim();
            skullItem = InventoryUtils.getURLSkull(url);
            if (skullItem == null) {
                player.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
                return true;
            }
        }
        catch (Exception ex) {
            player.sendMessage(this.api.getMessages().get("item.skull_invalid_book"));
            return true;
        }
        if (pages.size() > 1) {
            String secondPageText = (String)pages.get(1);
            String[] pieces = StringUtils.split((String)(secondPageText = secondPageText.replace("\u00a70", "")), (char)'\n');
            if (pieces.length > 0) {
                ItemMeta skullMeta = skullItem.getItemMeta();
                skullMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)pieces[0]));
                if (pieces.length > 1) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (int i = 1; i < pieces.length; ++i) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)pieces[i]));
                    }
                    skullMeta.setLore(lore);
                }
                skullItem.setItemMeta(skullMeta);
            }
        }
        player.sendMessage(this.api.getMessages().get("item.skull"));
        player.getInventory().setItemInMainHand(skullItem);
        return true;
    }

    protected boolean checkItem(Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            player.sendMessage(this.api.getMessages().get("item.no_item"));
            return false;
        }
        return true;
    }

    public boolean onItemDelete(CommandSender sender, String itemKey) {
        Player player;
        MageController controller = this.api.getController();
        ItemData existing = controller.getItem(itemKey);
        if (existing == null) {
            sender.sendMessage(ChatColor.RED + "Unknown item: " + itemKey);
            return true;
        }
        boolean hasPermission = true;
        if (sender instanceof Player && !(player = (Player)sender).hasPermission("Magic.item.overwrite")) {
            String creatorId;
            hasPermission = player.hasPermission("Magic.item.overwrite_own") ? (creatorId = existing.getCreatorId()) != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString()) : false;
        }
        if (!hasPermission) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to delete " + itemKey);
            return true;
        }
        File itemFolder = new File(controller.getConfigFolder(), "items");
        File itemFile = new File(itemFolder, itemKey + ".yml");
        if (!itemFile.exists()) {
            sender.sendMessage(ChatColor.RED + "File doesn't exist: " + itemFile.getName());
            return true;
        }
        itemFile.delete();
        controller.unloadItemTemplate(itemKey);
        sender.sendMessage("Deleted item " + itemKey);
        return true;
    }

    public boolean onItemSave(Player player, ItemStack item, String[] parameters) {
        String template;
        if (parameters.length < 1) {
            player.sendMessage("Use: /mitem save <filename> [worth]");
            return true;
        }
        MageController controller = this.api.getController();
        ItemData existing = controller.getItem(template = parameters[0]);
        if (existing != null && !player.hasPermission("Magic.item.overwrite")) {
            boolean isCreator;
            String creatorId = existing.getCreatorId();
            boolean bl = isCreator = creatorId != null && creatorId.equalsIgnoreCase(player.getUniqueId().toString());
            if (!player.hasPermission("Magic.item.overwrite_own") || !isCreator) {
                player.sendMessage(ChatColor.RED + "The " + template + " item already exists and you don't have permission to overwrite it.");
                return true;
            }
        }
        double worth = 0.0;
        if (parameters.length > 1) {
            try {
                worth = Double.parseDouble(parameters[1]);
            }
            catch (Exception ex) {
                player.sendMessage("Use: /mitem save <filename> [worth]");
                return true;
            }
        } else if (existing != null) {
            worth = existing.getWorth();
        }
        item.setAmount(1);
        YamlConfiguration itemConfig = new YamlConfiguration();
        ConfigurationSection itemSection = itemConfig.createSection(template);
        itemSection.set("creator_id", (Object)player.getUniqueId().toString());
        itemSection.set("creator", (Object)player.getName());
        itemSection.set("worth", (Object)worth);
        itemSection.set("item", (Object)item);
        File itemFolder = new File(controller.getConfigFolder(), "items");
        File itemFile = new File(itemFolder, template + ".yml");
        itemFolder.mkdirs();
        try {
            itemConfig.save(itemFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            player.sendMessage(ChatColor.RED + "Can't write to file " + itemFile.getName());
            return true;
        }
        controller.loadItemTemplate(template, itemSection);
        player.sendMessage(ChatColor.WHITE + "Item saved as " + ChatColor.GOLD + template + " worth " + ChatColor.GREEN + worth);
        if (existing != null) {
            player.sendMessage(ChatColor.YELLOW + " Replaced Worth " + ChatColor.DARK_GREEN + existing.getWorth());
        }
        return true;
    }

    public boolean onItemName(Player player, ItemStack item, String[] parameters) {
        String displayName = null;
        if (parameters.length < 1) {
            player.sendMessage(this.api.getMessages().get("item.rename_clear"));
        } else {
            displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.join((Object[])parameters, (String)" "));
            player.sendMessage(this.api.getMessages().get("item.renamed"));
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(displayName);
        item.setItemMeta(meta);
        return true;
    }

    public boolean onItemAddFlag(Player player, ItemStack item, String flagName) {
        ItemFlag flag = null;
        try {
            flag = ItemFlag.valueOf((String)flagName.toUpperCase());
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Invalid flag: " + ChatColor.WHITE + flagName);
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{flag});
        item.setItemMeta(itemMeta);
        player.sendMessage(this.api.getMessages().get("item.flag_added").replace("$flag", flag.name()));
        return true;
    }

    public boolean onItemRemoveFlag(Player player, ItemStack item, String flagName) {
        ItemFlag flag = null;
        ItemMeta itemMeta = item.getItemMeta();
        if (flagName == null) {
            Set flags = itemMeta.getItemFlags();
            if (flags == null || flags.size() == 0) {
                player.sendMessage(this.api.getMessages().get("item.no_flags"));
                return true;
            }
            flag = (ItemFlag)flags.iterator().next();
        } else {
            try {
                flag = ItemFlag.valueOf((String)flagName.toUpperCase());
            }
            catch (Exception ex) {
                player.sendMessage(ChatColor.RED + "Invalid flag: " + ChatColor.WHITE + flagName);
                return true;
            }
        }
        if (!itemMeta.hasItemFlag(flag)) {
            player.sendMessage(this.api.getMessages().get("item.no_flag").replace("$flag", flag.name()));
        } else {
            itemMeta.removeItemFlags(new ItemFlag[]{flag});
            item.setItemMeta(itemMeta);
            player.sendMessage(this.api.getMessages().get("item.flag_removed").replace("$flag", flag.name()));
        }
        return true;
    }

    public boolean onItemAddEnchant(Player player, ItemStack item, String enchantName, String enchantValue) {
        boolean allowUnsafe;
        Enchantment enchantment = null;
        try {
            enchantment = Enchantment.getByName((String)enchantName.toUpperCase());
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Invalid enchantment: " + ChatColor.WHITE + enchantName);
            return true;
        }
        if (enchantment == null) {
            player.sendMessage(ChatColor.RED + "Invalid enchantment: " + ChatColor.WHITE + enchantName);
            return true;
        }
        int level = 0;
        try {
            level = Integer.parseInt(enchantValue);
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Invalid enchantment level: " + ChatColor.WHITE + enchantValue);
            return true;
        }
        if (!(player.hasPermission("Magic.item.enchant.extreme") || level >= 0 && level <= 10)) {
            player.sendMessage(ChatColor.RED + "Invalid enchantment level: " + ChatColor.WHITE + enchantValue);
            return true;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.addEnchant(enchantment, level, allowUnsafe = player.hasPermission("Magic.item.enchant.unsafe"))) {
            item.setItemMeta(itemMeta);
            player.sendMessage(this.api.getMessages().get("item.enchant_added").replace("$enchant", enchantment.getName()));
        } else if (!allowUnsafe && level > 5) {
            player.sendMessage(this.api.getMessages().get("item.enchant_unsafe"));
        } else {
            player.sendMessage(this.api.getMessages().get("item.enchant_not_added").replace("$enchant", enchantment.getName()));
        }
        return true;
    }

    public boolean onItemRemoveEnchant(Player player, ItemStack item, String enchantName) {
        Enchantment enchantment = null;
        ItemMeta itemMeta = item.getItemMeta();
        if (enchantName == null) {
            Map enchants = itemMeta.getEnchants();
            if (enchants == null || enchants.size() == 0) {
                player.sendMessage(this.api.getMessages().get("item.no_enchants"));
                return true;
            }
            enchantment = (Enchantment)enchants.keySet().iterator().next();
        } else {
            try {
                enchantment = Enchantment.getByName((String)enchantName.toUpperCase());
            }
            catch (Exception ex) {
                player.sendMessage(ChatColor.RED + "Invalid enchantment: " + ChatColor.WHITE + enchantName);
                return true;
            }
            if (enchantment == null) {
                player.sendMessage(ChatColor.RED + "Invalid enchantment: " + ChatColor.WHITE + enchantName);
                return true;
            }
        }
        if (!itemMeta.hasEnchant(enchantment)) {
            player.sendMessage(this.api.getMessages().get("item.no_enchant").replace("$enchant", enchantment.getName()));
        } else {
            itemMeta.removeEnchant(enchantment);
            item.setItemMeta(itemMeta);
            player.sendMessage(this.api.getMessages().get("item.enchant_removed").replace("$enchant", enchantment.getName()));
        }
        return true;
    }

    public boolean onItemAddAttribute(Player player, ItemStack item, String attributeName, String attributeValue, String attributeSlot) {
        Attribute attribute = null;
        if (attributeName == null) {
            return false;
        }
        try {
            attribute = Attribute.valueOf((String)attributeName.toUpperCase());
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Invalid attribute: " + ChatColor.WHITE + attributeName);
            return true;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(attributeValue);
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Invalid attribute value: " + ChatColor.WHITE + attributeValue);
            return true;
        }
        if (CompatibilityUtils.setItemAttribute(item, attribute, value, attributeSlot)) {
            if (attributeSlot == null) {
                attributeSlot = "(All Slots)";
            }
            player.sendMessage(this.api.getMessages().get("item.attribute_added").replace("$attribute", attribute.name()).replace("$value", Double.toString(value)).replace("$slot", attributeSlot));
        } else {
            player.sendMessage(this.api.getMessages().get("item.attribute_not_added").replace("$attribute", attribute.name()));
        }
        return true;
    }

    public boolean onItemRemoveAttribute(Player player, ItemStack item, String attributeName) {
        Attribute attribute = null;
        if (attributeName == null) {
            return false;
        }
        try {
            attribute = Attribute.valueOf((String)attributeName.toUpperCase());
        }
        catch (Exception ex) {
            player.sendMessage(ChatColor.RED + "Invalid attribute: " + ChatColor.WHITE + attributeName);
            return true;
        }
        if (!CompatibilityUtils.removeItemAttribute(item, attribute)) {
            player.sendMessage(this.api.getMessages().get("item.no_attribute").replace("$attribute", attribute.name()));
        } else {
            player.sendMessage(this.api.getMessages().get("item.attribute_removed").replace("$attribute", attribute.name()));
        }
        return true;
    }

    public boolean onItemAddUnplaceable(Player player, ItemStack item) {
        if (InventoryUtils.isUnplaceable(item)) {
            player.sendMessage(this.api.getMessages().get("item.already_unplaceable"));
        } else {
            ItemStack newItem = InventoryUtils.makeReal(item);
            InventoryUtils.makeUnplaceable(newItem);
            item.setItemMeta(newItem.getItemMeta());
            player.sendMessage(this.api.getMessages().get("item.add_unplaceable"));
        }
        return true;
    }

    public boolean onItemRemoveUnplaceable(Player player, ItemStack item) {
        if (!InventoryUtils.isUnplaceable(item)) {
            player.sendMessage(this.api.getMessages().get("item.not_unplaceable"));
        } else {
            InventoryUtils.removeUnplaceable(item);
            player.sendMessage(this.api.getMessages().get("item.remove_unplaceable"));
        }
        return true;
    }

    public boolean onItemAddUnbreakable(Player player, ItemStack item) {
        if (InventoryUtils.isUnbreakable(item)) {
            player.sendMessage(this.api.getMessages().get("item.already_unbreakable"));
        } else {
            ItemStack newItem = InventoryUtils.makeReal(item);
            InventoryUtils.makeUnbreakable(newItem);
            item.setItemMeta(newItem.getItemMeta());
            player.sendMessage(this.api.getMessages().get("item.add_unbreakable"));
        }
        return true;
    }

    public boolean onItemRemoveUnbreakable(Player player, ItemStack item) {
        if (!InventoryUtils.isUnbreakable(item)) {
            player.sendMessage(this.api.getMessages().get("item.not_unbreakable"));
        } else {
            InventoryUtils.removeUnbreakable(item);
            player.sendMessage(this.api.getMessages().get("item.remove_unbreakable"));
        }
        return true;
    }

    public boolean onItemAddLore(Player player, ItemStack item, String loreLine) {
        ItemMeta itemMeta = item.getItemMeta();
        ArrayList<String> lore = itemMeta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(loreLine);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        player.sendMessage(this.api.getMessages().get("item.lore_added").replace("$lore", loreLine));
        return true;
    }

    public boolean onItemRemoveLore(Player player, ItemStack item, String loreIndex) {
        ItemMeta itemMeta = item.getItemMeta();
        List lore = itemMeta.getLore();
        if (lore == null || lore.isEmpty()) {
            player.sendMessage(this.api.getMessages().get("item.no_lore"));
            return true;
        }
        int index = 0;
        if (loreIndex != null) {
            try {
                index = Integer.parseInt(loreIndex);
            }
            catch (Exception ex) {
                player.sendMessage(ChatColor.RED + "Invalid lore line: " + loreIndex);
                return true;
            }
        }
        if (index < 0 || index >= lore.size()) {
            player.sendMessage(ChatColor.RED + "Invalid lore line: " + loreIndex);
            return true;
        }
        String line = (String)lore.remove(index);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        player.sendMessage(this.api.getMessages().get("item.lore_removed").replace("$lore", line));
        return true;
    }

    public boolean onItemType(Player player, ItemStack item, String[] parameters) {
        if (parameters.length < 1) {
            return false;
        }
        String materialKey = parameters[0];
        MaterialAndData material = new MaterialAndData(materialKey);
        if (!material.isValid() || material.getMaterial() == Material.AIR) {
            player.sendMessage(ChatColor.RED + "Invalid material key: " + ChatColor.DARK_RED + materialKey);
            return true;
        }
        material.applyToItem(item);
        return true;
    }

    public boolean onItemAdd(Player player, ItemStack item, String[] parameters) {
        if (parameters.length < 1) {
            return false;
        }
        String addCommand = parameters[0];
        if (addCommand.equalsIgnoreCase("unbreakable")) {
            return this.onItemAddUnbreakable(player, item);
        }
        if (addCommand.equalsIgnoreCase("unplaceable")) {
            return this.onItemAddUnplaceable(player, item);
        }
        if (parameters.length < 2) {
            return false;
        }
        if (addCommand.equalsIgnoreCase("flag")) {
            return this.onItemAddFlag(player, item, parameters[1]);
        }
        if (addCommand.equalsIgnoreCase("lore")) {
            Object[] loreLines = Arrays.copyOfRange(parameters, 1, parameters.length);
            String loreLine = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.join((Object[])loreLines, (String)" "));
            return this.onItemAddLore(player, item, loreLine);
        }
        if (parameters.length < 3) {
            return false;
        }
        if (addCommand.equalsIgnoreCase("enchant")) {
            return this.onItemAddEnchant(player, item, parameters[1], parameters[2]);
        }
        if (addCommand.equalsIgnoreCase("attribute")) {
            String slot = parameters.length > 3 ? parameters[3] : null;
            return this.onItemAddAttribute(player, item, parameters[1], parameters[2], slot);
        }
        return false;
    }

    public boolean onItemDestroy(Player player) {
        player.getInventory().setItemInMainHand(null);
        player.sendMessage(this.api.getMessages().get("item.destroyed"));
        return true;
    }

    public boolean onItemRemove(Player player, ItemStack item, String[] parameters) {
        String firstParameter;
        if (parameters.length < 1) {
            return false;
        }
        String removeCommand = parameters[0];
        if (removeCommand.equalsIgnoreCase("unbreakable")) {
            return this.onItemRemoveUnbreakable(player, item);
        }
        if (removeCommand.equalsIgnoreCase("unplaceable")) {
            return this.onItemRemoveUnplaceable(player, item);
        }
        String string = firstParameter = parameters.length > 1 ? parameters[1] : null;
        if (removeCommand.equalsIgnoreCase("flag")) {
            return this.onItemRemoveFlag(player, item, firstParameter);
        }
        if (removeCommand.equalsIgnoreCase("lore")) {
            return this.onItemRemoveLore(player, item, firstParameter);
        }
        if (removeCommand.equalsIgnoreCase("enchant")) {
            return this.onItemRemoveEnchant(player, item, firstParameter);
        }
        if (removeCommand.equalsIgnoreCase("attribute")) {
            return this.onItemRemoveAttribute(player, item, firstParameter);
        }
        return false;
    }
}

