/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicProperties;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.NumberConversions;

public class BaseMagicProperties
implements MagicProperties {
    @Nonnull
    protected final MagicController controller;
    private ConfigurationSection configuration = new MemoryConfiguration();
    private ConfigurationSection effectiveConfiguration = new MemoryConfiguration();
    private BaseMagicProperties parent;
    private boolean dirty = false;

    protected BaseMagicProperties(MageController controller) {
        Preconditions.checkArgument((boolean)(controller instanceof MagicController));
        this.controller = (MagicController)controller;
    }

    public void setProperty(String key, Object value) {
        this.configuration.set(key, value);
        this.dirty = true;
    }

    private void rebuildEffectiveConfiguration() {
        if (this.dirty) {
            this.effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.configuration);
            if (this.parent != null) {
                ConfigurationSection parentConfiguration = this.parent.getEffectiveConfiguration();
                ConfigurationUtils.addConfigurations(this.effectiveConfiguration, parentConfiguration, false);
            }
            this.dirty = false;
        }
    }

    public void load(ConfigurationSection configuration) {
        this.configuration = ConfigurationUtils.cloneConfiguration(configuration);
        this.dirty = true;
    }

    @Override
    public Object getProperty(String key) {
        this.rebuildEffectiveConfiguration();
        return this.effectiveConfiguration.get(key);
    }

    @Override
    @Nonnull
    public <T> T getProperty(@Nonnull String key, @Nonnull T defaultValue) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
        this.rebuildEffectiveConfiguration();
        Object value = this.effectiveConfiguration.get(key);
        if (value == null || !defaultValue.getClass().isAssignableFrom(value.getClass())) {
            return defaultValue;
        }
        return (T)value;
    }

    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    public ConfigurationSection getEffectiveConfiguration() {
        this.rebuildEffectiveConfiguration();
        return this.effectiveConfiguration;
    }

    public void setParent(BaseMagicProperties properties) {
        this.parent = properties;
        this.dirty = true;
    }

    public void clear() {
        this.configuration = new MemoryConfiguration();
        this.effectiveConfiguration = new MemoryConfiguration();
        this.parent = null;
        this.dirty = false;
    }

    public void configure(ConfigurationSection configuration) {
        ConfigurationUtils.addConfigurations(this.configuration, configuration);
        this.dirty = true;
    }

    protected boolean upgradeProperty(String key, Object value) {
        return this.upgradeProperty(key, value, false);
    }

    protected boolean upgradeProperty(String key, Object value, boolean force) {
        Object currentValue = this.getEffectiveConfiguration().get(key);
        if (currentValue == value) {
            return false;
        }
        if (currentValue != null && value != null && !force) {
            if (currentValue.equals(value)) {
                return false;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                String stringCurrent = (String)currentValue;
                if (stringValue.equalsIgnoreCase(stringCurrent)) {
                    return false;
                }
            } else if (value instanceof Number) {
                float floatValue = NumberConversions.toFloat((Object)value);
                float floatCurrent = NumberConversions.toFloat((Object)currentValue);
                if (floatCurrent >= floatValue) {
                    return false;
                }
            }
        }
        this.sendDebug("Upgraded property: " + key);
        if (value != null && value instanceof Number) {
            this.sendAddMessage("upgraded_property", this.controller.getMessages().getLevelString("wand." + key, NumberConversions.toFloat((Object)value)));
        }
        this.sendMessage(key + "_usage");
        this.setProperty(key, value);
        return true;
    }

    protected void addPotionEffects(Map<PotionEffectType, Integer> effects, String effectsString) {
        String[] effectStrings;
        if (effectsString == null || effectsString.isEmpty()) {
            return;
        }
        effectsString = effectsString.replaceAll("[\\]\\[]", "");
        for (String effectString : effectStrings = StringUtils.split((String)effectsString, (char)',')) {
            try {
                PotionEffectType type;
                effectString = effectString.trim();
                int power = 0;
                if (effectString.contains(":")) {
                    String[] pieces = StringUtils.split((String)effectString, (char)':');
                    type = PotionEffectType.getByName((String)pieces[0].toUpperCase());
                    power = Integer.parseInt(pieces[1]);
                } else {
                    type = PotionEffectType.getByName((String)effectString.toUpperCase());
                }
                if (type == null) {
                    throw new Exception("Invalid potion effect");
                }
                Integer existing = effects.get(type);
                if (existing != null && existing >= power) continue;
                effects.put(type, power);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Invalid potion effect: " + effectString);
            }
        }
    }

    protected static String getPotionEffectString(Map<PotionEffectType, Integer> potionEffects) {
        if (potionEffects.size() == 0) {
            return null;
        }
        ArrayList<String> effectStrings = new ArrayList<String>();
        for (Map.Entry<PotionEffectType, Integer> entry : potionEffects.entrySet()) {
            String effectString = entry.getKey().getName();
            if (entry.getValue() > 0) {
                effectString = effectString + ":" + entry.getValue();
            }
            effectStrings.add(effectString);
        }
        return StringUtils.join(effectStrings, (String)",");
    }

    protected String describePotionEffect(PotionEffectType effect, int level) {
        String effectName = effect.getName();
        String effectFirst = effectName.substring(0, 1);
        effectName = effectName.substring(1).toLowerCase().replace("_", " ");
        effectName = effectFirst + effectName;
        return this.controller.getMessages().getLevelString("wand.potion_effect", level, 5.0f).replace("$effect", effectName);
    }

    protected boolean upgradePotionEffects(String key, Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        boolean modified = false;
        String currentValue = this.getEffectiveConfiguration().getString(key);
        HashMap<PotionEffectType, Integer> currentEffects = new HashMap<PotionEffectType, Integer>();
        HashMap<PotionEffectType, Integer> newEffects = new HashMap<PotionEffectType, Integer>();
        this.addPotionEffects(currentEffects, currentValue);
        this.addPotionEffects(newEffects, (String)value);
        for (Map.Entry otherEffects : newEffects.entrySet()) {
            Integer current = (Integer)currentEffects.get(otherEffects.getKey());
            if (current != null && current >= (Integer)otherEffects.getValue()) continue;
            currentEffects.put((PotionEffectType)otherEffects.getKey(), (Integer)otherEffects.getValue());
            this.sendAddMessage("upgraded_property", this.describePotionEffect((PotionEffectType)otherEffects.getKey(), (Integer)otherEffects.getValue()));
            this.sendDebug("Added potion effect: " + otherEffects.getKey());
            modified = true;
        }
        if (modified) {
            this.setProperty("potion_effects", BaseMagicProperties.getPotionEffectString(currentEffects));
        }
        return modified;
    }

    protected void sendDebug(String debugMessage) {
    }

    protected void sendMessage(String messageKey) {
    }

    protected void sendAddMessage(String messageKey, String nameParam) {
        String message = this.getMessage(messageKey).replace("$name", nameParam);
        this.sendMessage(message);
    }

    protected String getMessage(String messageKey) {
        return this.getMessage(messageKey, "");
    }

    protected String getMessage(String messageKey, String defaultValue) {
        return this.controller.getMessages().get(messageKey, defaultValue);
    }

    protected boolean organizeInventory() {
        return false;
    }

    protected boolean alphabetizeInventory() {
        return false;
    }

    public boolean addBrush(String materialKey) {
        return false;
    }

    public boolean upgradeBrushes(Object value) {
        if (!(value instanceof String) && !(value instanceof List)) {
            return false;
        }
        boolean modified = false;
        List<String> materials = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value))) : (List<String>)value;
        for (String materialKey : materials) {
            if (!this.addBrush(materialKey = StringUtils.split((String)materialKey, (char)'@')[0].trim())) continue;
            modified = true;
            this.sendDebug("Added brush: " + materialKey);
        }
        return modified;
    }

    public boolean addOverride(String key, String value) {
        return false;
    }

    public boolean upgradeOverrides(Object value) {
        boolean modified = false;
        List<String> overrides = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        HashSet<String> upgradedSpells = new HashSet<String>();
        for (String override : overrides) {
            String[] pairs = StringUtils.split((String)(override = override.replace("\\|", ",")), (char)' ');
            if (pairs.length <= 1 || !this.addOverride(pairs[0], pairs[1])) continue;
            this.sendDebug("Added override: " + pairs[0] + " " + pairs[1]);
            String[] pieces = StringUtils.split((String)pairs[0], (char)'.');
            if (pieces.length > 1 && !upgradedSpells.contains(pieces[0])) {
                upgradedSpells.add(pieces[0]);
                SpellTemplate spell = this.controller.getSpellTemplate(pieces[0]);
                if (spell != null) {
                    this.sendAddMessage("spell_override_upgraded", spell.getName());
                }
            }
            modified = true;
        }
        return modified;
    }

    public boolean addSpell(String spellKey) {
        return false;
    }

    public boolean upgradeSpells(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        boolean modified = false;
        List<String> spells = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value))) : (List<String>)value;
        for (String spellKey : spells) {
            if (!this.addSpell(spellKey = StringUtils.split((String)spellKey, (char)'@')[0].trim())) continue;
            modified = true;
            this.sendDebug("Added spell: " + spellKey);
        }
        return modified;
    }

    public boolean upgrade(ConfigurationSection configuration) {
        boolean modified = false;
        Set keys = configuration.getKeys(false);
        block23: for (String key : keys) {
            Object value = configuration.get(key);
            switch (key) {
                case "quiet": {
                    modified = this.upgradeProperty(key, value, true) || modified;
                    continue block23;
                }
                case "potion_effects": {
                    modified = this.upgradePotionEffects(key, value);
                    continue block23;
                }
                case "mana": 
                case "mana_regeneration": 
                case "mana_max": 
                case "mana_per_damage": {
                    double costReduction = this.getEffectiveConfiguration().getDouble("cost_reduction", 0.0);
                    if (!(costReduction <= 1.0)) continue block23;
                    modified = this.upgradeProperty(key, value) || modified;
                    continue block23;
                }
                case "organize": {
                    if (!this.organizeInventory()) continue block23;
                    modified = true;
                    this.sendMessage(this.getMessage("reorganized"));
                    continue block23;
                }
                case "alphabetize": {
                    if (!this.alphabetizeInventory()) continue block23;
                    modified = true;
                    this.sendMessage(this.getMessage("alphabetized"));
                    continue block23;
                }
                case "spells": {
                    modified = this.upgradeSpells(value) || modified;
                    continue block23;
                }
                case "materials": {
                    modified = this.upgradeBrushes(value) || modified;
                    continue block23;
                }
                case "overrides": {
                    modified = this.upgradeOverrides(value) || modified;
                    continue block23;
                }
            }
            modified = this.upgradeProperty(key, value) || modified;
        }
        this.dirty = this.dirty || modified;
        return modified;
    }
}

