/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class MountArmorStandAction
extends BaseSpellAction {
    private boolean armorStandInvisible;
    private boolean armorStandSmall;
    private boolean armorStandMarker;
    private boolean armorStandGravity;
    private boolean mountWand;
    private double armorStandPitch = 0.0;
    private double armorStandYaw = 0.0;
    private double moveDistance = 0.0;
    private double startSpeed = 0.0;
    private double minSpeed = 0.0;
    private double maxSpeed = 0.0;
    private double maxAcceleration = 0.0;
    private double maxDeceleration = 0.0;
    private double liftoffThrust = 0.0;
    private double crashDistance = 0.0;
    private int duration = 0;
    private int durationWarning = 0;
    private int liftoffDuration = 0;
    private int maxHeightAboveGround;
    private int maxHeight;
    private double pitchOffset = 0.0;
    private CreatureSpawnEvent.SpawnReason armorStandSpawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
    private Collection<PotionEffect> crashEffects;
    private Collection<PotionEffect> warningEffects;
    private SoundEffect sound = null;
    private int soundInterval = 1000;
    private float soundMaxVolume = 1.0f;
    private float soundMinVolume = 1.0f;
    private float soundMaxPitch = 1.0f;
    private float soundMinPitch = 1.0f;
    private ItemStack item;
    private int slotNumber;
    private long liftoffTime;
    private ArmorStand armorStand;
    private Vector direction;
    private double speed;
    private boolean mounted;
    private boolean warningEffectsApplied;
    private long nextSoundPlay;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.crashEffects = ConfigurationUtils.getPotionEffects(parameters.getConfigurationSection("crash_effects"));
        this.durationWarning = parameters.getInt("duration_warning", 0);
        this.warningEffects = ConfigurationUtils.getPotionEffects(parameters.getConfigurationSection("warning_effects"), this.durationWarning);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.mounted = false;
        this.item = null;
        if (this.armorStand != null) {
            this.armorStand.remove();
        }
        this.armorStand = null;
        this.warningEffectsApplied = false;
        this.nextSoundPlay = 0L;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.armorStandInvisible = parameters.getBoolean("armor_stand_invisible", true);
        this.armorStandSmall = parameters.getBoolean("armor_stand_small", false);
        this.armorStandMarker = parameters.getBoolean("armor_stand_marker", true);
        this.armorStandGravity = parameters.getBoolean("armor_stand_gravity", true);
        this.armorStandPitch = parameters.getDouble("armor_stand_pitch", 0.3);
        this.armorStandYaw = ConfigurationUtils.getDouble(parameters, "armor_stand_yaw", 0.0);
        this.moveDistance = parameters.getDouble("steer_speed", 0.0);
        this.startSpeed = parameters.getDouble("start_speed", 0.0);
        this.minSpeed = parameters.getDouble("min_speed", 0.0);
        this.maxSpeed = parameters.getDouble("max_speed", 0.0);
        this.maxAcceleration = parameters.getDouble("max_acceleration", 0.0);
        this.maxDeceleration = parameters.getDouble("max_deceleration", 0.0);
        this.liftoffThrust = parameters.getDouble("liftoff_thrust", 0.0);
        this.liftoffDuration = parameters.getInt("liftoff_duration", 0);
        this.crashDistance = parameters.getDouble("crash_distance", 0.0);
        this.mountWand = parameters.getBoolean("mount_wand", false);
        this.maxHeight = parameters.getInt("max_height", 0);
        this.maxHeightAboveGround = parameters.getInt("max_height_above_ground", 0);
        this.duration = parameters.getInt("duration", 0);
        this.durationWarning = parameters.getInt("duration_warning", 0);
        this.pitchOffset = parameters.getDouble("pitch_offset", 0.0);
        this.sound = null;
        String soundKey = parameters.getString("sound");
        if (soundKey != null && !soundKey.isEmpty()) {
            this.sound = new SoundEffect(soundKey);
        }
        this.soundInterval = parameters.getInt("sound_interval", 1000);
        this.soundMaxVolume = (float)parameters.getDouble("sound_volume", 1.0);
        this.soundMaxPitch = (float)parameters.getDouble("sound_pitch", 1.0);
        this.soundMinVolume = (float)parameters.getDouble("sound_volume", 1.0);
        this.soundMinPitch = (float)parameters.getDouble("sound_pitch", 1.0);
        this.soundMaxVolume = (float)parameters.getDouble("sound_max_volume", (double)this.soundMaxVolume);
        this.soundMaxPitch = (float)parameters.getDouble("sound_max_pitch", (double)this.soundMaxPitch);
        this.soundMinVolume = (float)parameters.getDouble("sound_min_volume", (double)this.soundMinVolume);
        this.soundMinPitch = (float)parameters.getDouble("sound_min_pitch", (double)this.soundMinPitch);
        if (parameters.contains("armor_stand_reason")) {
            String reasonText = parameters.getString("armor_stand_reason").toUpperCase();
            try {
                this.armorStandSpawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                context.getMage().sendMessage("Unknown spawn reason: " + reasonText);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (!this.mounted) {
            return this.mount(context);
        }
        Entity target = context.getTargetEntity();
        if (target == null) {
            return SpellResult.CAST;
        }
        Entity mount = target.getVehicle();
        if (mount == null || mount != this.armorStand) {
            return SpellResult.CAST;
        }
        if (!this.armorStand.isValid()) {
            this.armorStand.remove();
            if (!this.mountNewArmorStand(context)) {
                return SpellResult.FAIL;
            }
        }
        if (this.sound != null && this.nextSoundPlay < System.currentTimeMillis()) {
            this.nextSoundPlay = System.currentTimeMillis() + (long)this.soundInterval;
            double speedRatio = this.minSpeed >= this.maxSpeed ? 1.0 : (this.speed - this.minSpeed) / (this.maxSpeed - this.minSpeed);
            this.sound.setPitch((float)((double)(this.soundMaxPitch - this.soundMinPitch) * speedRatio));
            this.sound.setVolume((float)((double)(this.soundMaxVolume - this.soundMinVolume) * speedRatio));
            this.sound.play(context.getPlugin(), target);
        }
        if (this.crashDistance > 0.0) {
            Vector threshold = this.direction.clone().multiply(this.crashDistance);
            if (this.checkForCrash(context, target.getLocation(), threshold)) {
                this.crash(context);
                return SpellResult.CAST;
            }
        }
        if (!context.isPassthrough(target.getLocation().getBlock().getType())) {
            this.crash(context);
            return SpellResult.CAST;
        }
        this.adjustHeading(context);
        if (System.currentTimeMillis() > this.liftoffTime + (long)this.liftoffDuration) {
            this.applyThrust(context);
        }
        return SpellResult.PENDING;
    }

    protected void adjustHeading(CastContext context) {
        Location targetLocation = context.getTargetEntity().getLocation();
        Vector targetDirection = targetLocation.getDirection();
        if (this.moveDistance == 0.0) {
            this.direction = targetDirection;
        } else {
            double moveDistanceSquared = this.moveDistance * this.moveDistance;
            double distanceSquared = this.direction.distanceSquared(targetDirection);
            if (distanceSquared <= moveDistanceSquared) {
                this.direction = targetDirection;
            } else {
                targetDirection = targetDirection.subtract(this.direction).normalize().multiply(this.moveDistance);
                this.direction.add(targetDirection).normalize();
            }
        }
        float targetPitch = targetLocation.getPitch();
        targetLocation.setDirection(this.direction);
        CompatibilityUtils.setYawPitch((Entity)this.armorStand, targetLocation.getYaw() + (float)this.armorStandYaw, targetLocation.getPitch());
        if (this.armorStandPitch != 0.0) {
            this.armorStand.setHeadPose(new EulerAngle(this.armorStandPitch * (double)targetPitch / 180.0 * Math.PI, 0.0, 0.0));
        }
    }

    protected void applyThrust(CastContext context) {
        if (this.duration > 0) {
            long flightTime = System.currentTimeMillis() - this.liftoffTime;
            Entity targetEntity = context.getTargetEntity();
            if (!this.warningEffectsApplied && this.warningEffects != null && targetEntity instanceof LivingEntity && this.durationWarning > 0 && flightTime > (long)(this.duration - this.durationWarning)) {
                CompatibilityUtils.applyPotionEffects((LivingEntity)targetEntity, this.warningEffects);
                this.warningEffectsApplied = true;
            }
            if (flightTime > (long)this.duration) {
                return;
            }
        }
        if (this.direction.getY() < 0.0 && this.maxAcceleration > 0.0) {
            this.speed -= this.direction.getY() * this.maxAcceleration;
            if (this.maxSpeed > 0.0 && this.speed > this.maxSpeed) {
                this.speed = this.maxSpeed;
            }
        } else if (this.direction.getY() > 0.0 && this.maxDeceleration > 0.0) {
            this.speed -= this.direction.getY() * this.maxDeceleration;
            this.speed = Math.max(this.minSpeed, this.speed);
        }
        if (this.pitchOffset != 0.0) {
            this.direction.setY(this.direction.getY() + this.pitchOffset).normalize();
        }
        double blocksAbove = 0.0;
        Location currentLocation = context.getTargetEntity().getLocation();
        if (this.maxHeight > 0 && currentLocation.getY() >= (double)this.maxHeight) {
            blocksAbove = currentLocation.getY() - (double)this.maxHeight + 1.0;
        } else if (this.maxHeightAboveGround > 0) {
            int height;
            Block block = currentLocation.getBlock();
            for (height = 0; height < this.maxHeightAboveGround && context.isPassthrough(block.getType()); ++height) {
                block = block.getRelative(BlockFace.DOWN);
            }
            if (context.isPassthrough(block.getType())) {
                blocksAbove = height + 1;
            }
        }
        if (blocksAbove > 0.0 && this.direction.getY() > 0.0) {
            this.direction.setY(-blocksAbove / 5.0).normalize();
        }
        if (this.speed > 0.0) {
            this.armorStand.setVelocity(this.direction.multiply(this.speed));
        }
    }

    protected SpellResult mount(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        Entity entity = context.getTargetEntity();
        if (entity == null) {
            return SpellResult.NO_TARGET;
        }
        this.item = null;
        if (this.mountWand) {
            Wand activeWand = mage.getActiveWand();
            if (activeWand != context.getWand()) {
                return SpellResult.NO_TARGET;
            }
            if (activeWand != null) {
                activeWand.deactivate();
            }
            this.item = activeWand.getItem();
            if (this.item == null || this.item.getType() == Material.AIR) {
                return SpellResult.FAIL;
            }
            this.slotNumber = player.getInventory().getHeldItemSlot();
        }
        this.direction = entity.getLocation().getDirection();
        if (!this.mountNewArmorStand(context)) {
            return SpellResult.FAIL;
        }
        if (this.mountWand) {
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        }
        this.liftoffTime = System.currentTimeMillis();
        this.mounted = true;
        this.speed = this.startSpeed;
        if (this.liftoffThrust > 0.0) {
            this.armorStand.setVelocity(new Vector(0.0, this.liftoffThrust, 0.0));
        }
        if (this.sound != null) {
            this.nextSoundPlay = System.currentTimeMillis();
        }
        return SpellResult.PENDING;
    }

    protected boolean mountNewArmorStand(CastContext context) {
        Mage mage = context.getMage();
        Entity entity = context.getTargetEntity();
        this.armorStand = CompatibilityUtils.spawnArmorStand(mage.getLocation());
        if (this.armorStandInvisible) {
            CompatibilityUtils.setInvisible(this.armorStand, true);
        }
        if (this.armorStandMarker) {
            this.armorStand.setMarker(true);
        }
        if (!this.armorStandGravity) {
            this.armorStand.setGravity(false);
        }
        CompatibilityUtils.setDisabledSlots(this.armorStand, 0x1F1F00);
        if (this.armorStandSmall) {
            this.armorStand.setSmall(true);
        }
        MageController controller = context.getController();
        this.armorStand.setMetadata("notarget", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
        controller.setForceSpawn(true);
        try {
            CompatibilityUtils.addToWorld(entity.getWorld(), (Entity)this.armorStand, this.armorStandSpawnReason);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        controller.setForceSpawn(false);
        if (this.mountWand) {
            this.armorStand.setHelmet(this.item);
        }
        entity.eject();
        this.armorStand.setPassenger(entity);
        this.adjustHeading(context);
        return true;
    }

    @Override
    public void finish(CastContext context) {
        Mage mage;
        Player player;
        if (this.armorStand != null) {
            this.armorStand.removeMetadata("notarget", context.getPlugin());
            this.armorStand.remove();
            this.armorStand = null;
        }
        Entity targetEntity = context.getTargetEntity();
        if (this.warningEffectsApplied && this.warningEffects != null && targetEntity != null && targetEntity instanceof LivingEntity) {
            for (PotionEffect effect : this.warningEffects) {
                ((LivingEntity)targetEntity).removePotionEffect(effect.getType());
            }
        }
        if ((player = (mage = context.getMage()).getPlayer()) == null || this.item == null) {
            return;
        }
        ItemStack currentItem = player.getInventory().getItemInMainHand();
        if (currentItem == null || currentItem.getType() == Material.AIR) {
            player.getInventory().setItemInMainHand(this.item);
            mage.checkWand();
        } else {
            currentItem = player.getInventory().getItem(this.slotNumber);
            if (currentItem != null) {
                context.getMage().giveItem(this.item);
            } else {
                player.getInventory().setItem(this.slotNumber, this.item);
            }
        }
        this.item = null;
    }

    protected void crash(CastContext context) {
        context.sendMessageKey("crash");
        context.playEffects("crash");
        Entity targetEntity = context.getTargetEntity();
        if (this.crashEffects != null && targetEntity != null && this.crashEffects.size() > 0 && targetEntity instanceof LivingEntity) {
            CompatibilityUtils.applyPotionEffects((LivingEntity)targetEntity, this.crashEffects);
        }
        this.warningEffectsApplied = false;
    }

    protected boolean checkForCrash(CastContext context, Location source, Vector threshold) {
        Block facingBlock = source.getBlock();
        Block targetBlock = source.add(threshold).getBlock();
        return !targetBlock.equals(facingBlock) && !context.isPassthrough(targetBlock.getType());
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("armor_stand_invisible");
        parameters.add("armor_stand_small");
        parameters.add("armor_stand_marker");
        parameters.add("armor_stand_gravity");
        parameters.add("armor_stand_reason");
        parameters.add("armor_stand_pitch");
        parameters.add("armor_stand_yaw");
        parameters.add("steer_speed");
        parameters.add("liftoff_duration");
        parameters.add("liftoff_thrust");
        parameters.add("crash_distance");
        parameters.add("mount_wand");
        parameters.add("max_height");
        parameters.add("max_height_above_ground");
        parameters.add("duration");
        parameters.add("duration_warning");
        parameters.add("start_speed");
        parameters.add("min_speed");
        parameters.add("max_speed");
        parameters.add("max_acceleration");
        parameters.add("max_deceleration");
        parameters.add("pitch_offset");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("crash_distance") || parameterKey.equals("max_height") || parameterKey.equals("max_height_above_ground")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("armor_stand_invisible") || parameterKey.equals("armor_stand_marker") || parameterKey.equals("armor_stand_small") || parameterKey.equals("armor_stand_gravity") || parameterKey.equals("mount_wand")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("steer_speed") || parameterKey.equals("start_speed") || parameterKey.equals("armor_stand_pitch") || parameterKey.equals("armor_stand_yaw") || parameterKey.equals("min_speed") || parameterKey.equals("max_speed") || parameterKey.equals("max_acceleration") || parameterKey.equals("max_deceleration") || parameterKey.equals("pitch_offset") || parameterKey.equals("liftoff_thrust")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("liftoff_duration") || parameterKey.equals("duration") || parameterKey.equals("duration_warning")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("armor_stand_reason")) {
            for (CreatureSpawnEvent.SpawnReason reason : CreatureSpawnEvent.SpawnReason.values()) {
                examples.add(reason.name().toLowerCase());
            }
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

