/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.slikey.effectlib.util.ConfigUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemShopAction
extends BaseShopAction {
    private List<BaseShopAction.ShopItem> items = new ArrayList<BaseShopAction.ShopItem>();

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        block14: {
            super.initialize(spell, parameters);
            this.items.clear();
            if (!parameters.contains("items")) break block14;
            if (parameters.isConfigurationSection("items")) {
                ConfigurationSection itemSection = ConfigurationUtils.getConfigurationSection(parameters, "items");
                Set itemKeys = itemSection.getKeys(false);
                for (String itemKey : itemKeys) {
                    this.items.add(this.parseItemKey(spell.getController(), itemKey, itemSection.getDouble(itemKey, -1.0)));
                }
            } else {
                List itemList = parameters.getList("items");
                for (Object itemEntry : itemList) {
                    if (itemEntry instanceof String) {
                        String itemKey = (String)itemEntry;
                        this.items.add(this.parseItemKey(spell.getController(), itemKey, -1.0));
                        continue;
                    }
                    if (!(itemEntry instanceof ConfigurationSection) && !(itemEntry instanceof Map)) continue;
                    ConfigurationSection itemConfig = itemEntry instanceof ConfigurationSection ? (ConfigurationSection)itemEntry : ConfigUtils.toConfigurationSection((Map)itemEntry);
                    BaseShopAction.ShopItem shopItem = null;
                    if (itemConfig != null) {
                        double cost = itemConfig.getDouble("cost");
                        if (itemConfig.isString("item")) {
                            shopItem = this.parseItemKey(spell.getController(), itemConfig.getString("item"), cost);
                            if (shopItem != null) {
                                String name = itemConfig.getString("name");
                                List<String> lore = ConfigurationUtils.getStringList(itemConfig, "lore");
                                if (name != null || lore != null) {
                                    ItemStack item = shopItem.getItem();
                                    ItemMeta meta = item.getItemMeta();
                                    if (name != null) {
                                        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
                                    }
                                    if (lore != null) {
                                        ArrayList<String> translatedLore = new ArrayList<String>();
                                        for (String line : lore) {
                                            if (line == null) continue;
                                            translatedLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                                        }
                                        meta.setLore(translatedLore);
                                    }
                                    item.setItemMeta(meta);
                                }
                            }
                        } else {
                            ItemStack itemStack = itemConfig.getItemStack("item");
                            if (itemStack != null) {
                                shopItem = new BaseShopAction.ShopItem(itemStack, cost);
                            }
                        }
                    }
                    this.items.add(shopItem);
                }
            }
        }
    }

    protected BaseShopAction.ShopItem parseItemKey(MageController controller, String itemKey, double worth) {
        ItemStack item;
        if (itemKey == null || itemKey.isEmpty() || itemKey.equalsIgnoreCase("none")) {
            return null;
        }
        String[] pieces = StringUtils.split((String)itemKey, (char)'@');
        int amount = 1;
        if (pieces.length > 1) {
            itemKey = pieces[0];
            try {
                amount = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                this.context.getLogger().warning("Invalid item amount in shop: " + pieces[1] + " for item " + itemKey + " shop " + this.context.getSpell().getKey());
            }
        }
        if ((item = controller.createItem(itemKey, this.castsSpells)) == null) {
            return null;
        }
        if (this.showActiveIcons && controller.getAPI().isWand(item)) {
            Wand wand = controller.getWand(item);
            wand.getIcon().applyToItem(item);
        }
        item.setAmount(amount);
        if (worth < 0.0) {
            Double defaultWorth = controller.getWorth(item);
            worth = defaultWorth == null ? 0.0 : defaultWorth;
        }
        return new BaseShopAction.ShopItem(item, worth);
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpellResult contextResult = this.checkContext(context);
        if (!contextResult.isSuccess()) {
            return contextResult;
        }
        return this.showItems(context, this.items);
    }
}

