/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.CustomProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class EntityProjectileAction
extends CustomProjectileAction {
    private boolean noTarget = true;
    private boolean doTeleport = false;
    private boolean doVelocity = false;
    private boolean orient = false;
    private Vector velocityOffset;
    private Vector locationOffset;
    private EntityType entityType;
    protected CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
    private String customName;
    protected String variantName;
    boolean isBaby;
    protected Entity entity = null;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.doVelocity = parameters.getBoolean("apply_velocity", true);
        this.doTeleport = parameters.getBoolean("teleport", true);
        this.noTarget = parameters.getBoolean("no_target", true);
        this.orient = parameters.getBoolean("orient", true);
        this.velocityOffset = ConfigurationUtils.getVector(parameters, "velocity_offset");
        this.locationOffset = ConfigurationUtils.getVector(parameters, "location_offset");
        try {
            String entityTypeName = parameters.getString("type", "");
            if (!entityTypeName.isEmpty()) {
                this.entityType = EntityType.valueOf((String)entityTypeName.toUpperCase());
            }
        }
        catch (Exception ex) {
            this.entityType = null;
        }
        if (parameters.contains("spawn_reason")) {
            String reasonText = parameters.getString("spawn_reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                context.getMage().sendMessage("Unknown spawn reason: " + reasonText);
            }
        }
        this.customName = parameters.getString("name");
        this.isBaby = parameters.getBoolean("baby", false);
        this.variantName = parameters.getString("variant");
        if (this.variantName != null && this.variantName.isEmpty()) {
            this.variantName = null;
        }
    }

    protected Entity setEntity(MageController controller, Entity entity) {
        DyeColor color;
        this.entity = entity;
        if (this.noTarget) {
            entity.setMetadata("notarget", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
        }
        if (this.customName != null) {
            entity.setCustomName(this.customName);
            entity.setCustomNameVisible(true);
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).setMaxHealth(1000.0);
            ((LivingEntity)entity).setHealth(1000.0);
        }
        if (entity instanceof Slime) {
            ((Slime)entity).setSize(1);
        }
        if (entity instanceof Ageable) {
            if (this.isBaby) {
                ((Ageable)entity).setBaby();
            } else {
                ((Ageable)entity).setAdult();
            }
        } else if (entity instanceof Zombie) {
            ((Zombie)entity).setBaby(this.isBaby);
        } else if (entity instanceof PigZombie) {
            ((PigZombie)entity).setBaby(this.isBaby);
        } else if (entity instanceof Slime && this.isBaby) {
            Slime slime = (Slime)entity;
            slime.setSize(0);
        }
        if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            Ocelot.Type variant = Ocelot.Type.WILD_OCELOT;
            if (this.variantName != null) {
                try {
                    variant = Ocelot.Type.valueOf((String)this.variantName.toUpperCase());
                }
                catch (Exception exception) {}
            } else {
                variant = Ocelot.Type.WILD_OCELOT;
            }
            ocelot.setCatType(variant);
        }
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            color = DyeColor.WHITE;
            if (this.variantName != null) {
                try {
                    color = DyeColor.valueOf((String)this.variantName.toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sheep.setColor(color);
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (this.variantName != null) {
                color = DyeColor.RED;
                try {
                    color = DyeColor.valueOf((String)this.variantName.toUpperCase());
                    wolf.setTamed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                wolf.setCollarColor(color);
            }
        }
        this.targeting.ignoreEntity(entity);
        return entity;
    }

    @Override
    public SpellResult start(CastContext context) {
        if (this.entity == null && this.entityType != null) {
            Location location = context.getEyeLocation();
            this.setEntity(context.getController(), CompatibilityUtils.spawnEntity(location, this.entityType, this.spawnReason));
        }
        if (this.entity == null) {
            return SpellResult.FAIL;
        }
        return super.start(context);
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.entity == null) {
            return SpellResult.FAIL;
        }
        SpellResult result = super.step(context);
        Location target = this.actionContext.getTargetLocation();
        if (this.locationOffset != null) {
            target = target.clone().add(this.locationOffset);
        }
        if (this.doVelocity) {
            Vector velocity = this.velocity.clone().multiply(this.distanceTravelledThisTick);
            if (this.velocityOffset != null) {
                velocity = velocity.add(this.velocityOffset);
            }
            this.entity.setVelocity(velocity);
        }
        Location currentLocation = this.entity.getLocation();
        if (this.doTeleport) {
            if (!this.orient) {
                target.setYaw(currentLocation.getYaw());
                target.setPitch(currentLocation.getPitch());
            }
            this.entity.teleport(target);
        }
        return result;
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        if (this.entity != null) {
            this.entity.remove();
            this.entity = null;
        }
    }
}

