/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.slikey.effectlib.math.VectorTransform;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CustomProjectileAction
extends CompoundAction {
    private int interval;
    private int lifetime;
    private int attachDuration;
    private int range;
    private double minRange;
    private double minEntityRange;
    private double minBlockRange;
    private double speed;
    private VectorTransform velocityTransform;
    private double spread;
    private double movementSpread;
    private double maxSpread;
    private int startDistance;
    private String projectileEffectKey;
    private String hitEffectKey;
    private String missEffectKey;
    private String headshotEffectKey;
    private String tickEffectKey;
    private double gravity;
    private double drag;
    private double tickSize;
    private boolean reorient;
    private boolean useWandLocation;
    private boolean useEyeLocation;
    private boolean useTargetLocation;
    private boolean trackEntity;
    private double trackCursorRange;
    private double trackSpeed;
    private int targetSelfTimeout;
    private Boolean targetSelf;
    private boolean breaksBlocks;
    private double targetBreakables;
    private int targetBreakableSize;
    private boolean bypassBackfire;
    private boolean reverseDirection;
    private int blockHitLimit;
    private int entityHitLimit;
    private int reflectLimit;
    private int pitchMin;
    private int pitchMax;
    private boolean ignoreTargeting;
    private boolean reflectReorient;
    private boolean reflectResetDistanceTraveled;
    private boolean reflectTargetCaster;
    private boolean reflectTrackEntity;
    private double reflectTrackCursorRange;
    protected Targeting targeting;
    protected Location launchLocation;
    protected long flightTime;
    protected double distanceTravelled;
    protected double distanceTravelledThisTick;
    protected Vector velocity = null;
    private double effectDistanceTravelled;
    private boolean hasTickActions;
    private boolean hasTickEffects;
    private boolean hasStepEffects;
    private boolean hasBlockMissEffects;
    private boolean hasPreHitEffects;
    private Vector attachedOffset;
    private long attachedDeadline;
    private int entityHitCount;
    private int blockHitCount;
    private int reflectCount;
    private boolean missed;
    private long lastUpdate;
    private long nextUpdate;
    private long deadline;
    private long targetSelfDeadline;
    private DynamicLocation effectLocation = null;
    private Collection<EffectPlay> activeProjectileEffects;
    private Queue<PlanStep> plan;
    private Collection<ConfigurationSection> planConfiguration;
    private boolean returnToCaster;
    private Vector returnOffset;
    private Vector returnRelativeOffset;
    private boolean resetTimeOnPathChange;
    private Double returnDistanceAway = null;
    private boolean updateLaunchLocation;
    private Vector previousLocation;
    private boolean projectileFollowPlayer;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.targeting = new Targeting();
    }

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        this.finishEffects();
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        this.addHandler(spell, "actions");
        this.addHandler(spell, "headshot");
        this.addHandler(spell, "miss");
        this.addHandler(spell, "tick");
    }

    public void modifyParameters(ConfigurationSection parameters) {
        this.gravity = parameters.getDouble("gravity", this.gravity);
        this.drag = parameters.getDouble("drag", this.drag);
        this.reorient = parameters.getBoolean("reorient", this.reorient);
        this.trackEntity = parameters.getBoolean("track_target", this.trackEntity);
        this.trackCursorRange = parameters.getDouble("track_range", this.trackCursorRange);
        this.trackSpeed = parameters.getDouble("track_speed", this.trackSpeed);
        if (parameters.contains("velocity_transform")) {
            ConfigurationSection transformParameters = ConfigurationUtils.getConfigurationSection(parameters, "velocity_transform");
            if (transformParameters != null) {
                this.velocityTransform = new VectorTransform(transformParameters);
            } else if (parameters.contains("velocity_transform")) {
                this.velocityTransform = null;
            }
        }
        this.speed = parameters.getDouble("speed", this.speed);
        this.speed = parameters.getDouble("velocity", this.speed * 20.0);
        this.tickSize = parameters.getDouble("tick_size", this.tickSize);
        this.ignoreTargeting = parameters.getBoolean("ignore_targeting", this.ignoreTargeting);
        this.returnToCaster = parameters.getBoolean("return_to_caster", this.returnToCaster);
        this.resetTimeOnPathChange = parameters.getBoolean("reset_time_on_path_change", this.resetTimeOnPathChange);
        this.updateLaunchLocation = parameters.getBoolean("update_launch_location", this.updateLaunchLocation);
        this.projectileFollowPlayer = parameters.getBoolean("projectile_follow_player", this.projectileFollowPlayer);
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.gravity = 0.0;
        this.drag = 0.0;
        this.reorient = false;
        this.trackEntity = false;
        this.trackCursorRange = 0.0;
        this.trackSpeed = 0.0;
        this.velocityTransform = null;
        this.speed = 1.0;
        this.tickSize = 0.5;
        this.ignoreTargeting = false;
        this.returnToCaster = false;
        this.resetTimeOnPathChange = false;
        this.updateLaunchLocation = false;
        this.projectileFollowPlayer = false;
        this.modifyParameters(parameters);
        this.targeting.processParameters(parameters);
        this.interval = parameters.getInt("interval", 30);
        this.lifetime = parameters.getInt("lifetime", 8000);
        this.attachDuration = parameters.getInt("attach_duration", 0);
        this.reverseDirection = parameters.getBoolean("reverse", false);
        this.startDistance = parameters.getInt("start", 0);
        this.range = parameters.getInt("range", 0);
        this.minEntityRange = parameters.getDouble("min_entity_range", 0.0);
        this.minBlockRange = parameters.getDouble("min_block_range", 0.0);
        this.minRange = parameters.getDouble("min_entity_range", Math.max(this.minEntityRange, this.minBlockRange));
        if (this.minRange < Math.max(this.minEntityRange, this.minBlockRange)) {
            this.minRange = Math.max(this.minEntityRange, this.minBlockRange);
        }
        this.projectileEffectKey = parameters.getString("projectile_effects", "projectile");
        this.headshotEffectKey = parameters.getString("headshot_effects", "headshot");
        this.hitEffectKey = parameters.getString("hit_effects", "hit");
        this.missEffectKey = parameters.getString("miss_effects", "miss");
        this.tickEffectKey = parameters.getString("tick_effects", "tick");
        this.useWandLocation = parameters.getBoolean("use_wand_location", true);
        this.useEyeLocation = parameters.getBoolean("use_eye_location", true);
        this.useTargetLocation = parameters.getBoolean("use_target_location", true);
        this.targetSelfTimeout = parameters.getInt("target_self_timeout", 0);
        this.targetSelf = parameters.contains("target_self") ? Boolean.valueOf(parameters.getBoolean("target_self")) : null;
        this.breaksBlocks = parameters.getBoolean("break_blocks", true);
        this.targetBreakables = parameters.getDouble("target_breakables", 1.0);
        this.targetBreakableSize = parameters.getInt("breakable_size", 1);
        this.bypassBackfire = parameters.getBoolean("bypass_backfire", false);
        this.spread = parameters.getDouble("spread", 0.0);
        this.maxSpread = parameters.getDouble("spread_max", 0.0);
        this.movementSpread = parameters.getDouble("spread_movement", 0.0);
        int hitLimit = parameters.getInt("hit_count", 1);
        this.entityHitLimit = parameters.getInt("entity_hit_count", hitLimit);
        this.blockHitLimit = parameters.getInt("block_hit_count", hitLimit);
        this.reflectLimit = parameters.getInt("reflect_count", -1);
        this.pitchMin = parameters.getInt("pitch_min", 90);
        this.pitchMax = parameters.getInt("pitch_max", -90);
        this.reflectReorient = parameters.getBoolean("reflect_reorient", false);
        this.reflectResetDistanceTraveled = parameters.getBoolean("reflect_reset_distance_traveled", true);
        this.reflectTargetCaster = parameters.getBoolean("reflect_target_caster", true);
        this.reflectTrackEntity = parameters.getBoolean("reflect_track_target", false);
        this.reflectTrackCursorRange = parameters.getDouble("reflect_track_range", 0.0);
        this.returnOffset = ConfigurationUtils.getVector(parameters, "return_offset");
        this.returnRelativeOffset = ConfigurationUtils.getVector(parameters, "return_relative_offset");
        this.range = (int)((float)this.range * context.getMage().getRangeMultiplier());
        TargetType targetType = this.targeting.getTargetType();
        if (targetType == TargetType.NONE) {
            this.targeting.setTargetType(TargetType.OTHER);
        }
        this.hasTickEffects = context.getEffects(this.tickEffectKey).size() > 0;
        this.hasBlockMissEffects = context.getEffects("blockmiss").size() > 0;
        this.hasStepEffects = context.getEffects("step").size() > 0;
        this.hasPreHitEffects = context.getEffects("prehit").size() > 0;
        ActionHandler handler = this.getHandler("tick");
        this.hasTickActions = handler != null && handler.size() > 0;
        this.planConfiguration = ConfigurationUtils.getNodeList(parameters, "plan");
    }

    @Override
    public boolean next(CastContext context) {
        return !this.missed && this.entityHitCount < this.entityHitLimit && this.blockHitCount < this.blockHitLimit;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.targeting.reset();
        long now = System.currentTimeMillis();
        this.nextUpdate = 0L;
        this.distanceTravelled = 0.0;
        this.lastUpdate = 0L;
        this.deadline = now + (long)this.lifetime;
        this.targetSelfDeadline = this.targetSelfTimeout > 0 ? now + (long)this.targetSelfTimeout : 0L;
        this.effectLocation = null;
        this.velocity = null;
        this.activeProjectileEffects = null;
        this.entityHitCount = 0;
        this.blockHitCount = 0;
        this.reflectCount = 0;
        this.attachedDeadline = 0L;
        this.attachedOffset = null;
        this.missed = false;
        this.returnDistanceAway = null;
        if (this.planConfiguration != null && !this.planConfiguration.isEmpty()) {
            this.plan = new LinkedList<PlanStep>();
            for (ConfigurationSection planStepConfig : this.planConfiguration) {
                this.plan.add(new PlanStep(planStepConfig));
            }
        } else {
            this.plan = null;
        }
    }

    @Override
    public SpellResult start(CastContext context) {
        if (this.movementSpread > 0.0) {
            double entitySpeed;
            Entity sourceEntity = context.getEntity();
            double d = entitySpeed = sourceEntity != null ? sourceEntity.getVelocity().lengthSquared() : 0.0;
            if (entitySpeed > 0.01) {
                this.spread += Math.min(this.movementSpread * entitySpeed, this.maxSpread);
                context.getMage().sendDebugMessage(ChatColor.DARK_RED + " Applying spread of " + ChatColor.RED + this.spread + ChatColor.DARK_RED + " from speed^2 of " + ChatColor.GOLD + entitySpeed, 3);
            }
        }
        return super.start(context);
    }

    @Override
    public SpellResult step(CastContext context) {
        boolean minHeight;
        Vector targetLocation;
        long now = System.currentTimeMillis();
        if (now < this.nextUpdate) {
            return SpellResult.PENDING;
        }
        if (this.attachedDeadline > 0L) {
            Entity targetEntity = this.actionContext.getTargetEntity();
            if (this.attachedOffset != null && targetEntity != null) {
                Location targetLocation2 = targetEntity.getLocation();
                targetLocation2.add(this.attachedOffset);
                this.actionContext.setTargetLocation(targetLocation2);
                if (this.effectLocation != null) {
                    this.effectLocation.updateFrom(targetLocation2);
                }
            }
            if (now > this.attachedDeadline) {
                return this.finishAttach();
            }
            return SpellResult.PENDING;
        }
        if (now > this.deadline) {
            return this.miss();
        }
        if (this.targetSelfDeadline > 0L && now > this.targetSelfDeadline) {
            this.targetSelfDeadline = 0L;
            context.setTargetsCaster(true);
        }
        this.nextUpdate = now + (long)this.interval;
        Location projectileLocation = null;
        if (this.velocity == null) {
            Location targetLocation3 = context.getTargetLocation();
            projectileLocation = this.useWandLocation ? context.getWandLocation().clone() : (this.useEyeLocation ? context.getEyeLocation().clone() : context.getLocation().clone());
            if ((float)this.pitchMin < projectileLocation.getPitch()) {
                projectileLocation.setPitch((float)this.pitchMin);
            } else if ((float)this.pitchMax > projectileLocation.getPitch()) {
                projectileLocation.setPitch((float)this.pitchMax);
            }
            this.launchLocation = projectileLocation.clone();
            if (targetLocation3 != null && !this.reorient && this.useTargetLocation) {
                this.velocity = targetLocation3.toVector().subtract(projectileLocation.toVector()).normalize();
                this.launchLocation.setDirection(this.velocity);
            } else {
                this.velocity = context.getDirection().clone().normalize();
            }
            if (this.spread > 0.0) {
                Random random = context.getRandom();
                this.velocity.setX(this.velocity.getX() + (random.nextDouble() * this.spread - this.spread / 2.0));
                this.velocity.setY(this.velocity.getY() + (random.nextDouble() * this.spread - this.spread / 2.0));
                this.velocity.setZ(this.velocity.getZ() + (random.nextDouble() * this.spread - this.spread / 2.0));
                this.velocity.normalize();
            }
            if (this.startDistance != 0) {
                projectileLocation.add(this.velocity.clone().multiply(this.startDistance));
            }
            if (this.reverseDirection) {
                this.velocity = this.velocity.multiply(-1);
            }
            projectileLocation.setDirection(this.velocity);
            this.actionContext.setTargetLocation(projectileLocation);
            this.actionContext.setTargetEntity(null);
            this.actionContext.setDirection(this.velocity);
            this.startProjectileEffects(context, this.projectileEffectKey);
        } else {
            projectileLocation = this.actionContext.getTargetLocation();
            if (this.effectLocation != null) {
                this.effectLocation.updateFrom(projectileLocation);
                this.effectLocation.setDirection(this.velocity);
            }
        }
        if (this.plan != null && !this.plan.isEmpty()) {
            PlanStep next = this.plan.peek();
            if (next.distance > 0.0 && this.distanceTravelled > next.distance || next.time > 0L && this.flightTime > next.time || next.returnBuffer > 0.0 && this.returnDistanceAway != null && this.returnDistanceAway < next.returnBuffer) {
                this.plan.remove();
                if (next.parameters != null) {
                    this.modifyParameters(next.parameters);
                }
                if (next.effectsKey != null) {
                    this.startProjectileEffects(context, next.effectsKey);
                }
                context.getMage().sendDebugMessage("Changing flight plan at distance " + (int)this.distanceTravelled + " and time " + this.flightTime, 4);
                if (this.resetTimeOnPathChange) {
                    this.flightTime = 0L;
                }
            }
        }
        if (this.updateLaunchLocation) {
            this.launchLocation = context.getWandLocation().clone();
        }
        long delta = this.lastUpdate > 0L ? now - this.lastUpdate : 50L;
        this.lastUpdate = now;
        this.flightTime += delta;
        Vector targetVelocity = null;
        if (this.trackEntity) {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity != null && targetEntity.isValid() && context.canTarget(targetEntity)) {
                Location targetLocation4 = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getEyeLocation() : targetEntity.getLocation();
                targetVelocity = targetLocation4.toVector().subtract(projectileLocation.toVector()).normalize();
            }
        } else if (this.trackCursorRange > 0.0) {
            Vector playerCursor = context.getMage().getDirection().clone().normalize();
            Vector targetPoint = playerCursor.multiply(this.trackCursorRange);
            Vector worldPoint = targetPoint.add(context.getMage().getEyeLocation().clone().toVector());
            Vector projectileOffset = worldPoint.subtract(projectileLocation.clone().toVector());
            targetVelocity = projectileOffset.normalize();
        } else if (this.reorient) {
            targetVelocity = context.getMage().getDirection().clone().normalize();
        } else {
            if (this.gravity > 0.0) {
                this.velocity.setY(this.velocity.getY() - this.gravity * (double)delta / 50.0).normalize();
            }
            if (this.drag > 0.0) {
                this.speed -= this.drag * (double)delta / 50.0;
                if (this.speed <= 0.0) {
                    return this.miss();
                }
            }
        }
        if (targetVelocity != null) {
            if (this.trackSpeed > 0.0) {
                double steerDistanceSquared = this.trackSpeed * this.trackSpeed;
                double distanceSquared = targetVelocity.distanceSquared(this.velocity);
                if (distanceSquared <= steerDistanceSquared) {
                    this.velocity = targetVelocity;
                } else {
                    Vector targetDirection = targetVelocity.subtract(this.velocity).normalize().multiply(steerDistanceSquared);
                    this.velocity.add(targetDirection);
                }
            } else {
                this.velocity = targetVelocity;
            }
            this.launchLocation.setDirection(this.velocity);
        }
        if (this.velocityTransform != null && (targetVelocity = this.velocityTransform.get(this.launchLocation, (double)this.flightTime / 1000.0)) != null) {
            this.speed = targetVelocity.length();
            if (this.speed > 0.0) {
                targetVelocity.normalize();
            } else {
                targetVelocity.setX(1);
            }
            this.velocity = targetVelocity;
        }
        if (this.returnToCaster) {
            targetLocation = context.getMage().getEyeLocation().toVector();
            if (this.returnOffset != null) {
                targetLocation.add(this.returnOffset);
            }
            if (this.returnRelativeOffset != null) {
                Vector relativeOffset = VectorUtils.rotateVector(this.returnRelativeOffset, context.getMage().getEyeLocation());
                targetLocation.add(relativeOffset);
            }
            Vector projectileOffset = targetLocation.clone().subtract(projectileLocation.toVector());
            this.returnDistanceAway = projectileOffset.length();
            this.velocity = projectileOffset.normalize();
        }
        if (this.projectileFollowPlayer) {
            Vector currentLocation = context.getMage().getLocation().toVector();
            if (this.previousLocation != null) {
                Vector offset = currentLocation.clone().subtract(this.previousLocation);
                this.previousLocation = currentLocation;
                this.velocity = this.velocity.add(offset);
            } else {
                this.previousLocation = currentLocation;
            }
        }
        projectileLocation.setDirection(this.velocity);
        this.distanceTravelledThisTick = this.speed * (double)delta / 1000.0;
        if (this.range > 0) {
            this.distanceTravelledThisTick = Math.min(this.distanceTravelledThisTick, (double)this.range - this.distanceTravelled);
        }
        context.addWork((int)Math.ceil(this.distanceTravelledThisTick));
        Targeting.TargetingResult targetingResult = Targeting.TargetingResult.MISS;
        Target target = null;
        if (!this.ignoreTargeting) {
            this.targeting.start(projectileLocation);
            target = this.targeting.target(this.actionContext, this.distanceTravelledThisTick);
            targetingResult = this.targeting.getResult();
            targetLocation = target.getLocation();
            boolean keepGoing = this.distanceTravelled < this.minRange;
            Location tempLocation = projectileLocation.clone();
            int checkIterations = 0;
            while (keepGoing) {
                if (targetingResult == Targeting.TargetingResult.MISS) {
                    keepGoing = false;
                    continue;
                }
                if (targetingResult != null && targetLocation.distance(projectileLocation) + this.distanceTravelled >= this.minRange) {
                    keepGoing = false;
                    continue;
                }
                if (targetLocation.distance(projectileLocation) + this.distanceTravelled >= this.minEntityRange && targetingResult == Targeting.TargetingResult.ENTITY) {
                    keepGoing = false;
                    continue;
                }
                if (targetLocation.distance(projectileLocation) + this.distanceTravelled >= this.minBlockRange && targetingResult == Targeting.TargetingResult.BLOCK) {
                    keepGoing = false;
                    continue;
                }
                if (targetLocation.distance(projectileLocation) >= this.distanceTravelledThisTick) {
                    keepGoing = false;
                    continue;
                }
                if (checkIterations > 1000) {
                    keepGoing = false;
                    continue;
                }
                if (tempLocation.distance(projectileLocation) < targetLocation.distance(projectileLocation)) {
                    tempLocation.add(this.velocity.clone().multiply(targetLocation.distance(projectileLocation) + 0.1));
                } else {
                    tempLocation.add(this.velocity.clone().multiply(0.2));
                }
                this.actionContext.setTargetLocation(tempLocation);
                this.actionContext.setTargetEntity(null);
                this.actionContext.setDirection(this.velocity);
                this.targeting.start(tempLocation);
                target = this.targeting.target(this.actionContext, this.distanceTravelledThisTick - tempLocation.distance(projectileLocation));
                targetingResult = this.targeting.getResult();
                targetLocation = target.getLocation();
                ++checkIterations;
            }
        }
        if (targetingResult == Targeting.TargetingResult.MISS) {
            if (this.hasBlockMissEffects && target != null) {
                this.actionContext.setTargetLocation(target.getLocation());
                this.actionContext.playEffects("blockmiss");
            }
            targetLocation = projectileLocation.clone().add(this.velocity.clone().multiply(this.distanceTravelledThisTick));
            context.getMage().sendDebugMessage(ChatColor.DARK_BLUE + "Projectile miss: " + ChatColor.DARK_PURPLE + " at " + targetLocation.getBlock().getType() + " : " + targetLocation.toVector() + " from range of " + this.distanceTravelledThisTick + " over time " + delta, 14);
        } else {
            if (this.hasPreHitEffects) {
                this.actionContext.playEffects("prehit");
            }
            if ((targetLocation = target.getLocation()) == null) {
                targetLocation = projectileLocation;
                context.getLogger().warning("Targeting hit, with no target location: " + (Object)((Object)targetingResult) + " with " + (Object)((Object)this.targeting.getTargetType()) + " from " + context.getSpell().getName());
            }
            context.getMage().sendDebugMessage(ChatColor.BLUE + "Projectile hit: " + ChatColor.LIGHT_PURPLE + targetingResult.name().toLowerCase() + ChatColor.BLUE + " at " + ChatColor.GOLD + targetLocation.getBlock().getType() + ChatColor.BLUE + " from " + ChatColor.GRAY + projectileLocation.getBlock() + ChatColor.BLUE + " to " + ChatColor.GRAY + targetLocation.toVector() + ChatColor.BLUE + " from range of " + ChatColor.GOLD + this.distanceTravelledThisTick + ChatColor.BLUE + " over time " + ChatColor.DARK_PURPLE + delta, 8);
            this.distanceTravelledThisTick = targetLocation.distance(projectileLocation);
        }
        this.distanceTravelled += this.distanceTravelledThisTick;
        this.effectDistanceTravelled += this.distanceTravelledThisTick;
        int y = targetLocation.getBlockY();
        boolean maxHeight = y >= targetLocation.getWorld().getMaxHeight();
        boolean bl = minHeight = y <= 0;
        if (maxHeight) {
            targetLocation.setY((double)targetLocation.getWorld().getMaxHeight());
        } else if (minHeight) {
            targetLocation.setY(0.0);
        }
        if (this.hasTickEffects && this.effectDistanceTravelled > this.tickSize) {
            Vector speedVector = this.velocity.clone().multiply(this.tickSize);
            for (int i = 0; i < 256; ++i) {
                this.actionContext.setTargetLocation(projectileLocation);
                this.actionContext.playEffects(this.tickEffectKey);
                projectileLocation.add(speedVector);
                this.effectDistanceTravelled -= this.tickSize;
                if (this.effectDistanceTravelled < this.tickSize) break;
            }
        }
        this.actionContext.setTargetLocation((Location)targetLocation);
        if (target != null) {
            this.actionContext.setTargetEntity(target.getEntity());
        }
        if (this.hasStepEffects) {
            this.actionContext.playEffects("step");
        }
        if (maxHeight || minHeight) {
            return this.miss();
        }
        if (this.range > 0 && this.distanceTravelled >= (double)this.range) {
            return this.miss();
        }
        Block block = targetLocation.getBlock();
        if (!block.getChunk().isLoaded()) {
            return this.miss();
        }
        if (this.distanceTravelled < this.minRange && targetingResult != null) {
            if (this.distanceTravelled >= this.minBlockRange && targetingResult == Targeting.TargetingResult.BLOCK) {
                return this.miss();
            }
            if (this.distanceTravelled >= this.minEntityRange && targetingResult == Targeting.TargetingResult.ENTITY) {
                return this.miss();
            }
        } else {
            if (targetingResult == Targeting.TargetingResult.BLOCK) {
                return this.hitBlock(block);
            }
            if (targetingResult == Targeting.TargetingResult.ENTITY) {
                return this.hitEntity(target);
            }
        }
        if (this.hasTickActions) {
            return this.startActions("tick");
        }
        return SpellResult.PENDING;
    }

    protected void reflect(Vector normal, double offset) {
        this.trackEntity = this.reflectTrackEntity;
        this.reorient = this.reflectReorient;
        if (this.reflectResetDistanceTraveled) {
            this.distanceTravelled = 0.0;
        }
        if (this.reflectTrackCursorRange >= 0.0) {
            this.trackCursorRange = this.reflectTrackCursorRange;
        }
        if (this.reflectTargetCaster) {
            this.actionContext.setTargetsCaster(true);
        }
        if (normal != null) {
            this.velocity.multiply(-1);
            this.velocity = this.velocity.subtract(normal.multiply(2.0 * this.velocity.dot(normal))).normalize();
            this.velocity.multiply(-1);
        }
        this.actionContext.setTargetLocation(this.actionContext.getTargetLocation().add(this.velocity.clone().multiply(offset)));
        this.actionContext.getMage().sendDebugMessage(ChatColor.AQUA + "Projectile reflected: " + ChatColor.LIGHT_PURPLE + " with normal vector of " + ChatColor.LIGHT_PURPLE + normal, 4);
        this.actionContext.playEffects("reflect");
        ++this.reflectCount;
    }

    protected SpellResult hitBlock(Block block) {
        double reflective;
        boolean continueProjectile = false;
        if ((this.reflectLimit < 0 || this.reflectCount < this.reflectLimit) && !this.bypassBackfire && this.actionContext.isReflective(block) && ((reflective = this.actionContext.getReflective(block).doubleValue()) >= 1.0 || this.actionContext.getRandom().nextDouble() < reflective)) {
            Location targetLocation = this.actionContext.getTargetLocation();
            Vector normal = CompatibilityUtils.getNormal(block, targetLocation);
            this.reflect(normal, 0.05);
            continueProjectile = true;
        }
        if (this.targetBreakables > 0.0 && this.breaksBlocks && this.actionContext.isBreakable(block)) {
            this.targetBreakables -= (double)this.targeting.breakBlock(this.actionContext, block, Math.min((double)this.targetBreakableSize, this.targetBreakables));
            if (this.targetBreakables > 0.0) {
                continueProjectile = true;
            }
        }
        this.actionContext.playEffects("hit_block");
        if (!continueProjectile) {
            ++this.blockHitCount;
        }
        return continueProjectile ? SpellResult.PENDING : this.hit();
    }

    protected SpellResult hitEntity(Target target) {
        Entity hitEntity = target.getEntity();
        Location targetLocation = this.actionContext.getTargetLocation();
        if (hitEntity instanceof Player) {
            Player hitPlayer = (Player)hitEntity;
            Mage targetMage = this.actionContext.getController().getMage(hitPlayer);
            if (hitPlayer.isBlocking()) {
                double angle = this.velocity.angle(hitPlayer.getEyeLocation().getDirection().multiply(-1));
                if ((this.reflectLimit < 0 || this.reflectCount < this.reflectLimit) && !this.bypassBackfire && targetMage.isReflected(angle)) {
                    this.velocity = hitPlayer.getEyeLocation().getDirection().normalize().multiply(this.velocity.length());
                    this.reflect(null, 0.5);
                    return SpellResult.PENDING;
                }
                if (targetMage.isBlocked(angle)) {
                    return this.miss();
                }
            }
        }
        ++this.entityHitCount;
        if (hitEntity != null && this.entityHitLimit > 1) {
            this.targeting.ignoreEntity(hitEntity);
        }
        if (hitEntity != null) {
            this.actionContext.playEffects("hit_entity");
            if (this.hasActions("headshot") && CompatibilityUtils.isHeadshot(hitEntity, targetLocation)) {
                this.actionContext.getMage().sendDebugMessage(ChatColor.GOLD + "   Projectile headshot", 3);
                return this.headshot();
            }
        }
        return this.hit();
    }

    protected SpellResult finishAttach() {
        this.attachedDeadline = 0L;
        this.finishEffects();
        return this.startActions();
    }

    protected void finishEffects() {
        if (this.activeProjectileEffects != null) {
            final Collection<EffectPlay> cancelEffects = this.activeProjectileEffects;
            this.activeProjectileEffects = null;
            Plugin plugin = this.actionContext.getPlugin();
            plugin.getServer().getScheduler().scheduleSyncDelayedTask(plugin, new Runnable(){

                @Override
                public void run() {
                    for (EffectPlay play : cancelEffects) {
                        play.cancel();
                    }
                }
            }, 1L);
        }
    }

    protected SpellResult attach() {
        Location targetLocation;
        this.attachedDeadline = System.currentTimeMillis() + (long)this.attachDuration;
        Entity targetEntity = this.actionContext == null ? null : this.actionContext.getTargetEntity();
        Location location = targetLocation = this.actionContext == null ? null : this.actionContext.getTargetLocation();
        if (targetEntity != null && targetLocation != null) {
            this.attachedOffset = targetLocation.toVector().subtract(targetEntity.getLocation().toVector());
        }
        if (this.actionContext != null) {
            this.actionContext.playEffects(this.hitEffectKey);
        }
        return SpellResult.PENDING;
    }

    protected SpellResult headshot() {
        this.finishEffects();
        if (this.actionContext == null) {
            return SpellResult.NO_ACTION;
        }
        this.actionContext.playEffects(this.headshotEffectKey);
        return this.startActions("headshot");
    }

    protected SpellResult hit() {
        if (this.attachDuration > 0) {
            return this.attach();
        }
        this.finishEffects();
        if (this.actionContext == null) {
            return SpellResult.NO_ACTION;
        }
        this.actionContext.playEffects(this.hitEffectKey);
        if (this.targetSelf != null) {
            this.actionContext.setTargetsCaster(this.targetSelf);
        }
        return this.startActions();
    }

    protected SpellResult miss() {
        this.missed = true;
        this.finishEffects();
        if (this.actionContext == null) {
            return SpellResult.NO_ACTION;
        }
        this.actionContext.playEffects(this.missEffectKey);
        return this.startActions("miss");
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("interval");
        parameters.add("lifetime");
        parameters.add("speed");
        parameters.add("start");
        parameters.add("gravity");
        parameters.add("drag");
        parameters.add("target_entities");
        parameters.add("track_target");
        parameters.add("spread");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("speed") || parameterKey.equals("lifetime") || parameterKey.equals("interval") || parameterKey.equals("start") || parameterKey.equals("size") || parameterKey.equals("gravity") || parameterKey.equals("drag") || parameterKey.equals("tick_size") || parameterKey.equals("spread")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("target_entities") || parameterKey.equals("track_target")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }

    protected void startProjectileEffects(CastContext context, String effectKey) {
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> projectileEffects = context.getEffects(effectKey);
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer apiEffectPlayer : projectileEffects) {
            if (this.effectLocation == null) {
                this.effectLocation = new DynamicLocation(this.actionContext.getTargetLocation());
                this.effectLocation.setDirection(this.velocity);
            }
            if (this.activeProjectileEffects == null) {
                this.activeProjectileEffects = new ArrayList<EffectPlay>();
            }
            if (!(apiEffectPlayer instanceof EffectPlayer)) continue;
            EffectPlayer effectPlayer = (EffectPlayer)apiEffectPlayer;
            effectPlayer.setEffectPlayList(this.activeProjectileEffects);
            effectPlayer.startEffects(this.effectLocation, null);
        }
    }

    private class PlanStep {
        public double distance;
        public long time;
        public double returnBuffer;
        public ConfigurationSection parameters;
        public String effectsKey;

        public PlanStep(ConfigurationSection planConfig) {
            this.distance = planConfig.getDouble("distance");
            this.time = planConfig.getLong("time");
            this.effectsKey = planConfig.getString("effects");
            this.returnBuffer = planConfig.getDouble("return_buffer");
            this.parameters = planConfig;
        }
    }
}

