/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.wand.Wand;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PWTest {
    private final MagicAPI api;

    public PWTest(MagicAPI api) {
        this.api = api;
    }

    public boolean isWand(ItemStack item) {
        return item != null && this.api.isWand(item) && this.api.getWand(item).getTemplateKey().equalsIgnoreCase("wand");
    }

    public int getWandCount(Player player) {
        int count = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item == null || !this.isWand(item)) continue;
            ++count;
        }
        return count;
    }

    public boolean hasWand(Player player) {
        return this.getWandCount(player) > 0;
    }

    public Wand getWand(Player player) {
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (!this.isWand(item)) continue;
            return this.api.getWand(item);
        }
        return null;
    }

    public void AddSpell(Player player, String spell) {
        Wand wand = this.getWand(player);
        if (wand == null) {
            Bukkit.getLogger().info("You don't have a wand!");
            return;
        }
        Bukkit.getLogger().info(wand.getTemplateKey());
        if (wand.addSpell(spell)) {
            Bukkit.getLogger().info("Adding spell " + spell + " to " + player.getName() + "'s wand");
        } else {
            Bukkit.getLogger().warning("Unable to add spell " + spell + " to " + player.getName() + "'s wand");
        }
        wand.setActiveSpell(spell);
    }
}

