/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.traders;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import net.dandielo.core.items.dItem;
import net.dandielo.core.items.serialize.Attribute;
import net.dandielo.core.items.serialize.ItemAttribute;
import org.bukkit.inventory.ItemStack;

@Attribute(name="Magic Spell", key="magic_spell", priority=5)
public class SpellAttr
extends ItemAttribute {
    private String spellKey;

    public SpellAttr(dItem item, String key) {
        super(item, key);
    }

    public void onAssign(ItemStack itemStack, boolean unused) {
        if (itemStack != null && this.spellKey != null && !this.spellKey.isEmpty()) {
            InventoryUtils.setMeta(itemStack, "spell", this.spellKey);
        }
    }

    public boolean onRefactor(ItemStack itemStack) {
        this.spellKey = null;
        if (itemStack != null) {
            MagicAPI api = MagicPlugin.getAPI();
            this.spellKey = api.getSpell(itemStack);
        }
        return this.spellKey != null;
    }

    public boolean similar(ItemAttribute other) {
        if (other instanceof SpellAttr) {
            return this.spellKey.equalsIgnoreCase(((SpellAttr)other).spellKey);
        }
        return false;
    }

    public boolean equals(ItemAttribute other) {
        if (other instanceof SpellAttr) {
            return this.spellKey.equalsIgnoreCase(((SpellAttr)other).spellKey);
        }
        return false;
    }

    public String serialize() {
        return this.spellKey;
    }

    public boolean deserialize(String s) {
        this.spellKey = s;
        return this.spellKey != null;
    }
}

