/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplosionController
implements Listener {
    private final MagicController controller;
    private int maxTNTPerChunk = 0;
    private int autoRollbackDuration = 10000;
    private double autoRollbackSpeed = 2.0;
    private Set<EntityType> rollbackExplosions = new HashSet<EntityType>();

    public ExplosionController(MagicController controller) {
        this.controller = controller;
    }

    public void loadProperties(ConfigurationSection properties) {
        this.maxTNTPerChunk = properties.getInt("max_tnt_per_chunk", 0);
        this.autoRollbackDuration = properties.getInt("auto_rollback_duration", 10000);
        this.autoRollbackSpeed = properties.getDouble("auto_rollback_speed", 2.0);
        this.rollbackExplosions.clear();
        List typeNames = properties.getStringList("auto_rollback_explosions");
        if (typeNames != null) {
            for (String typeName : typeNames) {
                try {
                    EntityType entityType = EntityType.valueOf((String)typeName.toUpperCase());
                    this.rollbackExplosions.add(entityType);
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Failed to parse entity type: " + typeName + " in auto_rollback_explosions");
                }
            }
        }
    }

    protected UndoList getExplosionUndo(Entity explodingEntity) {
        UndoList blockList = this.controller.getEntityUndo(explodingEntity);
        if (blockList == null && this.autoRollbackDuration > 0 && this.rollbackExplosions.contains(explodingEntity.getType())) {
            Mage mage = this.controller.getMage((CommandSender)Bukkit.getConsoleSender());
            blockList = new com.elmakers.mine.bukkit.block.UndoList(mage, "Explosion (" + explodingEntity.getType().name() + ")");
            blockList.setScheduleUndo(this.autoRollbackDuration);
            blockList.setUndoSpeed(this.autoRollbackSpeed);
            mage.registerForUndo(blockList);
        }
        return blockList;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        UndoList blockList = this.getExplosionUndo(explodingEntity);
        boolean cancel = event.isCancelled();
        boolean bl = cancel = cancel || explodingEntity.hasMetadata("cancel_explosion");
        if (blockList != null) {
            CastContext context = blockList.getContext();
            if (!cancel && context != null && !context.hasBreakPermission(explodingEntity.getLocation().getBlock())) {
                cancel = true;
            }
        }
        if (cancel) {
            event.setCancelled(true);
        } else if (this.maxTNTPerChunk > 0 && explodingEntity.getType() == EntityType.PRIMED_TNT) {
            Entity[] entities;
            Chunk chunk = explodingEntity.getLocation().getChunk();
            if (chunk == null || !chunk.isLoaded()) {
                return;
            }
            int tntCount = 0;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity == null || entity.getType() != EntityType.PRIMED_TNT) continue;
                ++tntCount;
            }
            if (tntCount > this.maxTNTPerChunk) {
                event.setCancelled(true);
            } else if (blockList != null) {
                blockList.explode(explodingEntity, event.blockList());
            }
        } else if (blockList != null) {
            blockList.explode(explodingEntity, event.blockList());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityFinalizeExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        UndoList blockList = this.getExplosionUndo(explodingEntity);
        if (blockList == null) {
            return;
        }
        if (event.isCancelled()) {
            blockList.cancelExplosion(explodingEntity);
        } else {
            this.controller.disableItemSpawn();
            try {
                blockList.finalizeExplosion(explodingEntity, event.blockList());
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error finalizing explosion", ex);
            }
            this.controller.enableItemSpawn();
        }
    }
}

