/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;

public class KillAction
extends BaseSpellAction {
    @Override
    public SpellResult perform(CastContext context) {
        Entity entity = context.getTargetEntity();
        if (!(entity instanceof Damageable)) {
            return SpellResult.NO_TARGET;
        }
        Damageable targetEntity = (Damageable)entity;
        if (targetEntity.isDead()) {
            return SpellResult.NO_TARGET;
        }
        context.registerModified((Entity)targetEntity);
        targetEntity.damage(targetEntity.getMaxHealth() * 100.0);
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

