/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.slikey.effectlib.util.VectorUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ChangeContextAction
extends CompoundAction {
    private Vector sourceOffset;
    private Vector relativeSourceOffset;
    private Vector targetOffset;
    private Vector relativeTargetOffset;
    private boolean targetCaster;
    private Boolean targetSelf;
    private boolean targetEntityLocation;
    private boolean sourceAtTarget;
    private Double sourcePitch;
    private Vector randomSourceOffset;
    private Vector randomTargetOffset;
    private Double targetDirectionSpeed;
    private Double sourceDirectionSpeed;
    private Vector sourceDirection;
    private Vector targetDirection;
    private Vector sourceDirectionOffset;
    private Vector targetDirectionOffset;
    private float relativeSourceDirectionYawOffset;
    private float relativeSourceDirectionPitchOffset;
    private float relativeTargetDirectionYawOffset;
    private float relativeTargetDirectionPitchOffset;
    private String targetLocation;
    private String sourceLocation;
    private boolean persistTarget;
    private boolean attachBlock;
    private boolean persistCaster;
    private int snapTargetToSize;
    private int sourcePitchMin;
    private int sourcePitchMax;
    private boolean orientPitch;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetEntityLocation = parameters.getBoolean("target_entity", false);
        this.targetCaster = parameters.getBoolean("target_caster", false);
        this.targetSelf = parameters.contains("target_self") ? Boolean.valueOf(parameters.getBoolean("target_self")) : null;
        this.sourceAtTarget = parameters.getBoolean("source_at_target", false);
        this.sourcePitch = ConfigurationUtils.getDouble(parameters, "source_pitch", null);
        this.sourceOffset = ConfigurationUtils.getVector(parameters, "source_offset");
        this.relativeSourceOffset = ConfigurationUtils.getVector(parameters, "relative_source_offset");
        this.targetOffset = ConfigurationUtils.getVector(parameters, "target_offset");
        this.relativeTargetOffset = ConfigurationUtils.getVector(parameters, "relative_target_offset");
        this.randomTargetOffset = ConfigurationUtils.getVector(parameters, "random_target_offset");
        this.randomSourceOffset = ConfigurationUtils.getVector(parameters, "random_source_offset");
        this.sourceDirection = ConfigurationUtils.getVector(parameters, "source_direction");
        this.targetDirection = ConfigurationUtils.getVector(parameters, "target_direction");
        this.sourceDirectionOffset = ConfigurationUtils.getVector(parameters, "source_direction_offset");
        this.targetDirectionOffset = ConfigurationUtils.getVector(parameters, "target_direction_offset");
        this.relativeSourceDirectionYawOffset = (float)parameters.getDouble("source_relative_direction_yaw_offset", 0.0);
        this.relativeSourceDirectionPitchOffset = (float)parameters.getDouble("source_relative_direction_pitch_offset", 0.0);
        this.relativeTargetDirectionYawOffset = (float)parameters.getDouble("target_relative_direction_yaw_offset", 0.0);
        this.relativeTargetDirectionPitchOffset = (float)parameters.getDouble("target_relative_direction_pitch_offset", 0.0);
        this.persistTarget = parameters.getBoolean("persist_target", false);
        this.attachBlock = parameters.getBoolean("target_attachment", false);
        this.persistCaster = parameters.getBoolean("persist_caster", false);
        this.snapTargetToSize = parameters.getInt("target_snap", 0);
        this.targetLocation = parameters.getString("target_location");
        this.sourceLocation = parameters.getString("source_location");
        this.sourcePitchMin = parameters.getInt("source_pitch_min", 90);
        this.sourcePitchMax = parameters.getInt("source_pitch_max", -90);
        this.orientPitch = parameters.getBoolean("orient_pitch", true);
        this.targetDirectionSpeed = parameters.contains("target_direction_speed") ? Double.valueOf(parameters.getDouble("target_direction_speed")) : null;
        this.sourceDirectionSpeed = parameters.contains("source_direction_speed") ? Double.valueOf(parameters.getDouble("source_direction_speed")) : null;
    }

    @Override
    public SpellResult step(CastContext context) {
        Block previousBlock;
        Vector newSource;
        Entity sourceEntity = context.getEntity();
        Location sourceLocation = context.getEyeLocation().clone();
        if (this.sourceLocation != null && (newSource = ConfigurationUtils.toVector(this.sourceLocation)) != null) {
            sourceLocation.setX(newSource.getX());
            sourceLocation.setY(newSource.getY());
            sourceLocation.setZ(newSource.getZ());
        }
        Entity targetEntity = context.getTargetEntity();
        Location targetLocation = context.getTargetLocation();
        if (targetLocation != null) {
            Vector newTarget;
            targetLocation = targetLocation.clone();
            if (this.targetLocation != null && (newTarget = ConfigurationUtils.toVector(this.targetLocation)) != null) {
                targetLocation.setX(newTarget.getX());
                targetLocation.setY(newTarget.getY());
                targetLocation.setZ(newTarget.getZ());
            }
        }
        Vector direction = context.getDirection().normalize();
        if (this.targetCaster) {
            targetEntity = sourceEntity;
            targetLocation = sourceLocation;
        } else if (this.targetEntityLocation && targetEntity != null) {
            targetLocation = targetEntity.getLocation();
        }
        if (this.attachBlock && (previousBlock = context.getPreviousBlock()) != null) {
            Location current = targetLocation;
            targetLocation = previousBlock.getLocation();
            context.getBrush().setTarget(current, targetLocation);
        }
        if (this.sourcePitch != null) {
            sourceLocation.setPitch((float)this.sourcePitch.doubleValue());
        }
        if (sourceLocation.getPitch() > (float)this.sourcePitchMin) {
            sourceLocation.setPitch((float)this.sourcePitchMin);
        } else if (sourceLocation.getPitch() < (float)this.sourcePitchMax) {
            sourceLocation.setPitch((float)this.sourcePitchMax);
        }
        if (this.sourceOffset != null) {
            sourceLocation = sourceLocation.add(this.sourceOffset);
        }
        if (this.relativeSourceOffset != null) {
            Location relativeSource = this.persistCaster ? context.getMage().getEyeLocation() : sourceLocation;
            if (!this.orientPitch) {
                relativeSource.setPitch(0.0f);
            }
            Vector offset = VectorUtils.rotateVector(this.relativeSourceOffset, relativeSource);
            sourceLocation.add(offset);
        }
        if (this.snapTargetToSize > 0 && targetLocation != null) {
            int x = targetLocation.getBlockX();
            int z = targetLocation.getBlockZ();
            int xresult = x / this.snapTargetToSize;
            int zresult = z / this.snapTargetToSize;
            boolean xneedfix = x % this.snapTargetToSize != 0;
            boolean zneedfix = z % this.snapTargetToSize != 0;
            targetLocation.setX((double)(this.snapTargetToSize * (xresult - (x < 0 && xneedfix ? 1 : 0))));
            targetLocation.setZ((double)(this.snapTargetToSize * (zresult - (z < 0 && zneedfix ? 1 : 0))));
        }
        if (this.targetOffset != null && targetLocation != null) {
            targetLocation = targetLocation.add(this.targetOffset);
        }
        if (this.relativeTargetOffset != null & targetLocation != null) {
            Location relativeTarget = this.persistCaster ? context.getMage().getEyeLocation() : targetLocation;
            if (!this.orientPitch) {
                relativeTarget.setPitch(0.0f);
            }
            Vector offset = VectorUtils.rotateVector(this.relativeTargetOffset, relativeTarget);
            targetLocation.add(offset);
        }
        if (this.randomSourceOffset != null) {
            sourceLocation = RandomUtils.randomizeLocation(sourceLocation, this.randomSourceOffset);
        }
        if (this.randomTargetOffset != null && targetLocation != null) {
            targetLocation = RandomUtils.randomizeLocation(targetLocation, this.randomTargetOffset);
        }
        if (this.relativeSourceDirectionYawOffset != 0.0f || this.relativeSourceDirectionPitchOffset != 0.0f) {
            Vector relativeDirection = sourceLocation.getDirection();
            relativeDirection = VectorUtils.rotateVector(relativeDirection, this.relativeSourceDirectionYawOffset, this.relativeSourceDirectionPitchOffset);
            sourceLocation.setDirection(relativeDirection);
        }
        if (this.relativeTargetDirectionYawOffset != 0.0f || this.relativeTargetDirectionPitchOffset != 0.0f) {
            Vector relativeDirection = targetLocation.getDirection();
            relativeDirection = VectorUtils.rotateVector(relativeDirection, this.relativeTargetDirectionYawOffset, this.relativeTargetDirectionPitchOffset);
            targetLocation.setDirection(relativeDirection);
        }
        if (this.targetDirection != null && targetLocation != null) {
            targetLocation.setDirection(this.targetDirection);
        }
        if (this.sourceDirection != null) {
            sourceLocation.setDirection(this.sourceDirection);
            direction = this.sourceDirection.clone();
        }
        if (this.targetDirectionOffset != null && targetLocation != null) {
            targetLocation.setDirection(targetLocation.getDirection().add(this.targetDirectionOffset));
        }
        if (this.sourceDirectionOffset != null) {
            sourceLocation.setDirection(direction.add(this.sourceDirectionOffset));
        }
        if (this.sourceDirectionSpeed != null) {
            sourceLocation = sourceLocation.add(direction.clone().multiply(this.sourceDirectionSpeed.doubleValue()));
        }
        if (this.targetDirectionSpeed != null && targetLocation != null) {
            targetLocation = targetLocation.add(direction.clone().multiply(this.targetDirectionSpeed.doubleValue()));
        }
        if (this.sourceAtTarget && targetLocation != null) {
            sourceLocation.setX(targetLocation.getX());
            sourceLocation.setY(targetLocation.getY());
            sourceLocation.setZ(targetLocation.getZ());
            sourceLocation.setWorld(targetLocation.getWorld());
        }
        if (this.persistTarget) {
            context.setTargetLocation(targetLocation);
        }
        context.getMage().sendDebugMessage(ChatColor.GREEN + " Set new source location to " + ChatColor.GRAY + sourceLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockZ() + ChatColor.DARK_GRAY, 6);
        if (targetLocation != null) {
            context.getMage().sendDebugMessage(ChatColor.DARK_GREEN + " Set new target location to " + ChatColor.GRAY + targetLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockZ() + ChatColor.DARK_GRAY, 6);
        }
        this.createActionContext(context, sourceEntity, sourceLocation, targetEntity, targetLocation);
        if (this.targetSelf != null) {
            this.actionContext.setTargetsCaster(this.targetSelf);
        }
        return this.startActions();
    }
}

